/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.fluid;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ModList;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.utils.SafeClientAccess;
import slimeknights.tconstruct.library.utils.TooltipKey;

public class FluidTooltipHandler {
    public static final Component HOLD_SHIFT = new TranslatableComponent(TConstruct.makeTranslationKey("gui", "fluid.hold_shift")).m_130940_(ChatFormatting.GRAY);
    private static final FluidGuiEntry KILOBUCKET = new FluidGuiEntry("kilobucket", 1000000);
    private static final FluidGuiEntry BUCKET = new FluidGuiEntry("bucket", 1000);
    private static final FluidGuiEntry MILLIBUCKET = new FluidGuiEntry("millibucket", 1);
    private static final FluidGuiEntry METAL_BLOCK = new FluidGuiEntry("block", 810);
    private static final FluidGuiEntry INGOT = new FluidGuiEntry("ingot", 90);
    private static final FluidGuiEntry NUGGET = new FluidGuiEntry("nugget", 10);
    private static final FluidGuiEntry LARGE_GEM_BLOCK = new FluidGuiEntry("block", 900);
    private static final FluidGuiEntry SMALL_GEM_BLOCK = new FluidGuiEntry("block", 400);
    private static final FluidGuiEntry GEM = new FluidGuiEntry("gem", 100);
    private static final FluidGuiEntry SHARDS = new FluidGuiEntry("shard", 25);
    private static final FluidGuiEntry BRICK_BLOCK = new FluidGuiEntry("block", 1000);
    private static final FluidGuiEntry BRICK = new FluidGuiEntry("brick", 250);
    private static final FluidGuiEntry SLIMEBLOCK = new FluidGuiEntry("block", 1000);
    private static final FluidGuiEntry SLIMEBALL = new FluidGuiEntry("slimeball", 250);
    private static final FluidGuiEntry GLASS_BLOCK = new FluidGuiEntry("block", 1000);
    private static final FluidGuiEntry PANE = new FluidGuiEntry("pane", 250);
    private static final FluidGuiEntry BOTTLE = new FluidGuiEntry("bottle", 250);
    private static final FluidGuiEntry BOWL = new FluidGuiEntry("bowl", 250);

    public static List<Component> getFluidTooltip(FluidStack fluid) {
        return FluidTooltipHandler.getFluidTooltip(fluid, fluid.getAmount());
    }

    public static List<Component> getFluidTooltip(FluidStack fluid, int amount) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        tooltip.add((Component)fluid.getDisplayName().m_6879_().m_130940_(ChatFormatting.WHITE));
        FluidTooltipHandler.appendMaterial(fluid.getFluid(), amount, tooltip);
        ModList.get().getModContainerById(Objects.requireNonNull(fluid.getFluid().getRegistryName()).m_135827_()).map(container -> container.getModInfo().getDisplayName()).ifPresent(name -> tooltip.add((Component)new TextComponent(name).m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC})));
        return tooltip;
    }

    public static void appendMaterial(FluidStack fluid, List<Component> tooltip) {
        FluidTooltipHandler.appendMaterial(fluid.getFluid(), fluid.getAmount(), tooltip);
    }

    public static void appendMaterial(Fluid fluid, int original, List<Component> tooltip) {
        if (FluidTooltipHandler.appendMaterialNoShift(fluid, original, tooltip)) {
            FluidTooltipHandler.appendShift(tooltip);
        }
    }

    public static boolean appendMaterialNoShift(Fluid fluid, int original, List<Component> tooltip) {
        int amount = original;
        if (SafeClientAccess.getTooltipKey() != TooltipKey.SHIFT) {
            if (fluid.m_205067_(TinkerTags.Fluids.METAL_TOOLTIPS)) {
                amount = METAL_BLOCK.getText(tooltip, amount);
                amount = INGOT.getText(tooltip, amount);
                amount = NUGGET.getText(tooltip, amount);
            } else if (fluid.m_205067_(TinkerTags.Fluids.LARGE_GEM_TOOLTIPS)) {
                amount = LARGE_GEM_BLOCK.getText(tooltip, amount);
                amount = GEM.getText(tooltip, amount);
                amount = SHARDS.getText(tooltip, amount);
            } else if (fluid.m_205067_(TinkerTags.Fluids.SMALL_GEM_TOOLTIPS)) {
                amount = SMALL_GEM_BLOCK.getText(tooltip, amount);
                amount = GEM.getText(tooltip, amount);
                amount = SHARDS.getText(tooltip, amount);
            } else if (fluid.m_205067_(TinkerTags.Fluids.GLASS_TOOLTIPS)) {
                amount = GLASS_BLOCK.getText(tooltip, amount);
                amount = PANE.getText(tooltip, amount);
            } else if (fluid.m_205067_(TinkerTags.Fluids.SLIME_TOOLTIPS)) {
                amount = SLIMEBLOCK.getText(tooltip, amount);
                amount = SLIMEBALL.getText(tooltip, amount);
            } else if (fluid.m_205067_(TinkerTags.Fluids.CLAY_TOOLTIPS)) {
                amount = BRICK_BLOCK.getText(tooltip, amount);
                amount = BRICK.getText(tooltip, amount);
            } else if (fluid.m_205067_(TinkerTags.Fluids.BOTTLE_TOOLTIPS)) {
                amount = BUCKET.getText(tooltip, amount);
                amount = BOTTLE.getText(tooltip, amount);
            } else if (fluid.m_205067_(TinkerTags.Fluids.SOUP_TOOLTIPS)) {
                amount = BOWL.getText(tooltip, amount);
            }
        }
        FluidTooltipHandler.appendBuckets(amount, tooltip);
        return amount != original;
    }

    public static void appendShift(List<Component> tooltip) {
        if (!SafeClientAccess.getTooltipKey().isShiftOrUnknown()) {
            tooltip.add(TextComponent.f_131282_);
            tooltip.add(HOLD_SHIFT);
        }
    }

    public static void appendIngots(int amount, List<Component> tooltip) {
        amount = INGOT.getText(tooltip, amount);
        FluidTooltipHandler.appendBuckets(amount, tooltip);
    }

    public static void appendBuckets(int amount, List<Component> tooltip) {
        amount = KILOBUCKET.getText(tooltip, amount);
        amount = BUCKET.getText(tooltip, amount);
        MILLIBUCKET.getText(tooltip, amount);
    }

    private FluidTooltipHandler() {
    }

    private record FluidGuiEntry(String translationKey, int needed) implements Comparable<FluidGuiEntry>
    {
        private FluidGuiEntry(String translationKey, int needed) {
            this.translationKey = TConstruct.makeTranslationKey("gui", "fluid." + translationKey);
            this.needed = needed;
        }

        private int getText(List<Component> tooltip, int amount) {
            int full = amount / this.needed;
            if (full > 0) {
                tooltip.add((Component)new TranslatableComponent(this.translationKey, new Object[]{full}).m_130940_(ChatFormatting.GRAY));
            }
            return amount % this.needed;
        }

        @Override
        public int compareTo(FluidGuiEntry other) {
            if (this.needed != other.needed) {
                return Integer.compare(other.needed, this.needed);
            }
            return this.translationKey.compareTo(other.translationKey);
        }
    }
}

