/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.data.recipe;

import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.DifferenceIngredient;
import net.minecraftforge.common.crafting.IntersectionIngredient;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.TrueCondition;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.mantle.registration.object.MetalItemObject;
import slimeknights.tconstruct.common.registration.CastItemObject;
import slimeknights.tconstruct.library.data.recipe.IByproduct;
import slimeknights.tconstruct.library.data.recipe.ICastCreationHelper;
import slimeknights.tconstruct.library.json.TagDifferencePresentCondition;
import slimeknights.tconstruct.library.json.TagIntersectionPresentCondition;
import slimeknights.tconstruct.library.recipe.casting.ItemCastingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.melting.IMeltingContainer;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipeBuilder;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public interface ISmelteryRecipeHelper
extends ICastCreationHelper {
    default public void tagMelting(Consumer<FinishedRecipe> consumer, Fluid fluid, int amount, String tagName, float factor, String recipePath, boolean isOptional) {
        Consumer<FinishedRecipe> wrapped = isOptional ? this.withCondition(consumer, this.tagCondition(tagName)) : consumer;
        MeltingRecipeBuilder.melting(Ingredient.m_204132_(this.getItemTag("forge", tagName)), fluid, amount, factor).save(wrapped, this.modResource(recipePath));
    }

    default public void oreMelting(Consumer<FinishedRecipe> consumer, Fluid fluid, int amount, String tagName, @Nullable TagKey<Item> size, float factor, String recipePath, boolean isOptional, IMeltingContainer.OreRateType oreRate, float byproductScale, IByproduct ... byproducts) {
        Consumer<FinishedRecipe> wrapped;
        Ingredient ingredient;
        Ingredient baseIngredient = Ingredient.m_204132_(this.getItemTag("forge", tagName));
        if (size == Tags.Items.ORE_RATES_SINGULAR) {
            ingredient = DifferenceIngredient.of((Ingredient)baseIngredient, (Ingredient)CompoundIngredient.of((Ingredient[])new Ingredient[]{Ingredient.m_204132_((TagKey)Tags.Items.ORE_RATES_SPARSE), Ingredient.m_204132_((TagKey)Tags.Items.ORE_RATES_DENSE)}));
            wrapped = this.withCondition(consumer, TagDifferencePresentCondition.ofKeys(this.getItemTag("forge", tagName), Tags.Items.ORE_RATES_SPARSE, Tags.Items.ORE_RATES_DENSE));
        } else if (size != null) {
            ingredient = IntersectionIngredient.of((Ingredient[])new Ingredient[]{baseIngredient, Ingredient.m_204132_(size)});
            wrapped = this.withCondition(consumer, TagIntersectionPresentCondition.ofKeys(this.getItemTag("forge", tagName), size));
        } else {
            ingredient = baseIngredient;
            wrapped = isOptional ? this.withCondition(consumer, this.tagCondition(tagName)) : consumer;
        }
        Supplier<MeltingRecipeBuilder> supplier = () -> MeltingRecipeBuilder.melting(ingredient, fluid, amount, factor).setOre(oreRate);
        ResourceLocation location = this.modResource(recipePath);
        if (byproducts.length == 0) {
            supplier.get().save(wrapped, location);
        } else if (byproducts[0].isAlwaysPresent()) {
            supplier.get().addByproduct(new FluidStack(byproducts[0].getFluid(), (int)((float)byproducts[0].getAmount() * byproductScale))).save(wrapped, location);
        } else {
            ConditionalRecipe.Builder builder = ConditionalRecipe.builder();
            boolean alwaysPresent = false;
            for (IByproduct byproduct : byproducts) {
                alwaysPresent = byproduct.isAlwaysPresent();
                if (alwaysPresent) {
                    builder.addCondition((ICondition)TrueCondition.INSTANCE);
                } else {
                    builder.addCondition(this.tagCondition("ingots/" + byproduct.getName()));
                }
                builder.addRecipe(supplier.get().addByproduct(new FluidStack(byproduct.getFluid(), (int)((float)byproduct.getAmount() * byproductScale)))::save);
                if (alwaysPresent) break;
            }
            if (!alwaysPresent) {
                builder.addCondition((ICondition)TrueCondition.INSTANCE);
                builder.addRecipe(supplier.get()::save);
            }
            builder.build(wrapped, location);
        }
    }

    default public void georeMelting(Consumer<FinishedRecipe> consumer, Fluid fluid, int unit, String name, String folder) {
        this.tagMelting(consumer, fluid, unit, "geore_shards/" + name, 1.0f, folder + "geore/shard", true);
        this.tagMelting(consumer, fluid, unit * 4, "geore_blocks/" + name, 2.0f, folder + "geore/block", true);
        this.tagMelting(consumer, fluid, unit * 4, "geore_clusters/" + name, 2.5f, folder + "geore/cluster", true);
        this.tagMelting(consumer, fluid, unit, "geore_small_buds/" + name, 1.0f, folder + "geore/bud_small", true);
        this.tagMelting(consumer, fluid, unit * 2, "geore_medium_buds/" + name, 1.5f, folder + "geore/bud_medium", true);
        this.tagMelting(consumer, fluid, unit * 3, "geore_large_buds/" + name, 2.0f, folder + "geore/bud_large", true);
    }

    default public void metalMelting(Consumer<FinishedRecipe> consumer, Fluid fluid, String name, boolean hasOre, boolean hasDust, String folder, boolean isOptional, IByproduct ... byproducts) {
        String prefix = folder + "/" + name + "/";
        this.tagMelting(consumer, fluid, 810, "storage_blocks/" + name, 3.0f, prefix + "block", isOptional);
        this.tagMelting(consumer, fluid, 90, "ingots/" + name, 1.0f, prefix + "ingot", isOptional);
        this.tagMelting(consumer, fluid, 10, "nuggets/" + name, 0.33333334f, prefix + "nugget", isOptional);
        if (hasOre) {
            this.oreMelting(consumer, fluid, 90, "raw_materials/" + name, null, 1.5f, prefix + "raw", isOptional, IMeltingContainer.OreRateType.METAL, 1.0f, byproducts);
            this.oreMelting(consumer, fluid, 810, "storage_blocks/raw_" + name, null, 6.0f, prefix + "raw_block", isOptional, IMeltingContainer.OreRateType.METAL, 9.0f, byproducts);
            this.oreMelting(consumer, fluid, 90, "ores/" + name, (TagKey<Item>)Tags.Items.ORE_RATES_SPARSE, 1.5f, prefix + "ore_sparse", isOptional, IMeltingContainer.OreRateType.METAL, 1.0f, byproducts);
            this.oreMelting(consumer, fluid, 180, "ores/" + name, (TagKey<Item>)Tags.Items.ORE_RATES_SINGULAR, 2.5f, prefix + "ore_singular", isOptional, IMeltingContainer.OreRateType.METAL, 2.0f, byproducts);
            this.oreMelting(consumer, fluid, 540, "ores/" + name, (TagKey<Item>)Tags.Items.ORE_RATES_DENSE, 4.5f, prefix + "ore_dense", isOptional, IMeltingContainer.OreRateType.METAL, 6.0f, byproducts);
            this.georeMelting(consumer, fluid, 90, name, prefix);
        }
        if (hasDust) {
            this.tagMelting(consumer, fluid, 90, "dusts/" + name, 0.75f, prefix + "dust", true);
        }
        this.tagMelting(consumer, fluid, 90, "plates/" + name, 1.0f, prefix + "plates", true);
        this.tagMelting(consumer, fluid, 360, "gears/" + name, 2.0f, prefix + "gear", true);
        this.tagMelting(consumer, fluid, 30, "coins/" + name, 0.6666667f, prefix + "coin", true);
        this.tagMelting(consumer, fluid, 45, "rods/" + name, 0.2f, prefix + "rod", true);
        this.tagMelting(consumer, fluid, 45, "wires/" + name, 0.2f, prefix + "wire", true);
        this.tagMelting(consumer, fluid, 90, "sheetmetals/" + name, 1.0f, prefix + "sheetmetal", true);
    }

    default public void metalMelting(Consumer<FinishedRecipe> consumer, Fluid fluid, String name, boolean hasOre, String folder, boolean isOptional, IByproduct ... byproducts) {
        this.metalMelting(consumer, fluid, name, hasOre, true, folder, isOptional, byproducts);
    }

    default public void gemMelting(Consumer<FinishedRecipe> consumer, Fluid fluid, String name, boolean hasOre, int blockSize, String folder, boolean isOptional, IByproduct ... byproducts) {
        String prefix = folder + "/" + name + "/";
        this.tagMelting(consumer, fluid, 100 * blockSize, "storage_blocks/" + name, (float)Math.sqrt(blockSize), prefix + "block", isOptional);
        this.tagMelting(consumer, fluid, 100, "gems/" + name, 1.0f, prefix + "gem", isOptional);
        if (hasOre) {
            this.oreMelting(consumer, fluid, 50, "ores/" + name, (TagKey<Item>)Tags.Items.ORE_RATES_SPARSE, 1.0f, prefix + "ore_sparse", isOptional, IMeltingContainer.OreRateType.GEM, 0.5f, byproducts);
            this.oreMelting(consumer, fluid, 100, "ores/" + name, (TagKey<Item>)Tags.Items.ORE_RATES_SINGULAR, 1.5f, prefix + "ore_singular", isOptional, IMeltingContainer.OreRateType.GEM, 1.0f, byproducts);
            this.oreMelting(consumer, fluid, 300, "ores/" + name, (TagKey<Item>)Tags.Items.ORE_RATES_DENSE, 4.5f, prefix + "ore_dense", isOptional, IMeltingContainer.OreRateType.GEM, 3.0f, byproducts);
            this.georeMelting(consumer, fluid, 100, name, prefix);
        }
    }

    default public void castingWithCast(Consumer<FinishedRecipe> consumer, FluidObject<?> fluid, boolean forgeTag, int amount, CastItemObject cast, ItemOutput output, String location) {
        ItemCastingRecipeBuilder.tableRecipe(output).setFluidAndTime(fluid, forgeTag, amount).setCast(cast.getMultiUseTag(), false).save(consumer, this.modResource(location + "_gold_cast"));
        ItemCastingRecipeBuilder.tableRecipe(output).setFluidAndTime(fluid, forgeTag, amount).setCast(cast.getSingleUseTag(), true).save(consumer, this.modResource(location + "_sand_cast"));
    }

    default public void castingWithCast(Consumer<FinishedRecipe> consumer, FluidObject<?> fluid, int amount, CastItemObject cast, ItemOutput output, String location) {
        this.castingWithCast(consumer, fluid, false, amount, cast, output, location);
    }

    default public void castingWithCast(Consumer<FinishedRecipe> consumer, FluidObject<?> fluid, boolean forgeTag, int amount, CastItemObject cast, ItemLike output, String location) {
        this.castingWithCast(consumer, fluid, forgeTag, amount, cast, ItemOutput.fromItem((ItemLike)output), location);
    }

    default public void castingWithCast(Consumer<FinishedRecipe> consumer, FluidObject<?> fluid, int amount, CastItemObject cast, ItemLike output, String location) {
        this.castingWithCast(consumer, fluid, amount, cast, ItemOutput.fromItem((ItemLike)output), location);
    }

    default public void tagCasting(Consumer<FinishedRecipe> consumer, FluidObject<?> fluid, boolean forgeTag, int amount, CastItemObject cast, String tagName, String recipeName, boolean optional) {
        if (optional) {
            consumer = this.withCondition(consumer, this.tagCondition(tagName));
        }
        this.castingWithCast(consumer, fluid, forgeTag, amount, cast, ItemOutput.fromTag(this.getItemTag("forge", tagName), (int)1), recipeName);
    }

    default public void tagCasting(Consumer<FinishedRecipe> consumer, FluidObject<?> fluid, int amount, CastItemObject cast, String tagName, String recipeName, boolean optional) {
        this.tagCasting(consumer, fluid, false, amount, cast, tagName, recipeName, optional);
    }

    default public void ingotCasting(Consumer<FinishedRecipe> consumer, FluidObject<?> fluid, boolean forgeTag, int amount, ItemLike ingot, String location) {
        this.castingWithCast(consumer, fluid, forgeTag, amount, TinkerSmeltery.ingotCast, ingot, location);
    }

    default public void ingotCasting(Consumer<FinishedRecipe> consumer, FluidObject<?> fluid, boolean forgeTag, ItemLike ingot, String location) {
        this.ingotCasting(consumer, fluid, forgeTag, 90, ingot, location);
    }

    default public void ingotCasting(Consumer<FinishedRecipe> consumer, FluidObject<?> fluid, int amount, ItemLike ingot, String location) {
        this.ingotCasting(consumer, fluid, false, amount, ingot, location);
    }

    default public void ingotCasting(Consumer<FinishedRecipe> consumer, FluidObject<?> fluid, ItemLike ingot, String location) {
        this.ingotCasting(consumer, fluid, 90, ingot, location);
    }

    default public void gemCasting(Consumer<FinishedRecipe> consumer, FluidObject<?> fluid, ItemLike gem, String location) {
        this.castingWithCast(consumer, fluid, 100, TinkerSmeltery.gemCast, gem, location);
    }

    default public void nuggetCasting(Consumer<FinishedRecipe> consumer, FluidObject<?> fluid, boolean forgeTag, ItemLike nugget, String location) {
        this.castingWithCast(consumer, fluid, forgeTag, 10, TinkerSmeltery.nuggetCast, nugget, location);
    }

    default public void nuggetCastingRecipe(Consumer<FinishedRecipe> consumer, FluidObject<?> fluid, ItemLike nugget, String location) {
        this.nuggetCasting(consumer, fluid, false, nugget, location);
    }

    default public void metalCasting(Consumer<FinishedRecipe> consumer, FluidObject<?> fluid, boolean forgeTag, @Nullable ItemLike block, @Nullable ItemLike ingot, @Nullable ItemLike nugget, String folder, String metal) {
        String metalFolder = folder + metal + "/";
        if (block != null) {
            ItemCastingRecipeBuilder.basinRecipe(block).setFluidAndTime(fluid, forgeTag, 810).save(consumer, this.modResource(metalFolder + "block"));
        }
        if (ingot != null) {
            this.ingotCasting(consumer, fluid, forgeTag, ingot, metalFolder + "ingot");
        }
        if (nugget != null) {
            this.nuggetCasting(consumer, fluid, forgeTag, nugget, metalFolder + "nugget");
        }
        this.tagCasting(consumer, fluid, forgeTag, 90, TinkerSmeltery.plateCast, "plates/" + metal, folder + metal + "/plate", true);
        this.tagCasting(consumer, fluid, forgeTag, 360, TinkerSmeltery.gearCast, "gears/" + metal, folder + metal + "/gear", true);
        this.tagCasting(consumer, fluid, forgeTag, 30, TinkerSmeltery.coinCast, "coins/" + metal, folder + metal + "/coin", true);
        this.tagCasting(consumer, fluid, forgeTag, 45, TinkerSmeltery.rodCast, "rods/" + metal, folder + metal + "/rod", true);
        this.tagCasting(consumer, fluid, forgeTag, 45, TinkerSmeltery.wireCast, "wires/" + metal, folder + metal + "/wire", true);
    }

    default public void metalCasting(Consumer<FinishedRecipe> consumer, FluidObject<?> fluid, @Nullable ItemLike block, @Nullable ItemLike ingot, @Nullable ItemLike nugget, String folder, String metal) {
        this.metalCasting(consumer, fluid, false, block, ingot, nugget, folder, metal);
    }

    default public void metalCasting(Consumer<FinishedRecipe> consumer, FluidObject<?> fluid, MetalItemObject metal, String folder, String name) {
        this.metalCasting(consumer, fluid, (ItemLike)metal.get(), (ItemLike)metal.getIngot(), (ItemLike)metal.getNugget(), folder, name);
    }

    default public void metalTagCasting(Consumer<FinishedRecipe> consumer, FluidObject<?> fluid, String name, String folder, boolean forceStandard) {
        this.tagCasting(consumer, fluid, true, 10, TinkerSmeltery.nuggetCast, "nuggets/" + name, folder + name + "/nugget", !forceStandard);
        this.tagCasting(consumer, fluid, true, 90, TinkerSmeltery.ingotCast, "ingots/" + name, folder + name + "/ingot", !forceStandard);
        this.tagCasting(consumer, fluid, true, 90, TinkerSmeltery.plateCast, "plates/" + name, folder + name + "/plate", true);
        this.tagCasting(consumer, fluid, true, 360, TinkerSmeltery.gearCast, "gears/" + name, folder + name + "/gear", true);
        this.tagCasting(consumer, fluid, true, 30, TinkerSmeltery.coinCast, "coins/" + name, folder + name + "/coin", true);
        this.tagCasting(consumer, fluid, true, 45, TinkerSmeltery.rodCast, "rods/" + name, folder + name + "/rod", true);
        this.tagCasting(consumer, fluid, true, 45, TinkerSmeltery.wireCast, "wires/" + name, folder + name + "/wire", true);
        TagKey<Item> block = this.getItemTag("forge", "storage_blocks/" + name);
        Consumer<FinishedRecipe> wrapped = forceStandard ? consumer : this.withCondition(consumer, this.tagCondition("storage_blocks/" + name));
        ItemCastingRecipeBuilder.basinRecipe(block).setFluidAndTime(fluid, true, 810).save(wrapped, this.modResource(folder + name + "/block"));
    }
}

