/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.modifiers;

import com.google.common.collect.ImmutableList;
import com.mojang.math.Transformation;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.mutable.MutableObject;
import slimeknights.mantle.util.ItemLayerPixels;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfo;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfoLoader;
import slimeknights.tconstruct.library.client.model.tools.MaterialModel;
import slimeknights.tconstruct.library.client.modifiers.IBakedModifierModel;
import slimeknights.tconstruct.library.client.modifiers.IUnbakedModifierModel;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class BreakableMaterialModifierModel
implements IBakedModifierModel {
    public static final IUnbakedModifierModel UNBAKED_INSTANCE = (smallGetter, largeGetter) -> {
        Material smallTexture = BreakableMaterialModifierModel.stitchMaterialTextures(smallGetter, "");
        Material brokenSmall = BreakableMaterialModifierModel.stitchMaterialTextures(smallGetter, "_broken");
        Material largeTexture = BreakableMaterialModifierModel.stitchMaterialTextures(largeGetter, "");
        Material brokenLarge = BreakableMaterialModifierModel.stitchMaterialTextures(largeGetter, "_broken");
        if (smallTexture != null || brokenSmall != null || largeTexture != null || brokenLarge != null) {
            return new BreakableMaterialModifierModel(smallTexture, brokenSmall, largeTexture, brokenLarge);
        }
        return null;
    };
    private final Material[] textures;

    @Nullable
    private static Material stitchMaterialTextures(Function<String, Material> textureGetter, String name) {
        Material baseTexture = textureGetter.apply(name);
        if (baseTexture != null) {
            for (MaterialRenderInfo info : MaterialRenderInfoLoader.INSTANCE.getAllRenderInfos()) {
                ResourceLocation texture = info.getTexture();
                if (texture != null) {
                    textureGetter.apply(name + "_" + MaterialRenderInfo.getSuffix(texture));
                }
                for (String fallback : info.getFallbacks()) {
                    textureGetter.apply(name + "_" + fallback);
                }
            }
        }
        return baseTexture;
    }

    public BreakableMaterialModifierModel(@Nullable Material normalSmall, @Nullable Material brokenSmall, @Nullable Material normalLarge, @Nullable Material brokenLarge) {
        this.textures = new Material[]{normalSmall, brokenSmall, normalLarge, brokenLarge};
    }

    @Override
    @Nullable
    public Object getCacheKey(IToolStackView tool, ModifierEntry entry) {
        ModifierId modifier = entry.getId();
        return new CacheKey(modifier, tool.getPersistentData().getString(modifier));
    }

    @Nullable
    private static MaterialVariantId getMaterial(IToolStackView tool, Modifier modifier) {
        String material = tool.getPersistentData().getString(modifier.getId());
        if (!material.isEmpty()) {
            return MaterialVariantId.tryParse(material);
        }
        return null;
    }

    @Override
    public ImmutableList<BakedQuad> getQuads(IToolStackView tool, ModifierEntry modifier, Function<Material, TextureAtlasSprite> spriteGetter, Transformation transforms, boolean isLarge, int startTintIndex, @Nullable ItemLayerPixels pixels) {
        Material texture = this.textures[(isLarge ? 2 : 0) | (tool.isBroken() ? 1 : 0)];
        if (texture != null) {
            MutableObject mutable = new MutableObject();
            MaterialModel.getPartQuads(arg_0 -> ((MutableObject)mutable).setValue(arg_0), texture, spriteGetter, transforms, -1, BreakableMaterialModifierModel.getMaterial(tool, modifier.getModifier()), pixels);
            return (ImmutableList)mutable.getValue();
        }
        return ImmutableList.of();
    }

    private record CacheKey(ModifierId modifier, String material) {
    }
}

