/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.materials;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import slimeknights.mantle.data.ISafeManagerReloadListener;
import slimeknights.tconstruct.library.client.ResourceColorManager;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.utils.Util;

public class MaterialTooltipCache {
    private static final Map<MaterialVariantId, String> KEY_CACHE = new HashMap<MaterialVariantId, String>();
    private static final Map<MaterialVariantId, TextColor> COLOR_CACHE = new HashMap<MaterialVariantId, TextColor>();
    private static final Map<MaterialVariantId, Component> DISPLAY_NAME_CACHE = new HashMap<MaterialVariantId, Component>();
    private static final Map<MaterialVariantId, Component> COLORED_DISPLAY_NAME_CACHE = new HashMap<MaterialVariantId, Component>();
    private static final ISafeManagerReloadListener RELOAD_LISTENER = manager -> {
        COLOR_CACHE.clear();
        DISPLAY_NAME_CACHE.clear();
        COLORED_DISPLAY_NAME_CACHE.clear();
    };
    private static final Function<MaterialVariantId, String> KEY_GETTER = id -> Util.makeTranslationKey("material", id.getLocation('.'));
    private static final Function<MaterialVariantId, MutableComponent> DISPLAY_NAME_GETTER = id -> {
        String variantKey;
        if (id.hasVariant() && Util.canTranslate(variantKey = MaterialTooltipCache.getKey(id))) {
            return new TranslatableComponent(variantKey);
        }
        return new TranslatableComponent(MaterialTooltipCache.getKey(id.getId()));
    };
    public static final Function<MaterialVariantId, TextColor> COLOR_GETTER = id -> {
        String variantKey;
        TextColor color;
        if (id.hasVariant() && (color = ResourceColorManager.getOrNull(variantKey = MaterialTooltipCache.getKey(id))) != null) {
            return color;
        }
        return ResourceColorManager.getTextColor(MaterialTooltipCache.getKey(id.getId()));
    };
    private static final Function<MaterialVariantId, Component> COLORED_DISPLAY_NAME_GETTER = id -> {
        TextColor color = MaterialTooltipCache.getColor(id);
        if ((color.m_131265_() & 0xFFFFFF) != 0xFFFFFF) {
            return DISPLAY_NAME_GETTER.apply((MaterialVariantId)id).m_130938_(style -> style.m_131148_(color));
        }
        return MaterialTooltipCache.getDisplayName(id);
    };

    private MaterialTooltipCache() {
    }

    public static void init(RegisterClientReloadListenersEvent manager) {
        manager.registerReloadListener((PreparableReloadListener)RELOAD_LISTENER);
    }

    public static String getKey(MaterialVariantId variantId) {
        return KEY_CACHE.computeIfAbsent(variantId, KEY_GETTER);
    }

    public static Component getDisplayName(MaterialVariantId variantId) {
        return (Component)DISPLAY_NAME_CACHE.computeIfAbsent(variantId, DISPLAY_NAME_GETTER);
    }

    public static TextColor getColor(MaterialVariantId id) {
        return COLOR_CACHE.computeIfAbsent(id, COLOR_GETTER);
    }

    public static Component getColoredDisplayName(MaterialVariantId variantId) {
        return COLORED_DISPLAY_NAME_CACHE.computeIfAbsent(variantId, COLORED_DISPLAY_NAME_GETTER);
    }
}

