/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.lib.util.recipes;

import cofh.lib.fluid.FluidIngredient;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.recipes.RecipeJsonUtils;
import cofh.thermal.lib.util.recipes.ThermalFuel;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class DynamoFuelSerializer<T extends ThermalFuel>
extends ForgeRegistryEntry<RecipeSerializer<?>>
implements RecipeSerializer<T> {
    protected final int defaultEnergy;
    protected final int minEnergy;
    protected final int maxEnergy;
    protected final IFactory<T> factory;

    public DynamoFuelSerializer(IFactory<T> factory, int defaultEnergy, int minEnergy, int maxEnergy) {
        this.factory = factory;
        this.defaultEnergy = defaultEnergy;
        this.minEnergy = minEnergy;
        this.maxEnergy = maxEnergy;
    }

    public T fromJson(ResourceLocation recipeId, JsonObject json) {
        int energy = this.defaultEnergy;
        ArrayList<Ingredient> inputItems = new ArrayList<Ingredient>();
        ArrayList<FluidIngredient> inputFluids = new ArrayList<FluidIngredient>();
        if (json.has("ingredient")) {
            RecipeJsonUtils.parseInputs(inputItems, inputFluids, (JsonElement)json.get("ingredient"));
        } else if (json.has("ingredients")) {
            RecipeJsonUtils.parseInputs(inputItems, inputFluids, (JsonElement)json.get("ingredients"));
        } else if (json.has("input")) {
            RecipeJsonUtils.parseInputs(inputItems, inputFluids, (JsonElement)json.get("input"));
        } else if (json.has("inputs")) {
            RecipeJsonUtils.parseInputs(inputItems, inputFluids, (JsonElement)json.get("inputs"));
        }
        if (json.has("energy")) {
            energy = json.get("energy").getAsInt();
        }
        if (json.has("energy_mod")) {
            energy = (int)((float)energy * json.get("energy_mod").getAsFloat());
        }
        energy = MathHelper.clamp((int)energy, (int)this.minEnergy, (int)this.maxEnergy);
        return this.factory.create(recipeId, energy, inputItems, inputFluids);
    }

    @Nullable
    public T fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        int energy = buffer.m_130242_();
        int numInputItems = buffer.m_130242_();
        ArrayList<Ingredient> inputItems = new ArrayList<Ingredient>(numInputItems);
        for (int i = 0; i < numInputItems; ++i) {
            inputItems.add(Ingredient.m_43940_((FriendlyByteBuf)buffer));
        }
        int numInputFluids = buffer.m_130242_();
        ArrayList<FluidIngredient> inputFluids = new ArrayList<FluidIngredient>(numInputFluids);
        for (int i = 0; i < numInputFluids; ++i) {
            inputFluids.add(FluidIngredient.fromNetwork((FriendlyByteBuf)buffer));
        }
        return this.factory.create(recipeId, energy, inputItems, inputFluids);
    }

    public void toNetwork(FriendlyByteBuf buffer, T recipe) {
        buffer.m_130130_(((ThermalFuel)((Object)recipe)).energy);
        int numInputItems = ((ThermalFuel)((Object)recipe)).inputItems.size();
        buffer.m_130130_(numInputItems);
        for (int i = 0; i < numInputItems; ++i) {
            ((ThermalFuel)((Object)recipe)).inputItems.get(i).m_43923_(buffer);
        }
        int numInputFluids = ((ThermalFuel)((Object)recipe)).inputFluids.size();
        buffer.m_130130_(numInputFluids);
        for (int i = 0; i < numInputFluids; ++i) {
            ((ThermalFuel)((Object)recipe)).inputFluids.get(i).toNetwork(buffer);
        }
    }

    public static interface IFactory<T extends ThermalFuel> {
        public T create(ResourceLocation var1, int var2, List<Ingredient> var3, List<FluidIngredient> var4);
    }
}

