/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.lib.tileentity;

import cofh.core.block.entity.TileCoFH;
import cofh.core.network.packet.client.TileStatePacket;
import cofh.core.util.helpers.FluidHelper;
import cofh.lib.block.entity.ICoFHTickableTile;
import cofh.lib.energy.EnergyStorageCoFH;
import cofh.lib.fluid.FluidStorageCoFH;
import cofh.lib.inventory.ItemStorageCoFH;
import cofh.lib.util.TimeTracker;
import cofh.lib.util.Utils;
import cofh.lib.util.constants.Constants;
import cofh.lib.util.helpers.AugmentDataHelper;
import cofh.lib.util.helpers.AugmentableHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.xp.XpStorage;
import cofh.thermal.lib.common.ThermalAugmentRules;
import cofh.thermal.lib.tileentity.ReconfigurableTile4Way;
import cofh.thermal.lib.util.ThermalEnergyHelper;
import cofh.thermal.lib.util.recipes.IMachineInventory;
import cofh.thermal.lib.util.recipes.MachineProperties;
import cofh.thermal.lib.util.recipes.internal.IMachineRecipe;
import cofh.thermal.lib.util.recipes.internal.IRecipeCatalyst;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fluids.FluidStack;

public abstract class MachineTileProcess
extends ReconfigurableTile4Way
implements ICoFHTickableTile.IServerTickable,
IMachineInventory {
    protected ItemStorageCoFH chargeSlot = new ItemStorageCoFH(1, ThermalEnergyHelper::hasEnergyHandlerCap);
    protected IMachineRecipe curRecipe;
    protected IRecipeCatalyst curCatalyst;
    protected List<Integer> itemInputCounts = new ArrayList<Integer>();
    protected List<Integer> fluidInputCounts = new ArrayList<Integer>();
    protected int process;
    protected int processMax;
    protected int baseProcessTick;
    protected int processTick = this.baseProcessTick = this.getBaseProcessTick();
    protected TimeTracker timeTracker = new TimeTracker();
    public boolean wasActive;
    protected MachineProperties machineProperties = new MachineProperties();
    protected boolean secondaryNullFeature = false;

    public MachineTileProcess(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
        this.energyStorage = new EnergyStorageCoFH(this.getBaseEnergyStorage(), this.getBaseEnergyXfer());
        this.xpStorage = new XpStorage(this.getBaseXpStorage());
    }

    public void tickServer() {
        boolean curActive = this.isActive;
        if (this.isActive) {
            this.processTick();
            if (this.canProcessFinish()) {
                this.processFinish();
                this.transferOutput();
                this.transferInput();
                if (!this.redstoneControl.getState() || !this.canProcessStart()) {
                    this.energyStorage.modify(-this.process);
                    this.processOff();
                } else {
                    this.processStart();
                }
            } else if (this.energyStorage.getEnergyStored() < this.processTick) {
                this.processOff();
            }
        } else if (this.redstoneControl.getState()) {
            if (Utils.timeCheck((Level)this.f_58857_)) {
                this.transferOutput();
                this.transferInput();
            }
            if (Utils.timeCheckQuarter((Level)this.f_58857_) && this.canProcessStart()) {
                this.processStart();
                this.processTick();
                this.isActive = true;
            }
        }
        this.updateActiveState(curActive);
        this.chargeEnergy();
    }

    @Override
    protected void updateActiveState(boolean prevActive) {
        if (!this.isActive && prevActive) {
            this.wasActive = true;
            if (this.f_58857_ != null) {
                this.timeTracker.markTime(this.f_58857_);
            }
            return;
        }
        if (prevActive != this.isActive || this.wasActive && (this.timeTracker.hasDelayPassed(this.f_58857_, 40) || this.timeTracker.notSet())) {
            this.wasActive = false;
            if (this.m_58900_().m_61138_((Property)Constants.ACTIVE)) {
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)Constants.ACTIVE, (Comparable)Boolean.valueOf(this.isActive)));
            }
            TileStatePacket.sendToClient((TileCoFH)this);
        }
    }

    protected boolean canProcessStart() {
        if (this.energyStorage.getEnergyStored() - this.process < this.processTick) {
            return false;
        }
        if (!this.validateInputs()) {
            return false;
        }
        return this.validateOutputs();
    }

    protected boolean canProcessFinish() {
        return this.process <= 0;
    }

    protected void processStart() {
        this.processTick = this.baseProcessTick;
        int energy = this.curRecipe.getEnergy(this);
        this.process = this.processMax = (energy += this.process);
        if (this.cacheRenderFluid()) {
            TileStatePacket.sendToClient((TileCoFH)this);
        }
    }

    protected void processFinish() {
        if (!this.validateInputs()) {
            this.processOff();
            return;
        }
        this.resolveOutputs();
        this.resolveInputs();
        this.markDirtyFast();
    }

    protected void processOff() {
        this.process = 0;
        this.isActive = false;
        this.wasActive = true;
        this.clearRecipe();
        if (this.f_58857_ != null) {
            this.timeTracker.markTime(this.f_58857_);
        }
    }

    protected int processTick() {
        if (this.process <= 0) {
            return 0;
        }
        this.energyStorage.modify(-this.processTick);
        this.process -= this.processTick;
        return this.processTick;
    }

    protected void chargeEnergy() {
        if (!this.chargeSlot.isEmpty()) {
            this.chargeSlot.getItemStack().getCapability(ThermalEnergyHelper.getBaseEnergySystem(), null).ifPresent(c -> this.energyStorage.receiveEnergy(c.extractEnergy(Math.min(this.energyStorage.getMaxReceive(), this.energyStorage.getSpace()), false), false));
        }
    }

    protected boolean cacheRecipe() {
        return false;
    }

    protected void clearRecipe() {
        this.curRecipe = null;
        this.curCatalyst = null;
        this.itemInputCounts = new ArrayList<Integer>();
        this.fluidInputCounts = new ArrayList<Integer>();
    }

    protected boolean validateInputs() {
        if (!this.cacheRecipe()) {
            return false;
        }
        List<? extends ItemStorageCoFH> slotInputs = this.inputSlots();
        for (int i = 0; i < slotInputs.size() && i < this.itemInputCounts.size(); ++i) {
            int inputCount = this.itemInputCounts.get(i);
            if (inputCount <= 0 || slotInputs.get(i).getItemStack().m_41613_() >= inputCount) continue;
            return false;
        }
        List<? extends FluidStorageCoFH> tankInputs = this.inputTanks();
        for (int i = 0; i < tankInputs.size() && i < this.fluidInputCounts.size(); ++i) {
            int inputCount = this.fluidInputCounts.get(i);
            FluidStack input = tankInputs.get(i).getFluidStack();
            if (inputCount <= 0 || !input.isEmpty() && input.getAmount() >= inputCount) continue;
            return false;
        }
        return true;
    }

    protected boolean validateOutputs() {
        if (this.curRecipe == null && !this.cacheRecipe()) {
            return false;
        }
        List<? extends ItemStorageCoFH> slotOutputs = this.outputSlots();
        List<ItemStack> recipeOutputItems = this.curRecipe.getOutputItems(this);
        boolean[] used = new boolean[this.outputSlots().size()];
        for (int j = 0; j < recipeOutputItems.size(); ++j) {
            int i;
            ItemStack recipeOutput = recipeOutputItems.get(j);
            boolean matched = false;
            for (i = 0; i < slotOutputs.size(); ++i) {
                ItemStack output;
                if (used[i] || (output = slotOutputs.get(i).getItemStack()).m_41613_() >= output.m_41741_() || !ItemHelper.itemsEqualWithTags((ItemStack)output, (ItemStack)recipeOutput)) continue;
                used[i] = true;
                matched = true;
                break;
            }
            if (!matched) {
                for (i = 0; i < slotOutputs.size(); ++i) {
                    if (used[i] || !slotOutputs.get(i).isEmpty()) continue;
                    used[i] = true;
                    matched = true;
                    break;
                }
            }
            if (matched || j != 0 && this.secondaryNullFeature) continue;
            return false;
        }
        List<? extends FluidStorageCoFH> tankOutputs = this.outputTanks();
        List<FluidStack> recipeOutputFluids = this.curRecipe.getOutputFluids(this);
        used = new boolean[this.outputTanks().size()];
        for (FluidStack recipeOutput : recipeOutputFluids) {
            int i;
            boolean matched = false;
            for (i = 0; i < tankOutputs.size(); ++i) {
                FluidStack output = tankOutputs.get(i).getFluidStack();
                if (used[i] || tankOutputs.get(i).getSpace() < recipeOutput.getAmount() || !FluidHelper.fluidsEqual((FluidStack)output, (FluidStack)recipeOutput)) continue;
                used[i] = true;
                matched = true;
                break;
            }
            if (!matched) {
                for (i = 0; i < tankOutputs.size(); ++i) {
                    if (used[i] || !tankOutputs.get(i).isEmpty()) continue;
                    used[i] = true;
                    matched = true;
                    break;
                }
            }
            if (matched) continue;
            return false;
        }
        return true;
    }

    protected void resolveOutputs() {
        List<ItemStack> recipeOutputItems = this.curRecipe.getOutputItems(this);
        List<FluidStack> recipeOutputFluids = this.curRecipe.getOutputFluids(this);
        List<Float> recipeOutputChances = this.curRecipe.getOutputItemChances(this);
        for (int i = 0; i < recipeOutputItems.size(); ++i) {
            int outputCount;
            ItemStack itemStack = recipeOutputItems.get(i);
            float chance = recipeOutputChances.get(i).floatValue();
            int n = outputCount = chance <= 1.0f ? itemStack.m_41613_() : (int)chance;
            while (this.f_58857_.f_46441_.nextFloat() < chance) {
                boolean bl = false;
                for (ItemStorageCoFH itemStorageCoFH : this.outputSlots()) {
                    ItemStack output = itemStorageCoFH.getItemStack();
                    if (!ItemHelper.itemsEqualWithTags((ItemStack)output, (ItemStack)itemStack) || output.m_41613_() >= output.m_41741_()) continue;
                    output.m_41769_(outputCount);
                    bl = true;
                    break;
                }
                if (!bl) {
                    for (ItemStorageCoFH itemStorageCoFH : this.outputSlots()) {
                        if (!itemStorageCoFH.isEmpty()) continue;
                        itemStorageCoFH.setItemStack(ItemHelper.cloneStack((ItemStack)itemStack, (int)outputCount));
                        break;
                    }
                }
                chance -= 1.0f * (float)outputCount;
                outputCount = 1;
            }
        }
        block4: for (FluidStack fluidStack : recipeOutputFluids) {
            boolean matched = false;
            for (FluidStorageCoFH fluidStorageCoFH : this.outputTanks()) {
                FluidStack output = fluidStorageCoFH.getFluidStack();
                if (fluidStorageCoFH.getSpace() < fluidStack.getAmount() || !FluidHelper.fluidsEqual((FluidStack)output, (FluidStack)fluidStack)) continue;
                output.setAmount(output.getAmount() + fluidStack.getAmount());
                matched = true;
                break;
            }
            if (matched) continue;
            for (FluidStorageCoFH fluidStorageCoFH : this.outputTanks()) {
                if (!fluidStorageCoFH.isEmpty()) continue;
                fluidStorageCoFH.setFluidStack(fluidStack.copy());
                continue block4;
            }
        }
        this.xpStorage.receiveXPFloat(this.curRecipe.getXp(this), false);
    }

    protected void resolveInputs() {
        int i;
        for (i = 0; i < this.itemInputCounts.size(); ++i) {
            this.inputSlots().get(i).consume(this.itemInputCounts.get(i).intValue());
        }
        for (i = 0; i < this.fluidInputCounts.size(); ++i) {
            this.inputTanks().get(i).modify(-this.fluidInputCounts.get(i).intValue());
        }
    }

    @Override
    public int getCurSpeed() {
        return this.isActive ? this.processTick : 0;
    }

    @Override
    public int getMaxSpeed() {
        return this.baseProcessTick;
    }

    @Override
    public double getEfficiency() {
        if (this.getMachineProperties().getEnergyMod() <= 0.0f) {
            return Double.MAX_VALUE;
        }
        return 1.0 / (double)this.getMachineProperties().getEnergyMod();
    }

    @Override
    public int getScaledProgress(int scale) {
        if (!this.isActive || this.processMax <= 0 || this.process <= 0) {
            return 0;
        }
        return scale * (this.processMax - this.process) / this.processMax;
    }

    @Override
    public int getScaledSpeed(int scale) {
        if (!this.isActive) {
            return 0;
        }
        return MathHelper.clamp((int)(scale * this.processTick / this.baseProcessTick), (int)1, (int)scale);
    }

    @Override
    public FriendlyByteBuf getGuiPacket(FriendlyByteBuf buffer) {
        super.getGuiPacket(buffer);
        buffer.writeInt(this.process);
        buffer.writeInt(this.processMax);
        buffer.writeInt(this.processTick);
        return buffer;
    }

    @Override
    public void handleGuiPacket(FriendlyByteBuf buffer) {
        super.handleGuiPacket(buffer);
        this.process = buffer.readInt();
        this.processMax = buffer.readInt();
        this.processTick = buffer.readInt();
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.wasActive = nbt.m_128471_("ActivePrev");
        this.process = nbt.m_128451_("Proc");
        this.processMax = nbt.m_128451_("ProcMax");
        this.processTick = nbt.m_128451_("ProcTick");
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128379_("ActivePrev", this.wasActive);
        nbt.m_128405_("Proc", this.process);
        nbt.m_128405_("ProcMax", this.processMax);
        nbt.m_128405_("ProcTick", this.processTick);
    }

    @Override
    protected Predicate<ItemStack> augValidator() {
        BiPredicate<ItemStack, List<ItemStack>> validator = this.tankInv.hasTanks() ? ThermalAugmentRules.MACHINE_VALIDATOR : ThermalAugmentRules.MACHINE_NO_FLUID_VALIDATOR;
        return item -> AugmentDataHelper.hasAugmentData((ItemStack)item) && validator.test((ItemStack)item, this.getAugmentsAsList());
    }

    @Override
    protected void resetAttributes() {
        super.resetAttributes();
        AugmentableHelper.setAttribute((CompoundTag)this.augmentNBT, (String)"MachinePower", (float)1.0f);
        AugmentableHelper.setAttribute((CompoundTag)this.augmentNBT, (String)"MachineSpeed", (float)1.0f);
        this.machineProperties.resetAttributes();
        this.secondaryNullFeature = false;
    }

    @Override
    protected void setAttributesFromAugment(CompoundTag augmentData) {
        super.setAttributesFromAugment(augmentData);
        AugmentableHelper.setAttributeFromAugmentAdd((CompoundTag)this.augmentNBT, (CompoundTag)augmentData, (String)"MachinePower");
        AugmentableHelper.setAttributeFromAugmentAdd((CompoundTag)this.augmentNBT, (CompoundTag)augmentData, (String)"MachineSpeed");
        this.machineProperties.setAttributesFromAugment(augmentData);
        this.secondaryNullFeature |= AugmentableHelper.getAttributeMod((CompoundTag)augmentData, (String)"SecNull") > 0.0f;
    }

    @Override
    protected void finalizeAttributes(Map<Enchantment, Integer> enchantmentMap) {
        super.finalizeAttributes(enchantmentMap);
        float baseMod = AugmentableHelper.getAttributeModWithDefault((CompoundTag)this.augmentNBT, (String)"BaseMod", (float)1.0f);
        float powerMod = AugmentableHelper.getAttributeModWithDefault((CompoundTag)this.augmentNBT, (String)"MachinePower", (float)1.0f);
        float speedMod = AugmentableHelper.getAttributeModWithDefault((CompoundTag)this.augmentNBT, (String)"MachineSpeed", (float)1.0f);
        float totalMod = baseMod * powerMod * speedMod;
        this.machineProperties.finalizeAttributes();
        this.processTick = this.baseProcessTick = Math.round((float)this.getBaseProcessTick() * totalMod);
    }

    @Override
    public MachineProperties getMachineProperties() {
        return this.machineProperties;
    }

    @Override
    public void onInventoryChanged(int slot) {
        super.onInventoryChanged(slot);
        if (this.f_58857_ != null && Utils.isServerWorld((Level)this.f_58857_) && this.isActive) {
            if (slot >= this.invSize() - this.augSize()) {
                if (!this.validateOutputs()) {
                    this.processOff();
                }
            } else if (slot < this.inventory.getInputSlots().size()) {
                IMachineRecipe tempRecipe = this.curRecipe;
                IRecipeCatalyst tempCatalyst = this.curCatalyst;
                if (!this.validateInputs() || tempRecipe != this.curRecipe || tempCatalyst != this.curCatalyst) {
                    this.processOff();
                }
            }
        }
    }

    public void onTankChanged(int tank) {
        if (Utils.isServerWorld((Level)this.f_58857_) && tank < this.tankInv.getInputTanks().size() && this.isActive) {
            IMachineRecipe tempRecipe = this.curRecipe;
            IRecipeCatalyst tempCatalyst = this.curCatalyst;
            if (!this.validateInputs() || tempRecipe != this.curRecipe || tempCatalyst != this.curCatalyst) {
                this.processOff();
            }
        }
        super.onTankChanged(tank);
    }
}

