/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.lib.common;

import cofh.lib.util.helpers.AugmentDataHelper;
import cofh.lib.util.helpers.ItemHelper;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ThermalAugmentRules {
    private static final Set<String> ATTR_ADD = new ObjectOpenHashSet();
    private static final Set<String> ATTR_MAX = new ObjectOpenHashSet();
    private static final Set<String> ATTR_MULT = new ObjectOpenHashSet();
    private static final Set<String> ATTR_INV = new ObjectOpenHashSet();
    private static final Set<String> ATTR_INT = new ObjectOpenHashSet();
    private static final Set<Item> ITEM_UNIQUE = new ObjectOpenHashSet();
    private static final Set<String> TYPE_EXC = new ObjectOpenHashSet();
    public static final BiPredicate<ItemStack, List<ItemStack>> DEVICE_VALIDATOR;
    public static final BiPredicate<ItemStack, List<ItemStack>> DEVICE_NO_FLUID_VALIDATOR;
    public static final BiPredicate<ItemStack, List<ItemStack>> DYNAMO_VALIDATOR;
    public static final BiPredicate<ItemStack, List<ItemStack>> DYNAMO_NO_FLUID_VALIDATOR;
    public static final BiPredicate<ItemStack, List<ItemStack>> ENERGY_STORAGE_VALIDATOR;
    public static final BiPredicate<ItemStack, List<ItemStack>> FLUID_STORAGE_VALIDATOR;
    public static final BiPredicate<ItemStack, List<ItemStack>> ITEM_STORAGE_VALIDATOR;
    public static final BiPredicate<ItemStack, List<ItemStack>> MACHINE_VALIDATOR;
    public static final BiPredicate<ItemStack, List<ItemStack>> MACHINE_NO_FLUID_VALIDATOR;

    private ThermalAugmentRules() {
    }

    public static boolean isTypeExclusive(String type) {
        return TYPE_EXC.contains(type);
    }

    public static boolean isUnique(ItemStack augment) {
        return ITEM_UNIQUE.contains(augment.m_41720_());
    }

    public static boolean isAdditive(String mod) {
        return ATTR_ADD.contains(mod);
    }

    public static boolean isMultiplicative(String mod) {
        return ATTR_MULT.contains(mod);
    }

    public static boolean isMaximized(String mod) {
        return ATTR_MAX.contains(mod);
    }

    public static boolean isInverse(String mod) {
        return ATTR_INV.contains(mod);
    }

    public static boolean isInteger(String mod) {
        return ATTR_INT.contains(mod);
    }

    public static void flagUniqueAugment(Item augment) {
        ITEM_UNIQUE.add(augment);
    }

    public static BiPredicate<ItemStack, List<ItemStack>> createAllowValidator(String ... allowAugTypes) {
        return ThermalAugmentRules.createAllowValidator((Set<String>)new ObjectOpenHashSet((Object[])allowAugTypes));
    }

    public static BiPredicate<ItemStack, List<ItemStack>> createAllowValidator(Set<String> allowAugTypes) {
        return (newAugment, augments) -> {
            String newType = AugmentDataHelper.getAugmentType((ItemStack)newAugment);
            if (!newType.isEmpty() && !allowAugTypes.contains(newType)) {
                return false;
            }
            if (ThermalAugmentRules.isTypeExclusive(newType)) {
                for (ItemStack augment : augments) {
                    if (!newType.equals(AugmentDataHelper.getAugmentType((ItemStack)augment))) continue;
                    return false;
                }
            }
            if (ThermalAugmentRules.isUnique(newAugment)) {
                for (ItemStack augment : augments) {
                    if (!ItemHelper.itemsEqual((ItemStack)newAugment, (ItemStack)augment)) continue;
                    return false;
                }
            }
            return true;
        };
    }

    public static BiPredicate<ItemStack, List<ItemStack>> createDenyValidator(String ... denyAugTypes) {
        return ThermalAugmentRules.createDenyValidator((Set<String>)new ObjectOpenHashSet((Object[])denyAugTypes));
    }

    public static BiPredicate<ItemStack, List<ItemStack>> createDenyValidator(Set<String> denyAugTypes) {
        return (newAugment, augments) -> {
            String newType = AugmentDataHelper.getAugmentType((ItemStack)newAugment);
            if (!newType.isEmpty() && denyAugTypes.contains(newType)) {
                return false;
            }
            if (ThermalAugmentRules.isTypeExclusive(newType)) {
                for (ItemStack augment : augments) {
                    if (!newType.equals(AugmentDataHelper.getAugmentType((ItemStack)augment))) continue;
                    return false;
                }
            }
            if (ThermalAugmentRules.isUnique(newAugment)) {
                for (ItemStack augment : augments) {
                    if (!ItemHelper.itemsEqual((ItemStack)newAugment, (ItemStack)augment)) continue;
                    return false;
                }
            }
            return true;
        };
    }

    static {
        ATTR_ADD.addAll(Arrays.asList("Depth", "Radius", "Reach", "DynamoPower", "MachinePower", "MachinePri", "MachineSec", "MachineSpeed", "PotionAmp", "PotionDur"));
        ATTR_MULT.addAll(Arrays.asList("BaseMod", "RFMax", "RFXfer", "FluidMax", "DynamoEnergy", "MachineCat", "MachineEnergy", "MachineXp"));
        ATTR_MAX.addAll(Arrays.asList("BaseMod", "RFMax", "RFXfer", "FluidMax", "MachineMin"));
        ATTR_INV.addAll(Arrays.asList("MachineCat", "MachineEnergy"));
        ATTR_INT.addAll(Arrays.asList("Depth", "Radius", "Reach", "PotionAmp"));
        TYPE_EXC.addAll(Arrays.asList("Filter", "Fluid", "RF"));
        DEVICE_VALIDATOR = ThermalAugmentRules.createDenyValidator("Machine", "Dynamo");
        DEVICE_NO_FLUID_VALIDATOR = ThermalAugmentRules.createDenyValidator("Machine", "Dynamo", "Fluid", "Potion");
        DYNAMO_VALIDATOR = ThermalAugmentRules.createDenyValidator("Machine", "RF", "Area", "Potion");
        DYNAMO_NO_FLUID_VALIDATOR = ThermalAugmentRules.createDenyValidator("Machine", "RF", "Fluid", "Area", "Potion");
        ENERGY_STORAGE_VALIDATOR = ThermalAugmentRules.createAllowValidator("Upgrade", "RF");
        FLUID_STORAGE_VALIDATOR = ThermalAugmentRules.createAllowValidator("Upgrade", "Fluid");
        ITEM_STORAGE_VALIDATOR = ThermalAugmentRules.createAllowValidator("Upgrade", "Filter");
        MACHINE_VALIDATOR = ThermalAugmentRules.createDenyValidator("Dynamo", "Area", "Potion");
        MACHINE_NO_FLUID_VALIDATOR = ThermalAugmentRules.createDenyValidator("Dynamo", "Fluid", "Area", "Potion");
    }
}

