/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.util.managers.machine;

import cofh.lib.fluid.IFluidStackAccess;
import cofh.lib.inventory.IItemStackAccess;
import cofh.lib.util.ComparableItemStack;
import cofh.thermal.core.init.TCoreRecipeTypes;
import cofh.thermal.lib.util.managers.AbstractManager;
import cofh.thermal.lib.util.managers.CatalyzedRecipeManager;
import cofh.thermal.lib.util.managers.IRecipeManager;
import cofh.thermal.lib.util.recipes.IThermalInventory;
import cofh.thermal.lib.util.recipes.ThermalCatalyst;
import cofh.thermal.lib.util.recipes.ThermalRecipe;
import cofh.thermal.lib.util.recipes.internal.BaseMachineCatalyst;
import cofh.thermal.lib.util.recipes.internal.BaseMachineRecipe;
import cofh.thermal.lib.util.recipes.internal.CatalyzedMachineRecipe;
import cofh.thermal.lib.util.recipes.internal.DisenchantMachineRecipe;
import cofh.thermal.lib.util.recipes.internal.IMachineRecipe;
import cofh.thermal.lib.util.recipes.internal.IRecipeCatalyst;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraftforge.fluids.FluidStack;

public class SmelterRecipeManager
extends AbstractManager
implements IRecipeManager,
CatalyzedRecipeManager {
    private static final SmelterRecipeManager INSTANCE = new SmelterRecipeManager();
    protected static final int DEFAULT_ENERGY = 3200;
    protected Map<SmelterMapWrapper, IMachineRecipe> recipeMap = new Object2ObjectOpenHashMap();
    protected Map<ComparableItemStack, IRecipeCatalyst> catalystMap = new Object2ObjectOpenHashMap();
    protected Set<ComparableItemStack> validItems = new ObjectOpenHashSet();
    protected int maxInputItems = 3;
    protected int maxOutputItems = 4;
    protected int maxOutputFluids = 0;

    public static SmelterRecipeManager instance() {
        return INSTANCE;
    }

    private SmelterRecipeManager() {
        super(3200);
    }

    public void addRecipe(ThermalRecipe recipe, BaseMachineRecipe.RecipeType type) {
        switch (recipe.getInputItems().size()) {
            case 1: {
                for (ItemStack firstInput : recipe.getInputItems().get(0).m_43908_()) {
                    this.addRecipe(recipe.getEnergy(), recipe.getXp(), Collections.singletonList(firstInput), Collections.emptyList(), recipe.getOutputItems(), recipe.getOutputItemChances(), recipe.getOutputFluids(), type);
                }
                return;
            }
            case 2: {
                for (ItemStack firstInput : recipe.getInputItems().get(0).m_43908_()) {
                    for (ItemStack secondInput : recipe.getInputItems().get(1).m_43908_()) {
                        this.addRecipe(recipe.getEnergy(), recipe.getXp(), Arrays.asList(firstInput, secondInput), Collections.emptyList(), recipe.getOutputItems(), recipe.getOutputItemChances(), recipe.getOutputFluids(), type);
                    }
                }
                return;
            }
            case 3: {
                for (ItemStack firstInput : recipe.getInputItems().get(0).m_43908_()) {
                    for (ItemStack secondInput : recipe.getInputItems().get(1).m_43908_()) {
                        for (ItemStack thirdInput : recipe.getInputItems().get(2).m_43908_()) {
                            this.addRecipe(recipe.getEnergy(), recipe.getXp(), Arrays.asList(firstInput, secondInput, thirdInput), Collections.emptyList(), recipe.getOutputItems(), recipe.getOutputItemChances(), recipe.getOutputFluids(), type);
                        }
                    }
                }
                return;
            }
        }
    }

    public boolean validItem(ItemStack item) {
        return this.validItems.contains(SmelterRecipeManager.convert(item));
    }

    protected void clear() {
        this.recipeMap.clear();
        this.catalystMap.clear();
        this.validItems.clear();
    }

    protected IMachineRecipe getRecipe(List<? extends IItemStackAccess> inputSlots, List<? extends IFluidStackAccess> inputTanks) {
        if (inputSlots.isEmpty()) {
            return null;
        }
        ArrayList<ComparableItemStack> convertedItems = new ArrayList<ComparableItemStack>(this.maxInputItems);
        for (int i = 0; i < this.maxInputItems; ++i) {
            if (inputSlots.get(i).isEmpty()) continue;
            ComparableItemStack compStack = SmelterRecipeManager.convert(inputSlots.get(i).getItemStack());
            convertedItems.add(compStack);
        }
        if (convertedItems.isEmpty()) {
            return null;
        }
        return this.recipeMap.get(new SmelterMapWrapper(convertedItems));
    }

    /*
     * WARNING - void declaration
     */
    protected IMachineRecipe addRecipe(int energy, float experience, List<ItemStack> inputItems, List<FluidStack> inputFluids, List<ItemStack> outputItems, List<Float> chance, List<FluidStack> outputFluids, BaseMachineRecipe.RecipeType type) {
        void var10_18;
        if (inputItems.isEmpty() || outputItems.isEmpty() && outputFluids.isEmpty() || outputItems.size() > this.maxOutputItems || outputFluids.size() > this.maxOutputFluids || energy <= 0) {
            return null;
        }
        for (ItemStack itemStack : inputItems) {
            if (!itemStack.m_41619_()) continue;
            return null;
        }
        for (ItemStack itemStack : outputItems) {
            if (!itemStack.m_41619_()) continue;
            return null;
        }
        for (FluidStack fluidStack : outputFluids) {
            if (!fluidStack.isEmpty()) continue;
            return null;
        }
        energy = (int)((float)energy * this.getDefaultScale());
        ArrayList<ComparableItemStack> convertedItems = new ArrayList<ComparableItemStack>(inputItems.size());
        for (ItemStack stack : inputItems) {
            if (inputItems.isEmpty()) continue;
            ComparableItemStack compStack = SmelterRecipeManager.convert(stack);
            this.validItems.add(compStack);
            convertedItems.add(compStack);
        }
        if (type == BaseMachineRecipe.RecipeType.DISENCHANT) {
            DisenchantMachineRecipe disenchantMachineRecipe = new DisenchantMachineRecipe(energy, experience, inputItems, inputFluids, outputItems, chance, outputFluids);
        } else {
            InternalSmelterRecipe internalSmelterRecipe = new InternalSmelterRecipe(energy, experience, inputItems, inputFluids, outputItems, chance, outputFluids);
        }
        this.recipeMap.put(new SmelterMapWrapper(convertedItems), (IMachineRecipe)var10_18);
        return var10_18;
    }

    @Override
    public List<ItemStack> getCatalysts() {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>(this.catalystMap.size());
        this.catalystMap.keySet().forEach(stack -> ret.add(stack.toItemStack()));
        return ret;
    }

    @Override
    public IRecipeCatalyst getCatalyst(IItemStackAccess input) {
        return this.catalystMap.get(SmelterRecipeManager.convert(input.getItemStack()));
    }

    @Override
    public IRecipeCatalyst getCatalyst(ItemStack input) {
        return this.catalystMap.get(SmelterRecipeManager.convert(input));
    }

    public void addCatalyst(ThermalCatalyst catalyst) {
        for (ItemStack ingredient : catalyst.getIngredient().m_43908_()) {
            this.addCatalyst(ingredient, catalyst.getPrimaryMod(), catalyst.getSecondaryMod(), catalyst.getEnergyMod(), catalyst.getMinChance(), catalyst.getUseChance());
        }
    }

    public IRecipeCatalyst addCatalyst(ItemStack input, float primaryMod, float secondaryMod, float energyMod, float minChance, float useChance) {
        if (input == null || input.m_41619_()) {
            return null;
        }
        BaseMachineCatalyst catalyst = new BaseMachineCatalyst(primaryMod, secondaryMod, energyMod, minChance, useChance);
        this.catalystMap.put(SmelterRecipeManager.convert(input), catalyst);
        return catalyst;
    }

    public boolean validCatalyst(ItemStack input) {
        return this.getCatalyst(input) != null;
    }

    public IRecipeCatalyst removeCatalyst(ItemStack input) {
        return this.catalystMap.remove(SmelterRecipeManager.convert(input));
    }

    @Override
    public IMachineRecipe getRecipe(IThermalInventory inventory) {
        return this.getRecipe(inventory.inputSlots(), inventory.inputTanks());
    }

    @Override
    public List<IMachineRecipe> getRecipeList() {
        return new ArrayList<IMachineRecipe>(this.recipeMap.values());
    }

    @Override
    public void refresh(RecipeManager recipeManager) {
        this.clear();
        Map recipes = recipeManager.m_44054_(TCoreRecipeTypes.RECIPE_SMELTER);
        for (Map.Entry entry : recipes.entrySet()) {
            this.addRecipe((ThermalRecipe)((Object)entry.getValue()), BaseMachineRecipe.RecipeType.CATALYZED);
        }
        Map recycle = recipeManager.m_44054_(TCoreRecipeTypes.RECIPE_SMELTER_RECYCLE);
        for (Map.Entry entry : recycle.entrySet()) {
            this.addRecipe((ThermalRecipe)((Object)entry.getValue()), BaseMachineRecipe.RecipeType.DISENCHANT);
        }
        Map map = recipeManager.m_44054_(TCoreRecipeTypes.CATALYST_SMELTER);
        for (Map.Entry entry : map.entrySet()) {
            this.addCatalyst((ThermalCatalyst)((Object)entry.getValue()));
        }
    }

    protected static class SmelterMapWrapper {
        Set<Integer> itemHashes;
        int hashCode;

        SmelterMapWrapper(List<ComparableItemStack> itemStacks) {
            this.itemHashes = new ObjectOpenHashSet(itemStacks.size());
            for (ComparableItemStack itemStack : itemStacks) {
                if (itemStack.hashCode() == 0) continue;
                this.itemHashes.add(itemStack.hashCode());
                this.hashCode += itemStack.hashCode();
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SmelterMapWrapper that = (SmelterMapWrapper)o;
            return this.itemHashes.size() == that.itemHashes.size() && this.itemHashes.containsAll(that.itemHashes);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    protected static class InternalSmelterRecipe
    extends CatalyzedMachineRecipe {
        public InternalSmelterRecipe(int energy, float experience, @Nullable List<ItemStack> inputItems, @Nullable List<FluidStack> inputFluids, @Nullable List<ItemStack> outputItems, @Nullable List<Float> chance, @Nullable List<FluidStack> outputFluids) {
            super(3, energy, experience, inputItems, inputFluids, outputItems, chance, outputFluids);
        }

        @Override
        public IRecipeCatalyst getCatalyst(ItemStack input) {
            return SmelterRecipeManager.instance().getCatalyst(input);
        }
    }
}

