/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.item;

import cofh.core.item.ItemCoFH;
import cofh.lib.util.Utils;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.BambooBlock;
import net.minecraft.world.level.block.BaseCoralWallFanBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.ForgeEventFactory;

public class PhytoGroItem
extends ItemCoFH {
    protected static final int CLOUD_DURATION = 20;
    protected int strength = 3;

    public PhytoGroItem(Item.Properties builder) {
        super(builder);
    }

    public PhytoGroItem(Item.Properties builder, int strength) {
        super(builder);
        this.strength = strength;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos;
        Level world = context.m_43725_();
        if (PhytoGroItem.attemptGrowPlant(world, pos = context.m_8083_(), context, this.strength)) {
            if (!world.f_46443_) {
                world.m_46796_(2005, pos, 0);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected static boolean attemptGrowPlant(Level world, BlockPos pos, UseOnContext context, int strength) {
        int hook;
        ItemStack stack = context.m_43722_();
        BlockState state = world.m_8055_(pos);
        Player player = context.m_43723_();
        if (player != null && (hook = ForgeEventFactory.onApplyBonemeal((Player)player, (Level)world, (BlockPos)pos, (BlockState)state, (ItemStack)stack)) != 0) {
            return hook > 0;
        }
        boolean used = PhytoGroItem.growPlant(world, pos, state, strength);
        if (Utils.isServerWorld((Level)world) && (used |= PhytoGroItem.growWaterPlant(world, pos, context.m_43719_())) && world.f_46441_.nextInt(strength) == 0) {
            stack.m_41774_(1);
        }
        return used;
    }

    protected static boolean growPlant(Level worldIn, BlockPos pos, BlockState state, int strength) {
        Block block = state.m_60734_();
        if (block instanceof BonemealableBlock) {
            BonemealableBlock growable = (BonemealableBlock)block;
            boolean used = false;
            if (growable.m_7370_((BlockGetter)worldIn, pos, state, worldIn.f_46443_)) {
                block7: {
                    if (worldIn instanceof ServerLevel) {
                        boolean canUse = false;
                        for (int i = 0; i < strength; ++i) {
                            canUse |= growable.m_5491_(worldIn, worldIn.f_46441_, pos, state);
                        }
                        if (canUse) {
                            try {
                                growable.m_7719_((ServerLevel)worldIn, worldIn.f_46441_, pos, state);
                            }
                            catch (Exception e) {
                                if (growable instanceof BambooBlock) break block7;
                                throw e;
                            }
                        }
                    }
                }
                used = true;
            }
            return used;
        }
        return false;
    }

    public static boolean growWaterPlant(Level worldIn, BlockPos pos, @Nullable Direction side) {
        if (worldIn.m_8055_(pos).m_60713_(Blocks.f_49990_) && worldIn.m_6425_(pos).m_76186_() == 8) {
            if (!(worldIn instanceof ServerLevel)) {
                return true;
            }
            Random random = worldIn.m_5822_();
            block0: for (int i = 0; i < 128; ++i) {
                BlockPos blockpos = pos;
                BlockState blockstate = Blocks.f_50037_.m_49966_();
                for (int j = 0; j < i / 16; ++j) {
                    if (worldIn.m_8055_(blockpos = blockpos.m_142082_(random.nextInt(3) - 1, (random.nextInt(3) - 1) * random.nextInt(3) / 2, random.nextInt(3) - 1)).m_60838_((BlockGetter)worldIn, blockpos)) continue block0;
                }
                Holder holder = worldIn.m_204166_(blockpos);
                if (holder.m_203565_(Biomes.f_48166_)) {
                    if (i == 0 && side != null && side.m_122434_().m_122479_()) {
                        blockstate = Registry.f_122824_.m_203431_(BlockTags.f_13052_).flatMap(p_204098_ -> p_204098_.m_203450_(worldIn.f_46441_)).map(p_204100_ -> ((Block)p_204100_.m_203334_()).m_49966_()).orElse(blockstate);
                        if (blockstate.m_61138_((Property)BaseCoralWallFanBlock.f_49192_)) {
                            blockstate = (BlockState)blockstate.m_61124_((Property)BaseCoralWallFanBlock.f_49192_, (Comparable)side);
                        }
                    } else if (random.nextInt(4) == 0) {
                        blockstate = Registry.f_122824_.m_203431_(BlockTags.f_13050_).flatMap(p_204091_ -> p_204091_.m_203450_(worldIn.f_46441_)).map(p_204095_ -> ((Block)p_204095_.m_203334_()).m_49966_()).orElse(blockstate);
                    }
                }
                if (blockstate.m_204338_(BlockTags.f_13052_, p_204093_ -> p_204093_.m_61138_((Property)BaseCoralWallFanBlock.f_49192_))) {
                    for (int k = 0; !blockstate.m_60710_((LevelReader)worldIn, blockpos) && k < 4; ++k) {
                        blockstate = (BlockState)blockstate.m_61124_((Property)BaseCoralWallFanBlock.f_49192_, (Comparable)Direction.Plane.HORIZONTAL.m_122560_(random));
                    }
                }
                if (!blockstate.m_60710_((LevelReader)worldIn, blockpos)) continue;
                BlockState blockstate1 = worldIn.m_8055_(blockpos);
                if (blockstate1.m_60713_(Blocks.f_49990_) && worldIn.m_6425_(blockpos).m_76186_() == 8) {
                    worldIn.m_7731_(blockpos, blockstate, 3);
                    continue;
                }
                if (!blockstate1.m_60713_(Blocks.f_50037_) || random.nextInt(10) != 0) continue;
                ((BonemealableBlock)Blocks.f_50037_).m_7719_((ServerLevel)worldIn, random, blockpos, blockstate1);
            }
            return true;
        }
        return false;
    }

    protected static void makeAreaOfEffectCloud(Level world, BlockPos pos, int radius) {
        boolean isPlant = world.m_8055_(pos).m_60734_() instanceof IPlantable;
        AreaEffectCloud cloud = new AreaEffectCloud(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + (isPlant ? 0.0 : 1.0), (double)pos.m_123343_() + 0.5);
        cloud.m_19712_(1.0f);
        cloud.m_19724_((ParticleOptions)ParticleTypes.f_123748_);
        cloud.m_19734_(20);
        cloud.m_19740_(0);
        cloud.m_19738_(((float)(1 + radius) - cloud.m_19743_()) / (float)cloud.m_19748_());
        world.m_7967_((Entity)cloud);
    }
}

