/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.item;

import cofh.core.item.ItemCoFH;
import cofh.lib.util.Utils;
import cofh.lib.util.references.CoreReferences;
import cofh.thermal.core.entity.projectile.BlitzProjectile;
import cofh.thermal.core.init.TCoreSounds;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;

public class LightningChargeItem
extends ItemCoFH {
    private static final DispenseItemBehavior DISPENSER_BEHAVIOR = new DefaultDispenseItemBehavior(){

        public ItemStack m_7498_(BlockSource source, ItemStack stack) {
            Direction direction = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
            Position iposition = DispenserBlock.m_52720_((BlockSource)source);
            double d0 = iposition.m_7096_() + (double)((float)direction.m_122429_() * 0.3f);
            double d1 = iposition.m_7098_() + (double)((float)direction.m_122430_() * 0.3f);
            double d2 = iposition.m_7094_() + (double)((float)direction.m_122431_() * 0.3f);
            ServerLevel world = source.m_7727_();
            Random random = world.f_46441_;
            double d3 = random.nextGaussian() * 0.05 + (double)direction.m_122429_();
            double d4 = random.nextGaussian() * 0.05 + (double)direction.m_122430_();
            double d5 = random.nextGaussian() * 0.05 + (double)direction.m_122431_();
            world.m_7967_((Entity)new BlitzProjectile(d0, d1, d2, d3, d4, d5, (Level)world));
            stack.m_41774_(1);
            return stack;
        }

        protected void m_6823_(BlockSource source) {
            source.m_7727_().m_46796_(1018, source.m_7961_(), 0);
        }
    };

    public LightningChargeItem(Item.Properties builder) {
        super(builder);
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)DISPENSER_BEHAVIOR);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos;
        Player player = context.m_43723_();
        Level world = context.m_43725_();
        if (world.m_45527_(pos = context.m_8083_().m_142300_(context.m_43719_()))) {
            if (world instanceof ServerLevel) {
                if (player != null) {
                    player.m_7292_(new MobEffectInstance(CoreReferences.LIGHTNING_RESISTANCE, 20, 0, false, false, false));
                }
                Utils.spawnLightningBolt((Level)world, (BlockPos)pos, (Entity)player);
            }
            this.playUseSound(world, pos);
            context.m_43722_().m_41774_(1);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    private void playUseSound(Level worldIn, BlockPos pos) {
        worldIn.m_5594_(null, pos, TCoreSounds.SOUND_BLITZ_SHOOT, SoundSource.BLOCKS, 1.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f);
    }
}

