/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.inventory.container.storage;

import cofh.core.network.packet.server.SecurityPacket;
import cofh.lib.inventory.IInventoryContainerItem;
import cofh.lib.inventory.SimpleItemInv;
import cofh.lib.inventory.container.ContainerCoFH;
import cofh.lib.inventory.container.slot.SlotCoFH;
import cofh.lib.inventory.container.slot.SlotLocked;
import cofh.lib.inventory.wrapper.InvWrapperCoFH;
import cofh.lib.util.Utils;
import cofh.lib.util.control.ISecurable;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.SecurityHelper;
import cofh.thermal.core.init.TCoreReferences;
import cofh.thermal.core.item.SatchelItem;
import com.mojang.authlib.GameProfile;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class SatchelContainer
extends ContainerCoFH
implements ISecurable {
    public static final int MAX_SLOTS = 54;
    public static final int MAX_ROWS = 6;
    protected final IInventoryContainerItem containerItem;
    protected SimpleItemInv itemInventory;
    protected InvWrapperCoFH invWrapper;
    protected ItemStack containerStack;
    public SlotLocked lockedSlot;
    protected int numSlots;
    protected int rows;

    private static boolean isSatchel(ItemStack stack) {
        return stack.m_41720_() instanceof SatchelItem;
    }

    public SatchelContainer(int windowId, Inventory inventory, Player player) {
        super(TCoreReferences.SATCHEL_CONTAINER, windowId, inventory, player);
        int i;
        this.allowSwap = false;
        this.containerStack = SatchelContainer.isSatchel(player.m_21205_()) ? player.m_21205_() : player.m_21206_();
        this.containerItem = (IInventoryContainerItem)this.containerStack.m_41720_();
        this.numSlots = MathHelper.clamp((int)this.containerItem.getContainerSlots(this.containerStack), (int)0, (int)54);
        this.itemInventory = this.containerItem.getContainerInventory(this.containerStack);
        this.invWrapper = new InvWrapperCoFH(this.itemInventory, this.numSlots);
        this.rows = MathHelper.clamp((int)(this.numSlots / 9), (int)0, (int)6);
        int extraSlots = this.numSlots % 9;
        int xOffset = 8;
        int yOffset = 44 - 9 * MathHelper.clamp((int)(this.rows + (extraSlots > 0 ? 1 : 0)), (int)0, (int)3);
        for (i = 0; i < this.rows * 9; ++i) {
            this.m_38897_((Slot)new SlotCoFH(this.invWrapper, i, xOffset + i % 9 * 18, yOffset + i / 9 * 18));
        }
        if (extraSlots > 0) {
            xOffset = 89 - 9 * extraSlots;
            for (i = this.numSlots - extraSlots; i < this.numSlots; ++i) {
                this.m_38897_((Slot)new SlotCoFH(this.invWrapper, i, xOffset + i % extraSlots * 18, yOffset + 18 * this.rows));
            }
        }
        this.bindPlayerInventory(inventory);
    }

    protected void bindPlayerInventory(Inventory inventory) {
        int i;
        int xOffset = this.getPlayerInventoryHorizontalOffset();
        int yOffset = this.getPlayerInventoryVerticalOffset();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inventory, j + i * 9 + 9, xOffset + j * 18, yOffset + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            if (i == inventory.f_35977_) {
                this.lockedSlot = new SlotLocked((Container)inventory, i, xOffset + i * 18, yOffset + 58);
                this.m_38897_((Slot)this.lockedSlot);
                continue;
            }
            this.m_38897_(new Slot((Container)inventory, i, xOffset + i * 18, yOffset + 58));
        }
    }

    protected int getPlayerInventoryVerticalOffset() {
        return 84 + this.getExtraRows() * 18;
    }

    public int getExtraRows() {
        return MathHelper.clamp((int)(this.rows + (this.numSlots % 9 > 0 ? 1 : 0) - 3), (int)0, (int)3);
    }

    public int getContainerInventorySize() {
        return this.numSlots;
    }

    protected int getMergeableSlotCount() {
        return this.invWrapper.m_6643_();
    }

    public boolean m_6875_(Player playerIn) {
        return true;
    }

    public void m_6877_(Player playerIn) {
        this.itemInventory.write(this.containerItem.getOrCreateInvTag(this.containerStack));
        this.containerItem.onContainerInventoryChanged(this.containerStack);
        super.m_6877_(playerIn);
    }

    public ISecurable.AccessMode getAccess() {
        return SecurityHelper.getAccess((ItemStack)this.containerStack);
    }

    public GameProfile getOwner() {
        return SecurityHelper.getOwner((ItemStack)this.containerStack);
    }

    public void setAccess(ISecurable.AccessMode access) {
        SecurityHelper.setAccess((ItemStack)this.containerStack, (ISecurable.AccessMode)access);
        if (Utils.isClientWorld((Level)this.player.f_19853_)) {
            SecurityPacket.sendToServer((ISecurable.AccessMode)access);
        }
    }

    public boolean setOwner(GameProfile profile) {
        return false;
    }
}

