/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.entity.monster;

import cofh.lib.util.references.CoreReferences;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.core.config.ThermalClientConfig;
import cofh.thermal.core.entity.projectile.BasalzProjectile;
import cofh.thermal.core.init.TCoreSounds;
import cofh.thermal.lib.common.ThermalFlags;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Basalz
extends Monster {
    public static final int DEFAULT_ORBIT = 8;
    public static final int DEPLOY_TIME = 6;
    private static final EntityDataAccessor<Byte> ANGRY = SynchedEntityData.m_135353_(Basalz.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final Vec3 VERT = new Vec3(0.0, 1.0, 0.0);
    protected int attackTime = 0;
    public int angerTime = 72000;
    protected boolean wasAngry = false;

    public static boolean canSpawn(EntityType<Basalz> entityType, ServerLevelAccessor world, MobSpawnType reason, BlockPos pos, Random rand) {
        return ThermalFlags.getFlag(ThermalFlags.FLAG_MOB_BASALZ).getAsBoolean() && Monster.m_33017_(entityType, (ServerLevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (Random)rand);
    }

    public Basalz(EntityType<? extends Basalz> type, Level world) {
        super(type, world);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.LAVA, 2.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
        this.f_21364_ = 10;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(4, (Goal)new BasalzAttackGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new FloatGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22279_, (double)0.23f).m_22268_(Attributes.f_22277_, 48.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANGRY, (Object)16);
    }

    protected SoundEvent m_7515_() {
        return ThermalClientConfig.mobAmbientSounds ? TCoreSounds.SOUND_BASALZ_AMBIENT : null;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return TCoreSounds.SOUND_BASALZ_HURT;
    }

    protected SoundEvent m_5592_() {
        return TCoreSounds.SOUND_BASALZ_DEATH;
    }

    public void m_8107_() {
        if (!this.f_19861_ && this.m_20184_().f_82480_ < 0.0) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.6, 1.0));
        }
        if (this.f_19853_.f_46443_) {
            if (this.isAngry() && this.f_19796_.nextInt(2) == 0) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123801_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
            }
            ++this.angerTime;
        } else if (this.m_6084_() && this.isAngry() && this.attackTime <= 0 && this.getOrbit() > 0) {
            Vec3 pos = this.m_20182_();
            for (Entity target : this.f_19853_.m_45976_(LivingEntity.class, this.m_142469_().m_82377_(4.0, 1.0, 4.0))) {
                if (target instanceof Basalz || !(this.m_20280_(target) < 12.25) || !this.m_142582_(target)) continue;
                this.attackTime = 15;
                Vec3 targetPos = target.m_20182_();
                Vec3 offset = targetPos.m_82546_(pos).m_82541_().m_82537_(VERT).m_82490_(0.5);
                BasalzProjectile projectile = new BasalzProjectile(targetPos.f_82479_ + offset.f_82479_, this.m_20186_() + (double)(this.m_20206_() * 0.5f), targetPos.f_82481_ + offset.f_82481_, 0.0, 0.0, 0.0, this.f_19853_);
                projectile.m_20334_(-offset.f_82479_, 0.0, -offset.f_82481_);
                projectile.m_5602_((Entity)this);
                projectile.m_6532_((HitResult)new EntityHitResult(target));
                if (this.getOrbit() > 0) {
                    this.reduceOrbit();
                    continue;
                }
                break;
            }
        } else {
            --this.attackTime;
        }
        super.m_8107_();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return super.m_6469_(source, source == DamageSource.f_19306_ ? amount + 3.0f : amount);
    }

    public boolean m_7301_(MobEffectInstance effect) {
        return super.m_7301_(effect) && !effect.m_19544_().equals(CoreReferences.SUNDERED);
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)ThermalCore.ITEMS.get("basalz_spawn_egg"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB m_6921_() {
        return this.isAngry() ? super.m_6921_().m_82400_(4.0) : super.m_6921_();
    }

    public boolean m_6673_(DamageSource source) {
        return source.f_19326_.equals("basalz") || super.m_6673_(source);
    }

    public boolean isAngry() {
        return ((Byte)this.f_19804_.m_135370_(ANGRY) & 1) != 0;
    }

    protected void setAngry(boolean angry) {
        byte b0 = (Byte)this.f_19804_.m_135370_(ANGRY);
        b0 = angry ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.f_19804_.m_135381_(ANGRY, (Object)b0);
    }

    public int getOrbit() {
        return ((Byte)this.f_19804_.m_135370_(ANGRY) & 0x3E) >> 1;
    }

    public void setOrbit(int orbit) {
        this.f_19804_.m_135381_(ANGRY, (Object)((byte)((Byte)this.f_19804_.m_135370_(ANGRY) & 0xFFFFFFC1 | (orbit & 0x1F) << 1)));
    }

    public void reduceOrbit() {
        this.setOrbit(Math.max(this.getOrbit() - 1, 0));
    }

    public void resetOrbit() {
        this.setOrbit(8);
    }

    public void m_7350_(EntityDataAccessor<?> data) {
        super.m_7350_(data);
        if (this.f_19853_.f_46443_ && data.equals(ANGRY) && this.isAngry() != this.wasAngry) {
            this.angerTime = Math.max(0, 6 - this.angerTime);
            this.wasAngry = this.isAngry();
        }
    }

    static class BasalzAttackGoal
    extends Goal {
        private final Basalz basalz;
        private int attackTime;
        private int refreshTime = 100;
        private int chaseStep;
        private int navTime;

        public BasalzAttackGoal(Basalz basalzIn) {
            this.basalz = basalzIn;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.basalz.m_5448_();
            return livingentity != null && livingentity.m_6084_() && this.basalz.m_6779_(livingentity);
        }

        public void m_8056_() {
            this.chaseStep = 0;
            this.navTime = 0;
            this.refreshTime = 100;
        }

        public void m_8041_() {
            this.basalz.setAngry(false);
            this.chaseStep = 0;
            this.navTime = 0;
            this.refreshTime = 100;
        }

        public void m_8037_() {
            --this.attackTime;
            --this.navTime;
            LivingEntity target = this.basalz.m_5448_();
            if (target == null) {
                return;
            }
            Vec3 pos = this.basalz.m_20182_();
            Vec3 targetPos = target.m_20182_();
            double distSqr = this.basalz.m_20280_((Entity)target);
            if (this.basalz.m_21574_().m_148306_((Entity)target) && distSqr < this.getFollowDistance() * this.getFollowDistance()) {
                this.chaseStep = 0;
                if (this.basalz.getOrbit() > 0) {
                    this.basalz.m_21563_().m_24960_((Entity)target, 10.0f, 10.0f);
                    if (!this.basalz.isAngry()) {
                        this.basalz.setAngry(true);
                        this.basalz.f_19853_.m_6263_(null, pos.f_82479_ + 0.5, pos.f_82480_ + 0.5, pos.f_82481_ + 0.5, TCoreSounds.SOUND_BASALZ_SHOOT, SoundSource.HOSTILE, 2.5f, (this.basalz.f_19796_.nextFloat() - 0.5f) * 0.2f + 1.0f);
                        this.navTime = 0;
                    }
                    if (distSqr < 2.25) {
                        if (this.attackTime <= 0) {
                            this.attackTime = 20;
                            this.basalz.m_7327_((Entity)target);
                        }
                    } else if (distSqr < 12.25) {
                        this.basalz.f_21344_.m_26573_();
                        this.navTime = 0;
                    } else if (this.navTime <= 0) {
                        this.basalz.f_21344_.m_5624_((Entity)target, 1.0);
                        this.navTime = 15;
                    }
                } else {
                    if (this.basalz.isAngry()) {
                        this.basalz.setAngry(false);
                        this.navTime = 0;
                    }
                    if (this.refreshTime > 0) {
                        --this.refreshTime;
                        if (distSqr < 144.0 && this.navTime <= 0) {
                            Vec3 diff = new Vec3(pos.f_82479_ - targetPos.f_82479_, 0.0, pos.f_82481_ - targetPos.f_82481_).m_82541_().m_82490_(16.0);
                            this.basalz.m_21563_().m_24950_(targetPos.f_82479_ + diff.f_82479_, this.basalz.m_20188_(), targetPos.f_82481_ + diff.f_82481_, 10.0f, 10.0f);
                            this.basalz.f_21344_.m_26519_(targetPos.f_82479_ + diff.f_82479_, targetPos.f_82480_, targetPos.f_82481_ + diff.f_82481_, 1.0);
                            this.navTime = 15;
                        }
                    } else {
                        this.refreshTime = 100;
                        this.basalz.resetOrbit();
                    }
                }
            } else if (this.chaseStep < 5) {
                ++this.chaseStep;
                this.basalz.m_21566_().m_6849_(targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_, 1.0);
            } else {
                this.basalz.setAngry(false);
            }
            super.m_8037_();
        }

        private double getFollowDistance() {
            return this.basalz.m_21133_(Attributes.f_22277_);
        }
    }
}

