/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.data;

import cofh.lib.data.ItemModelProviderCoFH;
import cofh.lib.util.DeferredRegisterCoFH;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.core.util.RegistrationHelper;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.ExistingFileHelper;

public class TCoreItemModelProvider
extends ItemModelProviderCoFH {
    public static final String AUGMENTS = "augments";

    public TCoreItemModelProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "thermal", existingFileHelper);
    }

    public String m_6055_() {
        return "Thermal Core: Item Models";
    }

    protected void registerModels() {
        this.registerBlockItemModels();
        DeferredRegisterCoFH<Item> reg = ThermalCore.ITEMS;
        this.registerVanilla(reg);
        this.registerResources(reg);
        this.registerParts(reg);
        this.registerTools(reg);
        this.registerArmor(reg);
        this.registerAugments(reg);
    }

    private void registerVanilla(DeferredRegisterCoFH<Item> reg) {
        this.metalSet(reg, "copper", true);
        this.metalSet(reg, "iron", true);
        this.metalSet(reg, "gold", true);
        this.metalSet(reg, "netherite", true);
        this.gemSet(reg, "lapis", true);
        this.gemSet(reg, "diamond", true);
        this.gemSet(reg, "emerald", true);
        this.gemSet(reg, "quartz", true);
        this.generated((Supplier)reg.getSup("ender_pearl_dust"));
    }

    private void registerResources(DeferredRegisterCoFH<Item> reg) {
        this.generated((Supplier)reg.getSup("sawdust"));
        this.generated((Supplier)reg.getSup("coal_coke"));
        this.generated((Supplier)reg.getSup("bitumen"));
        this.generated((Supplier)reg.getSup("tar"));
        this.generated((Supplier)reg.getSup("rosin"));
        this.generated((Supplier)reg.getSup("rubber"));
        this.generated((Supplier)reg.getSup("cured_rubber"));
        this.generated((Supplier)reg.getSup("slag"));
        this.generated((Supplier)reg.getSup("rich_slag"));
        this.generated((Supplier)reg.getSup("syrup_bottle"));
        this.generated((Supplier)reg.getSup("junk_net"));
        this.generated((Supplier)reg.getSup("aquachow"));
        this.generated((Supplier)reg.getSup("deep_aquachow"));
        this.generated((Supplier)reg.getSup("beekeeper_fabric"));
        this.generated((Supplier)reg.getSup("diving_fabric"));
        this.generated((Supplier)reg.getSup("hazmat_fabric"));
        this.generated((Supplier)reg.getSup("apatite_dust"));
        this.generated((Supplier)reg.getSup("cinnabar_dust"));
        this.generated((Supplier)reg.getSup("niter_dust"));
        this.generated((Supplier)reg.getSup("sulfur_dust"));
        this.generated((Supplier)reg.getSup("apatite"));
        this.generated((Supplier)reg.getSup("cinnabar"));
        this.generated((Supplier)reg.getSup("niter"));
        this.generated((Supplier)reg.getSup("sulfur"));
        this.generated((Supplier)reg.getSup("basalz_rod"));
        this.generated((Supplier)reg.getSup("basalz_powder"));
        this.generated((Supplier)reg.getSup("blitz_rod"));
        this.generated((Supplier)reg.getSup("blitz_powder"));
        this.generated((Supplier)reg.getSup("blizz_rod"));
        this.generated((Supplier)reg.getSup("blizz_powder"));
        this.generated((Supplier)reg.getSup("redstone_bucket"));
        this.generated((Supplier)reg.getSup("glowstone_bucket"));
        this.generated((Supplier)reg.getSup("ender_bucket"));
        this.generated((Supplier)reg.getSup("creosote_bucket"));
        this.generated((Supplier)reg.getSup("crude_oil_bucket"));
        this.generated((Supplier)reg.getSup("heavy_oil_bucket"));
        this.generated((Supplier)reg.getSup("light_oil_bucket"));
        this.generated((Supplier)reg.getSup("refined_fuel_bucket"));
        this.generated((Supplier)reg.getSup("latex_bucket"));
        this.generated((Supplier)reg.getSup("resin_bucket"));
        this.generated((Supplier)reg.getSup("sap_bucket"));
        this.generated((Supplier)reg.getSup("syrup_bucket"));
        this.generated((Supplier)reg.getSup("tree_oil_bucket"));
        this.generated((Supplier)reg.getSup("copper_nugget"));
        this.generated((Supplier)reg.getSup("netherite_nugget"));
        this.metalSet(reg, "lead");
        this.metalSet(reg, "nickel");
        this.metalSet(reg, "silver");
        this.metalSet(reg, "tin");
        this.alloySet(reg, "bronze");
        this.alloySet(reg, "constantan");
        this.alloySet(reg, "electrum");
        this.alloySet(reg, "invar");
        this.gemSet(reg, "ruby");
        this.gemSet(reg, "sapphire");
        this.alloySet(reg, "signalum");
        this.alloySet(reg, "lumium");
        this.alloySet(reg, "enderium");
    }

    private void registerParts(DeferredRegisterCoFH<Item> reg) {
        this.generated((Supplier)reg.getSup("redstone_servo"));
        this.generated((Supplier)reg.getSup("rf_coil"));
        this.generated((Supplier)reg.getSup("drill_head"));
        this.generated((Supplier)reg.getSup("saw_blade"));
        this.generated((Supplier)reg.getSup("laser_diode"));
    }

    private void registerTools(DeferredRegisterCoFH<Item> reg) {
        this.handheld((Supplier)reg.getSup("wrench"));
        this.generated((Supplier)reg.getSup("rf_potato"));
        this.generated((Supplier)reg.getSup("lock"));
        this.generated((Supplier)reg.getSup("phytogro"));
        this.generated((Supplier)reg.getSup("earth_charge"));
        this.generated((Supplier)reg.getSup("ice_charge"));
        this.generated((Supplier)reg.getSup("lightning_charge"));
    }

    private void registerArmor(DeferredRegisterCoFH<Item> reg) {
        this.generated((Supplier)reg.getSup("beekeeper_helmet"));
        this.generated((Supplier)reg.getSup("beekeeper_chestplate"));
        this.generated((Supplier)reg.getSup("beekeeper_leggings"));
        this.generated((Supplier)reg.getSup("beekeeper_boots"));
        this.generated((Supplier)reg.getSup("diving_helmet"));
        this.generated((Supplier)reg.getSup("diving_chestplate"));
        this.generated((Supplier)reg.getSup("diving_leggings"));
        this.generated((Supplier)reg.getSup("diving_boots"));
        this.generated((Supplier)reg.getSup("hazmat_helmet"));
        this.generated((Supplier)reg.getSup("hazmat_chestplate"));
        this.generated((Supplier)reg.getSup("hazmat_leggings"));
        this.generated((Supplier)reg.getSup("hazmat_boots"));
    }

    private void registerAugments(DeferredRegisterCoFH<Item> reg) {
        this.generated((Supplier)reg.getSup("rs_control_augment"), AUGMENTS);
        this.generated((Supplier)reg.getSup("side_config_augment"), AUGMENTS);
        this.generated((Supplier)reg.getSup("xp_storage_augment"), AUGMENTS);
        this.generated((Supplier)reg.getSup("fluid_tank_augment"), AUGMENTS);
        this.generated((Supplier)reg.getSup("rf_coil_augment"), AUGMENTS);
        this.generated((Supplier)reg.getSup("rf_coil_storage_augment"), AUGMENTS);
        this.generated((Supplier)reg.getSup("rf_coil_xfer_augment"), AUGMENTS);
        this.generated((Supplier)reg.getSup("fluid_tank_creative_augment"), AUGMENTS);
        this.generated((Supplier)reg.getSup("rf_coil_creative_augment"), AUGMENTS);
        this.generated((Supplier)reg.getSup("area_radius_augment"), AUGMENTS);
        this.generated((Supplier)reg.getSup("item_filter_augment"), AUGMENTS);
        this.generated((Supplier)reg.getSup("potion_amplifier_augment"), AUGMENTS);
        this.generated((Supplier)reg.getSup("potion_duration_augment"), AUGMENTS);
        this.generated((Supplier)reg.getSup("machine_speed_augment"), AUGMENTS);
        this.generated((Supplier)reg.getSup("machine_efficiency_augment"), AUGMENTS);
        this.generated((Supplier)reg.getSup("machine_efficiency_creative_augment"), AUGMENTS);
        this.generated((Supplier)reg.getSup("machine_output_augment"), AUGMENTS);
        this.generated((Supplier)reg.getSup("machine_catalyst_augment"), AUGMENTS);
        this.generated((Supplier)reg.getSup("machine_catalyst_creative_augment"), AUGMENTS);
        this.generated((Supplier)reg.getSup("machine_cycle_augment"), AUGMENTS);
        this.generated((Supplier)reg.getSup("machine_null_augment"), AUGMENTS);
        this.generated((Supplier)reg.getSup("dynamo_output_augment"), AUGMENTS);
        this.generated((Supplier)reg.getSup("dynamo_fuel_augment"), AUGMENTS);
    }

    private void registerBlockItemModels() {
        DeferredRegisterCoFH<Block> reg = ThermalCore.BLOCKS;
        this.registerVanillaBlocks(reg);
        this.registerResourceBlocks(reg);
        this.registerStorageBlocks(reg);
        this.registerBuildingBlocks(reg);
        this.registerMiscBlocks(reg);
    }

    private void registerVanillaBlocks(DeferredRegisterCoFH<Block> reg) {
        this.blockItem((Supplier)reg.getSup("charcoal_block"));
        this.blockItem((Supplier)reg.getSup("bamboo_block"));
        this.blockItem((Supplier)reg.getSup("sugar_cane_block"));
        this.blockItem((Supplier)reg.getSup("gunpowder_block"));
        this.blockItem((Supplier)reg.getSup("apple_block"));
        this.blockItem((Supplier)reg.getSup("beetroot_block"));
        this.blockItem((Supplier)reg.getSup("carrot_block"));
        this.blockItem((Supplier)reg.getSup("potato_block"));
    }

    private void registerResourceBlocks(DeferredRegisterCoFH<Block> reg) {
        this.blockItem((Supplier)reg.getSup("apatite_ore"));
        this.blockItem((Supplier)reg.getSup("cinnabar_ore"));
        this.blockItem((Supplier)reg.getSup("niter_ore"));
        this.blockItem((Supplier)reg.getSup("sulfur_ore"));
        this.blockItem((Supplier)reg.getSup("lead_ore"));
        this.blockItem((Supplier)reg.getSup("nickel_ore"));
        this.blockItem((Supplier)reg.getSup("silver_ore"));
        this.blockItem((Supplier)reg.getSup("tin_ore"));
        this.blockItem((Supplier)reg.getSup("ruby_ore"));
        this.blockItem((Supplier)reg.getSup("sapphire_ore"));
        this.blockItem((Supplier)reg.getSup(RegistrationHelper.deepslate("apatite_ore")));
        this.blockItem((Supplier)reg.getSup(RegistrationHelper.deepslate("cinnabar_ore")));
        this.blockItem((Supplier)reg.getSup(RegistrationHelper.deepslate("niter_ore")));
        this.blockItem((Supplier)reg.getSup(RegistrationHelper.deepslate("sulfur_ore")));
        this.blockItem((Supplier)reg.getSup(RegistrationHelper.deepslate("lead_ore")));
        this.blockItem((Supplier)reg.getSup(RegistrationHelper.deepslate("nickel_ore")));
        this.blockItem((Supplier)reg.getSup(RegistrationHelper.deepslate("silver_ore")));
        this.blockItem((Supplier)reg.getSup(RegistrationHelper.deepslate("tin_ore")));
        this.blockItem((Supplier)reg.getSup(RegistrationHelper.deepslate("ruby_ore")));
        this.blockItem((Supplier)reg.getSup(RegistrationHelper.deepslate("sapphire_ore")));
        this.blockItem((Supplier)reg.getSup("oil_sand"));
        this.blockItem((Supplier)reg.getSup("oil_red_sand"));
    }

    private void registerStorageBlocks(DeferredRegisterCoFH<Block> reg) {
        this.blockItem((Supplier)reg.getSup("apatite_block"));
        this.blockItem((Supplier)reg.getSup("cinnabar_block"));
        this.blockItem((Supplier)reg.getSup("niter_block"));
        this.blockItem((Supplier)reg.getSup("sulfur_block"));
        this.blockItem((Supplier)reg.getSup(RegistrationHelper.raw("lead_block")));
        this.blockItem((Supplier)reg.getSup(RegistrationHelper.raw("nickel_block")));
        this.blockItem((Supplier)reg.getSup(RegistrationHelper.raw("silver_block")));
        this.blockItem((Supplier)reg.getSup(RegistrationHelper.raw("tin_block")));
        this.blockItem((Supplier)reg.getSup("lead_block"));
        this.blockItem((Supplier)reg.getSup("nickel_block"));
        this.blockItem((Supplier)reg.getSup("silver_block"));
        this.blockItem((Supplier)reg.getSup("tin_block"));
        this.blockItem((Supplier)reg.getSup("ruby_block"));
        this.blockItem((Supplier)reg.getSup("sapphire_block"));
        this.blockItem((Supplier)reg.getSup("bronze_block"));
        this.blockItem((Supplier)reg.getSup("electrum_block"));
        this.blockItem((Supplier)reg.getSup("invar_block"));
        this.blockItem((Supplier)reg.getSup("constantan_block"));
        this.blockItem((Supplier)reg.getSup("enderium_block"));
        this.blockItem((Supplier)reg.getSup("lumium_block"));
        this.blockItem((Supplier)reg.getSup("signalum_block"));
        this.blockItem((Supplier)reg.getSup("sawdust_block"));
        this.blockItem((Supplier)reg.getSup("coal_coke_block"));
        this.blockItem((Supplier)reg.getSup("bitumen_block"));
        this.blockItem((Supplier)reg.getSup("tar_block"));
        this.blockItem((Supplier)reg.getSup("rosin_block"));
        this.blockItem((Supplier)reg.getSup("rubber_block"));
        this.blockItem((Supplier)reg.getSup("cured_rubber_block"));
        this.blockItem((Supplier)reg.getSup("slag_block"));
        this.blockItem((Supplier)reg.getSup("rich_slag_block"));
    }

    private void registerBuildingBlocks(DeferredRegisterCoFH<Block> reg) {
        this.blockItem((Supplier)reg.getSup("obsidian_glass"));
        this.blockItem((Supplier)reg.getSup("signalum_glass"));
        this.blockItem((Supplier)reg.getSup("lumium_glass"));
        this.blockItem((Supplier)reg.getSup("enderium_glass"));
        this.blockItem((Supplier)reg.getSup("white_rockwool"));
        this.blockItem((Supplier)reg.getSup("orange_rockwool"));
        this.blockItem((Supplier)reg.getSup("magenta_rockwool"));
        this.blockItem((Supplier)reg.getSup("light_blue_rockwool"));
        this.blockItem((Supplier)reg.getSup("yellow_rockwool"));
        this.blockItem((Supplier)reg.getSup("lime_rockwool"));
        this.blockItem((Supplier)reg.getSup("pink_rockwool"));
        this.blockItem((Supplier)reg.getSup("gray_rockwool"));
        this.blockItem((Supplier)reg.getSup("light_gray_rockwool"));
        this.blockItem((Supplier)reg.getSup("cyan_rockwool"));
        this.blockItem((Supplier)reg.getSup("purple_rockwool"));
        this.blockItem((Supplier)reg.getSup("blue_rockwool"));
        this.blockItem((Supplier)reg.getSup("brown_rockwool"));
        this.blockItem((Supplier)reg.getSup("green_rockwool"));
        this.blockItem((Supplier)reg.getSup("red_rockwool"));
        this.blockItem((Supplier)reg.getSup("black_rockwool"));
        this.blockItem((Supplier)reg.getSup("polished_slag"));
        this.blockItem((Supplier)reg.getSup("chiseled_slag"));
        this.blockItem((Supplier)reg.getSup("slag_bricks"));
        this.blockItem((Supplier)reg.getSup("cracked_slag_bricks"));
        this.blockItem((Supplier)reg.getSup("polished_rich_slag"));
        this.blockItem((Supplier)reg.getSup("chiseled_rich_slag"));
        this.blockItem((Supplier)reg.getSup("rich_slag_bricks"));
        this.blockItem((Supplier)reg.getSup("cracked_rich_slag_bricks"));
    }

    private void registerMiscBlocks(DeferredRegisterCoFH<Block> reg) {
        this.blockItem((Supplier)reg.getSup("slime_tnt"));
        this.blockItem((Supplier)reg.getSup("redstone_tnt"));
        this.blockItem((Supplier)reg.getSup("glowstone_tnt"));
        this.blockItem((Supplier)reg.getSup("ender_tnt"));
        this.blockItem((Supplier)reg.getSup("phyto_tnt"));
        this.blockItem((Supplier)reg.getSup("fire_tnt"));
        this.blockItem((Supplier)reg.getSup("earth_tnt"));
        this.blockItem((Supplier)reg.getSup("ice_tnt"));
        this.blockItem((Supplier)reg.getSup("lightning_tnt"));
        this.blockItem((Supplier)reg.getSup("nuke_tnt"));
    }
}

