/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.config;

import cofh.lib.config.IBaseConfig;
import cofh.thermal.core.block.entity.device.DeviceFisherTile;
import cofh.thermal.core.block.entity.device.DeviceTreeExtractorTile;
import cofh.thermal.lib.common.ThermalFlags;
import net.minecraftforge.common.ForgeConfigSpec;

public class ThermalDeviceConfig
implements IBaseConfig {
    private ForgeConfigSpec.IntValue deviceTreeExtractorTimeConstant;
    private ForgeConfigSpec.IntValue deviceFisherTimeConstant;
    private ForgeConfigSpec.IntValue deviceFisherTimeReductionWater;

    public void apply(ForgeConfigSpec.Builder builder) {
        builder.push("Devices");
        if (ThermalFlags.getFlag("device_tree_extractor").getAsBoolean()) {
            builder.push("TreeExtractor");
            this.deviceTreeExtractorTimeConstant = builder.comment("This sets the base time constant (in ticks) for the Arboreal Extractor.").defineInRange("Time Constant", 500, 20, 72000);
            builder.pop();
        }
        if (ThermalFlags.getFlag("device_fisher").getAsBoolean()) {
            builder.push("Fisher");
            this.deviceFisherTimeConstant = builder.comment("This sets the base time constant (in ticks) for the Aquatic Entangler.").defineInRange("Time Constant", 4800, 400, 72000);
            this.deviceFisherTimeReductionWater = builder.comment("This sets the time constant reduction (in ticks) per nearby Water source block for the Aquatic Entangler.").defineInRange("Water Source Time Constant Reduction", 20, 1, 1000);
            builder.pop();
        }
        builder.pop();
    }

    public void refresh() {
        if (this.deviceTreeExtractorTimeConstant != null) {
            DeviceTreeExtractorTile.setTimeConstant((Integer)this.deviceTreeExtractorTimeConstant.get());
        }
        if (this.deviceFisherTimeConstant != null) {
            DeviceFisherTile.setTimeConstant((Integer)this.deviceFisherTimeConstant.get());
            DeviceFisherTile.setTimeReductionWater((Integer)this.deviceFisherTimeReductionWater.get());
        }
    }
}

