/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.compat.jei.device;

import cofh.core.util.helpers.RenderHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermal.core.client.gui.device.DeviceTreeExtractorScreen;
import cofh.thermal.core.compat.jei.TCoreJeiPlugin;
import cofh.thermal.core.init.TCoreReferences;
import cofh.thermal.core.util.recipes.device.TreeExtractorMapping;
import cofh.thermal.lib.compat.jei.Drawables;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;

public class TreeExtractorCategory
implements IRecipeCategory<TreeExtractorMapping> {
    protected final ResourceLocation uid;
    protected IDrawable background;
    protected IDrawable icon;
    protected Component name;
    protected IDrawableStatic tankBackground;
    protected IDrawableStatic tankOverlay;
    protected IDrawableStatic progressFluidBackground;
    protected IDrawableAnimated progressFluid;

    public TreeExtractorCategory(IGuiHelper guiHelper, ItemStack icon, ResourceLocation uid) {
        this.uid = uid;
        this.icon = guiHelper.createDrawableIngredient((Object)icon);
        this.background = guiHelper.drawableBuilder(DeviceTreeExtractorScreen.TEXTURE, 86, 11, 80, 62).addPadding(0, 0, 16, 68).build();
        this.name = StringHelper.getTextComponent((String)TCoreReferences.DEVICE_TREE_EXTRACTOR_BLOCK.m_7705_());
        this.tankBackground = Drawables.getDrawables(guiHelper).getTank(1);
        this.tankOverlay = Drawables.getDrawables(guiHelper).getTankOverlay(1);
        this.progressFluidBackground = Drawables.getDrawables(guiHelper).getProgressFill(2);
        this.progressFluid = guiHelper.createAnimatedDrawable(Drawables.getDrawables(guiHelper).getProgress(2), 100, IDrawableAnimated.StartDirection.LEFT, true);
    }

    public ResourceLocation getUid() {
        return this.uid;
    }

    public Class<? extends TreeExtractorMapping> getRecipeClass() {
        return TreeExtractorMapping.class;
    }

    public Component getTitle() {
        return this.name;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(TreeExtractorMapping recipe, IIngredients ingredients) {
        ArrayList<ItemStack> inputItems = new ArrayList<ItemStack>();
        inputItems.add(new ItemStack((ItemLike)recipe.getTrunk()));
        inputItems.add(new ItemStack((ItemLike)recipe.getLeaves()));
        ingredients.setInputs(VanillaTypes.ITEM, inputItems);
        ingredients.setOutputs(VanillaTypes.FLUID, Collections.singletonList(recipe.getFluid()));
    }

    public void setRecipe(IRecipeLayout layout, TreeExtractorMapping recipe, IIngredients ingredients) {
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List outputs = ingredients.getOutputs(VanillaTypes.FLUID);
        IGuiItemStackGroup guiItemStacks = layout.getItemStacks();
        IGuiFluidStackGroup guiFluidStacks = layout.getFluidStacks();
        guiFluidStacks.init(0, false, 116, 11, 16, 40, TCoreJeiPlugin.tankSize(8000), false, TCoreJeiPlugin.tankOverlay((IDrawable)this.tankOverlay));
        guiItemStacks.init(0, true, 34, 40);
        guiItemStacks.init(1, true, 34, 22);
        guiItemStacks.init(2, true, 16, 13);
        guiItemStacks.init(3, true, 34, 4);
        guiItemStacks.init(4, true, 52, 13);
        guiItemStacks.set(0, (List)inputs.get(0));
        guiItemStacks.set(1, (List)inputs.get(0));
        guiItemStacks.set(2, (List)inputs.get(1));
        guiItemStacks.set(3, (List)inputs.get(1));
        guiItemStacks.set(4, (List)inputs.get(1));
        guiFluidStacks.set(0, (List)outputs.get(0));
        TCoreJeiPlugin.addDefaultFluidTooltipCallback(guiFluidStacks);
    }

    public void draw(TreeExtractorMapping recipe, PoseStack matrixStack, double mouseX, double mouseY) {
        this.tankBackground.draw(matrixStack, 115, 10);
        RenderHelper.drawFluid((PoseStack)matrixStack, (int)78, (int)23, (FluidStack)recipe.getFluid(), (int)24, (int)16);
        this.progressFluidBackground.draw(matrixStack, 78, 23);
        this.progressFluid.draw(matrixStack, 78, 23);
    }
}

