/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.compat.jei.device;

import cofh.core.util.helpers.RenderHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermal.core.client.gui.device.DeviceRockGenScreen;
import cofh.thermal.core.init.TCoreReferences;
import cofh.thermal.core.util.recipes.device.RockGenMapping;
import cofh.thermal.lib.compat.jei.Drawables;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;

public class RockGenCategory
implements IRecipeCategory<RockGenMapping> {
    protected static final FluidStack LAVA_FLUID = new FluidStack((Fluid)Fluids.f_76195_, 1000);
    protected final ResourceLocation uid;
    protected IDrawable background;
    protected IDrawable icon;
    protected Component name;
    protected IDrawableStatic slot;
    protected IDrawableStatic progressFluidBackground;
    protected IDrawableAnimated progressFluid;

    public RockGenCategory(IGuiHelper guiHelper, ItemStack icon, ResourceLocation uid) {
        this.uid = uid;
        this.icon = guiHelper.createDrawableIngredient((Object)icon);
        this.background = guiHelper.drawableBuilder(DeviceRockGenScreen.TEXTURE, 26, 11, 140, 62).addPadding(0, 0, 16, 8).build();
        this.name = StringHelper.getTextComponent((String)TCoreReferences.DEVICE_ROCK_GEN_BLOCK.m_7705_());
        this.slot = Drawables.getDrawables(guiHelper).getSlot(0);
        this.progressFluidBackground = Drawables.getDrawables(guiHelper).getProgressFill(1);
        this.progressFluid = guiHelper.createAnimatedDrawable(Drawables.getDrawables(guiHelper).getProgress(1), 40, IDrawableAnimated.StartDirection.LEFT, true);
    }

    public ResourceLocation getUid() {
        return this.uid;
    }

    public Class<? extends RockGenMapping> getRecipeClass() {
        return RockGenMapping.class;
    }

    public Component getTitle() {
        return this.name;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(RockGenMapping recipe, IIngredients ingredients) {
        FlowingFluid fluid;
        ArrayList<FluidStack> inputFluids = new ArrayList<FluidStack>();
        ArrayList<ItemStack> inputItems = new ArrayList<ItemStack>();
        inputFluids.add(LAVA_FLUID);
        Block adjacent = recipe.getAdjacent();
        Block below = recipe.getBelow();
        if (adjacent instanceof LiquidBlock) {
            fluid = ((LiquidBlock)adjacent).getFluid();
            inputFluids.add(new FluidStack((Fluid)fluid, 1000));
        } else if (adjacent != Blocks.f_50016_) {
            inputItems.add(new ItemStack((ItemLike)adjacent));
        }
        if (below instanceof LiquidBlock) {
            fluid = ((LiquidBlock)below).getFluid();
            inputFluids.add(new FluidStack((Fluid)fluid, 1000));
        } else if (below != Blocks.f_50016_) {
            inputItems.add(new ItemStack((ItemLike)below));
        }
        ingredients.setInputs(VanillaTypes.FLUID, inputFluids);
        ingredients.setInputs(VanillaTypes.ITEM, inputItems);
        ingredients.setOutputs(VanillaTypes.ITEM, Collections.singletonList(recipe.getResult()));
    }

    public void setRecipe(IRecipeLayout layout, RockGenMapping recipe, IIngredients ingredients) {
        int itemCount = 1;
        int fluidCount = 1;
        List inputFluids = ingredients.getInputs(VanillaTypes.FLUID);
        List inputItems = ingredients.getInputs(VanillaTypes.ITEM);
        List outputs = ingredients.getOutputs(VanillaTypes.ITEM);
        IGuiItemStackGroup guiItemStacks = layout.getItemStacks();
        IGuiFluidStackGroup guiFluidStacks = layout.getFluidStacks();
        Block adjacent = recipe.getAdjacent();
        Block below = recipe.getBelow();
        guiItemStacks.init(0, false, 114, 23);
        guiFluidStacks.init(0, true, 23, 13, 16, 16, 1000, false, null);
        guiItemStacks.set(0, (List)outputs.get(0));
        guiFluidStacks.set(0, (List)inputFluids.get(0));
        if (adjacent instanceof LiquidBlock) {
            guiFluidStacks.init(fluidCount, true, 45, 13, 16, 16, 1000, false, null);
            guiFluidStacks.set(fluidCount, (List)inputFluids.get(fluidCount));
            ++fluidCount;
        } else if (adjacent != Blocks.f_50016_) {
            guiItemStacks.init(itemCount, true, 44, 12);
            guiItemStacks.set(itemCount, (List)inputItems.get(itemCount - 1));
            ++itemCount;
        }
        if (below instanceof LiquidBlock) {
            guiFluidStacks.init(fluidCount, true, 33, 33, 16, 16, 1000, false, null);
            guiFluidStacks.set(fluidCount, (List)inputFluids.get(fluidCount));
        } else if (below != Blocks.f_50016_) {
            guiItemStacks.init(itemCount, true, 33, 33);
            guiItemStacks.set(itemCount, (List)inputItems.get(itemCount - 1));
        }
    }

    public void draw(RockGenMapping recipe, PoseStack matrixStack, double mouseX, double mouseY) {
        if (recipe.getBelow() != Blocks.f_50016_) {
            this.slot.draw(matrixStack, 33, 33);
        }
        RenderHelper.drawFluid((PoseStack)matrixStack, (int)74, (int)23, (FluidStack)LAVA_FLUID, (int)24, (int)16);
        this.progressFluidBackground.draw(matrixStack, 74, 23);
        this.progressFluid.draw(matrixStack, 74, 23);
    }
}

