/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.block.entity.storage;

import cofh.core.block.entity.TileCoFH;
import cofh.core.client.renderer.model.ModelUtils;
import cofh.core.network.packet.client.TileStatePacket;
import cofh.lib.block.entity.ICoFHTickableTile;
import cofh.lib.energy.EnergyHandlerRestrictionWrapper;
import cofh.lib.energy.EnergyStorageAdjustable;
import cofh.lib.util.Utils;
import cofh.lib.util.control.IReconfigurable;
import cofh.lib.util.helpers.AugmentDataHelper;
import cofh.lib.util.helpers.BlockHelper;
import cofh.thermal.core.config.ThermalCoreConfig;
import cofh.thermal.core.init.TCoreReferences;
import cofh.thermal.core.inventory.container.storage.EnergyCellContainer;
import cofh.thermal.lib.common.ThermalAugmentRules;
import cofh.thermal.lib.tileentity.CellTileBase;
import cofh.thermal.lib.util.ThermalEnergyHelper;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyCellTile
extends CellTileBase
implements ICoFHTickableTile.IServerTickable {
    public static final int BASE_CAPACITY = 1000000;
    public static final int BASE_RECV = 1000;
    public static final int BASE_SEND = 1000;
    protected LazyOptional<?> inputEnergyCap = LazyOptional.empty();
    protected LazyOptional<?> outputEnergyCap = LazyOptional.empty();

    public EnergyCellTile(BlockPos pos, BlockState state) {
        super(TCoreReferences.ENERGY_CELL_TILE, pos, state);
        this.energyStorage = new EnergyStorageAdjustable(1000000, 1000, 1000).setTransferLimits(() -> this.amountInput, () -> this.amountOutput);
        this.amountInput = this.energyStorage.getMaxReceive();
        this.amountOutput = this.energyStorage.getMaxExtract();
        this.transferControl.initControl(false, true);
        this.addAugmentSlots(ThermalCoreConfig.storageAugments);
        this.initHandlers();
    }

    public void tickServer() {
        if (this.redstoneControl.getState()) {
            this.transferOut();
            this.transferIn();
        }
        if (Utils.timeCheck((Level)this.f_58857_)) {
            this.updateTrackers(true);
        }
    }

    public int getLightValue() {
        return Math.min(this.levelTracker, 8);
    }

    protected void transferIn() {
        int i;
        if (!this.transferControl.getTransferIn()) {
            return;
        }
        if (this.amountInput <= 0 || this.energyStorage.isFull()) {
            return;
        }
        for (i = this.inputTracker; i < 6 && this.energyStorage.getSpace() > 0; ++i) {
            if (!this.reconfigControl.getSideConfig(i).isInput()) continue;
            this.attemptTransferIn(Direction.m_122376_((int)i));
        }
        for (i = 0; i < this.inputTracker && this.energyStorage.getSpace() > 0; ++i) {
            if (!this.reconfigControl.getSideConfig(i).isInput()) continue;
            this.attemptTransferIn(Direction.m_122376_((int)i));
        }
        ++this.inputTracker;
        this.inputTracker %= 6;
    }

    protected void transferOut() {
        int i;
        if (!this.transferControl.getTransferOut()) {
            return;
        }
        if (this.amountOutput <= 0 || this.energyStorage.isEmpty()) {
            return;
        }
        for (i = this.outputTracker; i < 6 && this.energyStorage.getEnergyStored() > 0; ++i) {
            if (!this.reconfigControl.getSideConfig(i).isOutput()) continue;
            this.attemptTransferOut(Direction.m_122376_((int)i));
        }
        for (i = 0; i < this.outputTracker && this.energyStorage.getEnergyStored() > 0; ++i) {
            if (!this.reconfigControl.getSideConfig(i).isOutput()) continue;
            this.attemptTransferOut(Direction.m_122376_((int)i));
        }
        ++this.outputTracker;
        this.outputTracker %= 6;
    }

    protected void attemptTransferIn(Direction side) {
        BlockEntity adjTile = BlockHelper.getAdjacentTileEntity((BlockEntity)this, (Direction)side);
        if (adjTile != null) {
            Direction opposite = side.m_122424_();
            int maxTransfer = Math.min(this.amountInput, this.energyStorage.getSpace());
            adjTile.getCapability(ThermalEnergyHelper.getBaseEnergySystem(), opposite).ifPresent(e -> {
                if (e.canExtract()) {
                    this.energyStorage.modify(e.extractEnergy(maxTransfer, false));
                }
            });
        }
    }

    protected void attemptTransferOut(Direction side) {
        BlockEntity adjTile = BlockHelper.getAdjacentTileEntity((BlockEntity)this, (Direction)side);
        if (adjTile != null) {
            Direction opposite = side.m_122424_();
            int maxTransfer = Math.min(this.amountOutput, this.energyStorage.getEnergyStored());
            adjTile.getCapability(ThermalEnergyHelper.getBaseEnergySystem(), opposite).ifPresent(e -> this.energyStorage.modify(-e.receiveEnergy(maxTransfer, false)));
        }
    }

    @Override
    protected boolean keepEnergy() {
        return true;
    }

    @Override
    public int getMaxInput() {
        return this.energyStorage.getMaxReceive();
    }

    @Override
    public int getMaxOutput() {
        return this.energyStorage.getMaxExtract();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new EnergyCellContainer(i, this.f_58857_, this.f_58858_, inventory, player);
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(ModelUtils.SIDES, (Object)this.reconfigControl().getRawSideConfig()).withInitial(ModelUtils.FACING, (Object)this.reconfigControl.getFacing()).withInitial(ModelUtils.LEVEL, (Object)this.levelTracker).build();
    }

    @Override
    protected void updateTrackers(boolean send) {
        int curScale;
        this.prevLight = this.getLightValue();
        int n = curScale = this.energyStorage.getEnergyStored() > 0 ? 1 + (int)(this.energyStorage.getRatio() * 14.0) : 0;
        if (curScale != this.compareTracker) {
            this.compareTracker = curScale;
            if (send) {
                this.m_6596_();
            }
        }
        if (this.energyStorage.isCreative()) {
            curScale = 9;
        } else {
            int n2 = curScale = this.energyStorage.getEnergyStored() > 0 ? 1 + Math.min((int)(this.energyStorage.getRatio() * 8.0), 7) : 0;
        }
        if (this.levelTracker != curScale) {
            this.levelTracker = curScale;
            if (send) {
                TileStatePacket.sendToClient((TileCoFH)this);
            }
        }
    }

    @Override
    protected Predicate<ItemStack> augValidator() {
        return item -> AugmentDataHelper.hasAugmentData((ItemStack)item) && ThermalAugmentRules.ENERGY_STORAGE_VALIDATOR.test((ItemStack)item, this.getAugmentsAsList());
    }

    @Override
    protected void updateHandlers() {
        LazyOptional prevEnergyCap = this.energyCap;
        LazyOptional<?> prevEnergyInputCap = this.inputEnergyCap;
        LazyOptional<?> prevEnergyOutputCap = this.outputEnergyCap;
        EnergyHandlerRestrictionWrapper inputHandler = new EnergyHandlerRestrictionWrapper((IEnergyStorage)this.energyStorage, true, false);
        EnergyHandlerRestrictionWrapper outputHandler = new EnergyHandlerRestrictionWrapper((IEnergyStorage)this.energyStorage, false, true);
        this.energyCap = LazyOptional.of(() -> this.energyStorage);
        this.inputEnergyCap = LazyOptional.of(() -> EnergyCellTile.lambda$updateHandlers$6((IEnergyStorage)inputHandler));
        this.outputEnergyCap = LazyOptional.of(() -> EnergyCellTile.lambda$updateHandlers$7((IEnergyStorage)outputHandler));
        prevEnergyCap.invalidate();
        prevEnergyInputCap.invalidate();
        prevEnergyOutputCap.invalidate();
    }

    @Override
    protected <T> LazyOptional<T> getEnergyCapability(@Nullable Direction side) {
        if (side == null) {
            return super.getEnergyCapability(side);
        }
        return switch (this.reconfigControl.getSideConfig(side)) {
            case IReconfigurable.SideConfig.SIDE_NONE -> LazyOptional.empty();
            case IReconfigurable.SideConfig.SIDE_INPUT -> this.inputEnergyCap.cast();
            case IReconfigurable.SideConfig.SIDE_OUTPUT -> this.outputEnergyCap.cast();
            default -> super.getEnergyCapability(side);
        };
    }

    private static /* synthetic */ IEnergyStorage lambda$updateHandlers$7(IEnergyStorage outputHandler) {
        return outputHandler;
    }

    private static /* synthetic */ IEnergyStorage lambda$updateHandlers$6(IEnergyStorage inputHandler) {
        return inputHandler;
    }
}

