/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.block.entity.device;

import cofh.core.block.entity.TileCoFH;
import cofh.core.client.renderer.model.ModelUtils;
import cofh.core.network.packet.client.TileStatePacket;
import cofh.lib.block.entity.ICoFHTickableTile;
import cofh.lib.fluid.FluidStorageCoFH;
import cofh.lib.inventory.ItemStorageCoFH;
import cofh.lib.util.StorageGroup;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.AugmentDataHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.thermal.core.config.ThermalCoreConfig;
import cofh.thermal.core.init.TCoreReferences;
import cofh.thermal.core.inventory.container.device.DeviceTreeExtractorContainer;
import cofh.thermal.core.util.managers.device.TreeExtractorManager;
import cofh.thermal.lib.common.ThermalAugmentRules;
import cofh.thermal.lib.tileentity.DeviceTileBase;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class DeviceTreeExtractorTile
extends DeviceTileBase
implements ICoFHTickableTile.IServerTickable {
    public static final BiPredicate<ItemStack, List<ItemStack>> AUG_VALIDATOR = ThermalAugmentRules.createAllowValidator("Upgrade", "Fluid", "Filter");
    protected static final int NUM_LEAVES = 3;
    protected static int timeConstant = 500;
    protected ItemStorageCoFH inputSlot = new ItemStorageCoFH(item -> this.filter.valid(item) && TreeExtractorManager.instance().validBoost((ItemStack)item));
    protected FluidStorageCoFH outputTank = new FluidStorageCoFH(8000);
    protected boolean cached;
    protected boolean valid;
    protected BlockPos trunkPos;
    protected final BlockPos[] leafPos = new BlockPos[3];
    protected int process = timeConstant / 2;
    protected int boostCycles;
    protected int boostMax = TreeExtractorManager.instance().getDefaultEnergy();
    protected float boostMult;

    public static void setTimeConstant(int configConstant) {
        timeConstant = configConstant;
    }

    public DeviceTreeExtractorTile(BlockPos pos, BlockState state) {
        super(TCoreReferences.DEVICE_TREE_EXTRACTOR_TILE, pos, state);
        this.inventory.addSlot(this.inputSlot, StorageGroup.INPUT);
        this.tankInv.addTank(this.outputTank, StorageGroup.OUTPUT);
        this.addAugmentSlots(ThermalCoreConfig.deviceAugments);
        this.initHandlers();
        this.trunkPos = new BlockPos((Vec3i)this.f_58858_);
        for (int i = 0; i < 3; ++i) {
            this.leafPos[i] = new BlockPos((Vec3i)this.f_58858_);
        }
    }

    @Override
    protected void updateValidity() {
        int leafCount;
        Set<BlockState> leafSet;
        if (this.f_58857_ == null || !this.f_58857_.isAreaLoaded(this.f_58858_, 1) || Utils.isClientWorld((Level)this.f_58857_)) {
            return;
        }
        if (this.valid) {
            if (this.isTrunkBase(this.trunkPos)) {
                leafSet = TreeExtractorManager.instance().getMatchingLeaves(this.f_58857_.m_8055_(this.trunkPos));
                leafCount = 0;
                for (int i = 0; i < 3; ++i) {
                    if (!leafSet.contains(this.f_58857_.m_8055_(this.leafPos[i]))) continue;
                    ++leafCount;
                }
                if (leafCount >= 3) {
                    Iterable area = BlockPos.m_121940_((BlockPos)this.trunkPos, (BlockPos)this.trunkPos.m_142082_(0, this.leafPos[0].m_123342_() - this.trunkPos.m_123342_(), 0));
                    for (BlockPos scan : area) {
                        Material material = this.f_58857_.m_8055_(scan).m_60767_();
                        if (material != Material.f_76315_ && material != Material.f_76314_ && material != Material.f_76278_) continue;
                        this.valid = false;
                        this.cached = true;
                        return;
                    }
                    area = BlockPos.m_121940_((BlockPos)this.f_58858_.m_142082_(0, 1, 0), (BlockPos)this.f_58858_.m_142082_(0, this.leafPos[0].m_123342_() - this.f_58858_.m_123342_(), 0));
                    for (BlockPos scan : area) {
                        if (!this.isTreeExtractor(this.f_58857_.m_8055_(scan))) continue;
                        this.valid = false;
                        this.cached = true;
                        return;
                    }
                    this.cached = true;
                    this.renderFluid = TreeExtractorManager.instance().getFluid(this.f_58857_.m_8055_(this.trunkPos));
                    return;
                }
            }
            this.valid = false;
        }
        if (this.isTrunkBase(this.f_58858_.m_142125_())) {
            this.trunkPos = this.f_58858_.m_142125_();
        } else if (this.isTrunkBase(this.f_58858_.m_142126_())) {
            this.trunkPos = this.f_58858_.m_142126_();
        } else if (this.isTrunkBase(this.f_58858_.m_142127_())) {
            this.trunkPos = this.f_58858_.m_142127_();
        } else if (this.isTrunkBase(this.f_58858_.m_142128_())) {
            this.trunkPos = this.f_58858_.m_142128_();
        }
        if (!this.isTrunkBase(this.trunkPos)) {
            this.valid = false;
            this.cached = true;
            return;
        }
        leafSet = TreeExtractorManager.instance().getMatchingLeaves(this.f_58857_.m_8055_(this.trunkPos));
        leafCount = 0;
        Iterable area = BlockPos.m_121990_((BlockPos)this.f_58858_.m_142082_(-1, 0, -1), (BlockPos)this.f_58858_.m_142082_(1, Math.min(256 - this.f_58858_.m_123342_(), 40), 1)).map(BlockPos::m_7949_).collect(Collectors.toList());
        for (BlockPos scan : area) {
            if (!leafSet.contains(this.f_58857_.m_8055_(scan))) continue;
            this.leafPos[leafCount] = new BlockPos((Vec3i)scan);
            if (++leafCount < 3) continue;
            break;
        }
        if (leafCount >= 3) {
            area = BlockPos.m_121940_((BlockPos)this.trunkPos, (BlockPos)this.trunkPos.m_142082_(0, this.leafPos[0].m_123342_() - this.trunkPos.m_123342_(), 0));
            for (BlockPos scan : area) {
                Material material = this.f_58857_.m_8055_(scan).m_60767_();
                if (material != Material.f_76315_ && material != Material.f_76314_ && material != Material.f_76278_) continue;
                this.valid = false;
                this.cached = true;
                return;
            }
            area = BlockPos.m_121940_((BlockPos)this.f_58858_.m_142082_(0, 1, 0), (BlockPos)this.f_58858_.m_142082_(0, this.leafPos[0].m_123342_() - this.f_58858_.m_123342_(), 0));
            for (BlockPos scan : area) {
                if (!this.isTreeExtractor(this.f_58857_.m_8055_(scan))) continue;
                this.valid = false;
                this.cached = true;
                return;
            }
            this.valid = true;
            this.renderFluid = TreeExtractorManager.instance().getFluid(this.f_58857_.m_8055_(this.trunkPos));
        }
        this.cached = true;
    }

    @Override
    protected void updateActiveState() {
        if (!this.cached) {
            this.updateValidity();
        }
        super.updateActiveState();
    }

    @Override
    protected boolean isValid() {
        return this.valid;
    }

    public void tickServer() {
        this.updateActiveState();
        --this.process;
        if (this.process > 0) {
            return;
        }
        this.updateValidity();
        this.process = this.getTimeConstant();
        if (!this.isActive) {
            return;
        }
        Fluid curFluid = this.renderFluid.getFluid();
        if (this.valid) {
            if (this.boostCycles > 0) {
                --this.boostCycles;
            } else if (!this.inputSlot.isEmpty()) {
                this.boostMax = this.boostCycles = TreeExtractorManager.instance().getBoostCycles(this.inputSlot.getItemStack());
                this.boostMult = TreeExtractorManager.instance().getBoostOutputMod(this.inputSlot.getItemStack());
                this.inputSlot.consume(1);
            } else {
                this.boostCycles = 0;
                this.boostMult = 1.0f;
            }
            this.outputTank.fill(new FluidStack(this.renderFluid, (int)((float)this.renderFluid.getAmount() * this.baseMod * this.boostMult)), IFluidHandler.FluidAction.EXECUTE);
        }
        if (curFluid != this.renderFluid.getFluid()) {
            TileStatePacket.sendToClient((TileCoFH)this);
        }
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(ModelUtils.FLUID, (Object)this.renderFluid).build();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new DeviceTreeExtractorContainer(i, this.f_58857_, this.f_58858_, inventory, player);
    }

    @Override
    public int getScaledDuration(int scale) {
        return !this.isActive || this.boostCycles <= 0 || this.boostMax <= 0 ? 0 : scale * this.boostCycles / this.boostMax;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        ModelDataManager.requestModelDataRefresh((BlockEntity)this);
    }

    @Override
    public void handleControlPacket(FriendlyByteBuf buffer) {
        super.handleControlPacket(buffer);
        ModelDataManager.requestModelDataRefresh((BlockEntity)this);
    }

    @Override
    public FriendlyByteBuf getGuiPacket(FriendlyByteBuf buffer) {
        super.getGuiPacket(buffer);
        buffer.writeInt(this.boostCycles);
        buffer.writeInt(this.boostMax);
        buffer.writeFloat(this.boostMult);
        return buffer;
    }

    @Override
    public void handleGuiPacket(FriendlyByteBuf buffer) {
        super.handleGuiPacket(buffer);
        this.boostCycles = buffer.readInt();
        this.boostMax = buffer.readInt();
        this.boostMult = buffer.readFloat();
    }

    @Override
    public FriendlyByteBuf getStatePacket(FriendlyByteBuf buffer) {
        super.getStatePacket(buffer);
        buffer.writeInt(this.process);
        return buffer;
    }

    @Override
    public void handleStatePacket(FriendlyByteBuf buffer) {
        super.handleStatePacket(buffer);
        this.process = buffer.readInt();
        ModelDataManager.requestModelDataRefresh((BlockEntity)this);
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.boostCycles = nbt.m_128451_("BoostCycles");
        this.boostMax = nbt.m_128451_("BoostMax");
        this.boostMult = nbt.m_128457_("BoostMult");
        this.process = nbt.m_128451_("Proc");
        for (int i = 0; i < 3; ++i) {
            this.leafPos[i] = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("Leaf" + i));
        }
        this.trunkPos = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("Trunk"));
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("BoostCycles", this.boostCycles);
        nbt.m_128405_("BoostMax", this.boostMax);
        nbt.m_128350_("BoostMult", this.boostMult);
        nbt.m_128405_("Proc", this.process);
        for (int i = 0; i < 3; ++i) {
            nbt.m_128365_("Leaf" + i, (Tag)NbtUtils.m_129224_((BlockPos)this.leafPos[i]));
        }
        nbt.m_128365_("Trunk", (Tag)NbtUtils.m_129224_((BlockPos)this.trunkPos));
    }

    protected int getTimeConstant() {
        if (this.f_58857_ == null) {
            return timeConstant;
        }
        int constant = timeConstant / 2;
        Iterable area = BlockPos.m_121940_((BlockPos)this.trunkPos.m_142082_(-1, 0, -1), (BlockPos)this.trunkPos.m_142082_(1, 0, 1));
        for (BlockPos scan : area) {
            if (!this.isTreeExtractor(this.f_58857_.m_8055_(scan))) continue;
            constant += timeConstant / 2;
        }
        return MathHelper.clamp((int)constant, (int)timeConstant, (int)(timeConstant * 2));
    }

    protected boolean isTrunkBase(BlockPos checkPos) {
        BlockState state = this.f_58857_.m_8055_(checkPos.m_7495_());
        Material material = state.m_60767_();
        if (material != Material.f_76315_ && material != Material.f_76314_ && material != Material.f_76278_) {
            return false;
        }
        return TreeExtractorManager.instance().validTrunk(this.f_58857_.m_8055_(checkPos)) && TreeExtractorManager.instance().validTrunk(this.f_58857_.m_8055_(checkPos.m_7494_())) && TreeExtractorManager.instance().validTrunk(this.f_58857_.m_8055_(checkPos.m_6630_(2)));
    }

    protected boolean isTreeExtractor(BlockState state) {
        return state.m_60734_() == this.m_58900_().m_60734_();
    }

    @Override
    protected Predicate<ItemStack> augValidator() {
        return item -> AugmentDataHelper.hasAugmentData((ItemStack)item) && AUG_VALIDATOR.test((ItemStack)item, this.getAugmentsAsList());
    }
}

