/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.decorative_blocks.datagen;

import com.google.common.collect.Maps;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LimitCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.BinomialDistributionGenerator;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public abstract class BlockLootTableAccessor
implements Consumer<BiConsumer<ResourceLocation, LootTable.Builder>> {
    public static final LootItemCondition.Builder HAS_SILK_TOUCH = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))));
    public static final LootItemCondition.Builder HAS_NO_SILK_TOUCH = HAS_SILK_TOUCH.m_81807_();
    public static final LootItemCondition.Builder HAS_SHEARS = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{Items.f_42574_}));
    public static final LootItemCondition.Builder HAS_SHEARS_OR_SILK_TOUCH = HAS_SHEARS.m_7818_(HAS_SILK_TOUCH);
    public static final LootItemCondition.Builder HAS_NO_SHEARS_OR_SILK_TOUCH = HAS_SHEARS_OR_SILK_TOUCH.m_81807_();
    public static final Set<Item> EXPLOSION_RESISTANT = new HashSet<Item>();
    public final Map<ResourceLocation, LootTable.Builder> map = Maps.newHashMap();

    public static <T> T applyExplosionDecay(ItemLike itemLike, FunctionUserBuilder<T> builder) {
        return (T)(!EXPLOSION_RESISTANT.contains(itemLike.m_5456_()) ? builder.m_5577_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_()) : builder.m_5476_());
    }

    public static <T> T applyExplosionCondition(ItemLike itemLike, ConditionUserBuilder<T> builder) {
        return (T)(!EXPLOSION_RESISTANT.contains(itemLike.m_5456_()) ? builder.m_6509_(ExplosionCondition.m_81661_()) : builder.m_5476_());
    }

    public static LootTable.Builder createSingleItemTable(ItemLike itemLike) {
        return LootTable.m_79147_().m_79161_((LootPool.Builder)BlockLootTableAccessor.applyExplosionCondition(itemLike, LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)itemLike))));
    }

    public static LootTable.Builder createSelfDropDispatchTable(Block block, LootItemCondition.Builder condition, LootPoolEntryContainer.Builder<?> otherwise) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)block).m_6509_(condition)).m_7170_(otherwise)));
    }

    public static LootTable.Builder createSilkTouchDispatchTable(Block block, LootPoolEntryContainer.Builder<?> onSilkTouch) {
        return BlockLootTableAccessor.createSelfDropDispatchTable(block, HAS_SILK_TOUCH, onSilkTouch);
    }

    public static LootTable.Builder createShearsDispatchTable(Block block, LootPoolEntryContainer.Builder<?> onShear) {
        return BlockLootTableAccessor.createSelfDropDispatchTable(block, HAS_SHEARS, onShear);
    }

    public static LootTable.Builder createSilkTouchOrShearsDispatchTable(Block block, LootPoolEntryContainer.Builder<?> drop) {
        return BlockLootTableAccessor.createSelfDropDispatchTable(block, HAS_SHEARS_OR_SILK_TOUCH, drop);
    }

    public static LootTable.Builder createSingleItemTableWithSilkTouch(Block block, ItemLike $$1) {
        return BlockLootTableAccessor.createSilkTouchDispatchTable(block, (LootPoolEntryContainer.Builder)BlockLootTableAccessor.applyExplosionCondition((ItemLike)block, LootItem.m_79579_((ItemLike)$$1)));
    }

    public static LootTable.Builder createSingleItemTable(ItemLike $$0, NumberProvider $$1) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)BlockLootTableAccessor.applyExplosionDecay($$0, LootItem.m_79579_((ItemLike)$$0).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)$$1)))));
    }

    public static LootTable.Builder createSingleItemTableWithSilkTouch(Block $$0, ItemLike $$1, NumberProvider $$2) {
        return BlockLootTableAccessor.createSilkTouchDispatchTable($$0, (LootPoolEntryContainer.Builder)BlockLootTableAccessor.applyExplosionDecay((ItemLike)$$0, LootItem.m_79579_((ItemLike)$$1).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)$$2))));
    }

    public static LootTable.Builder createSilkTouchOnlyTable(ItemLike drop) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_6509_(HAS_SILK_TOUCH).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)drop)));
    }

    public static LootTable.Builder createShearsOnlyDrop(ItemLike onSheared) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(HAS_SHEARS).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)onSheared)));
    }

    public static LootTable.Builder createSlabItemTable(Block slab) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)BlockLootTableAccessor.applyExplosionDecay((ItemLike)slab, LootItem.m_79579_((ItemLike)slab).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)slab).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE)))))));
    }

    public static <T extends Comparable<T> & StringRepresentable> LootTable.Builder createSinglePropConditionTable(Block block, Property<T> $$1, T $$2) {
        return LootTable.m_79147_().m_79161_((LootPool.Builder)BlockLootTableAccessor.applyExplosionCondition((ItemLike)block, LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)block).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_($$1, $$2))))));
    }

    public static LootTable.Builder createNameableBlockEntityTable(Block $$0) {
        return LootTable.m_79147_().m_79161_((LootPool.Builder)BlockLootTableAccessor.applyExplosionCondition((ItemLike)$$0, LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)$$0).m_5577_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)))));
    }

    public static LootTable.Builder createOreDrop(Block block, Item oreItem) {
        return BlockLootTableAccessor.createSilkTouchDispatchTable(block, (LootPoolEntryContainer.Builder)BlockLootTableAccessor.applyExplosionDecay((ItemLike)block, LootItem.m_79579_((ItemLike)oreItem).m_5577_((LootItemFunction.Builder)ApplyBonusCount.m_79915_((Enchantment)Enchantments.f_44987_))));
    }

    public static LootTable.Builder createMushroomBlockDrop(Block $$0, ItemLike $$1) {
        return BlockLootTableAccessor.createSilkTouchDispatchTable($$0, (LootPoolEntryContainer.Builder)BlockLootTableAccessor.applyExplosionDecay((ItemLike)$$0, LootItem.m_79579_((ItemLike)$$1).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)-6.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LimitCount.m_165215_((IntRange)IntRange.m_165026_((int)0)))));
    }

    public static LootTable.Builder createGrassDrops(Block $$0) {
        return BlockLootTableAccessor.createShearsDispatchTable($$0, (LootPoolEntryContainer.Builder)BlockLootTableAccessor.applyExplosionDecay((ItemLike)$$0, ((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42404_).m_6509_(LootItemRandomChanceCondition.m_81927_((float)0.125f))).m_5577_((LootItemFunction.Builder)ApplyBonusCount.m_79921_((Enchantment)Enchantments.f_44987_, (int)2))));
    }

    public static LootTable.Builder createStemDrops(Block $$0, Item $$1) {
        return LootTable.m_79147_().m_79161_((LootPool.Builder)BlockLootTableAccessor.applyExplosionDecay((ItemLike)$$0, LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)$$1).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)BinomialDistributionGenerator.m_165659_((int)3, (float)0.06666667f)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)$$0).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)StemBlock.f_57013_, 0)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)BinomialDistributionGenerator.m_165659_((int)3, (float)0.13333334f)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)$$0).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)StemBlock.f_57013_, 1)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)BinomialDistributionGenerator.m_165659_((int)3, (float)0.2f)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)$$0).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)StemBlock.f_57013_, 2)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)BinomialDistributionGenerator.m_165659_((int)3, (float)0.26666668f)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)$$0).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)StemBlock.f_57013_, 3)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)BinomialDistributionGenerator.m_165659_((int)3, (float)0.33333334f)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)$$0).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)StemBlock.f_57013_, 4)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)BinomialDistributionGenerator.m_165659_((int)3, (float)0.4f)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)$$0).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)StemBlock.f_57013_, 5)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)BinomialDistributionGenerator.m_165659_((int)3, (float)0.46666667f)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)$$0).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)StemBlock.f_57013_, 6)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)BinomialDistributionGenerator.m_165659_((int)3, (float)0.53333336f)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)$$0).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)StemBlock.f_57013_, 7)))))));
    }

    public static LootTable.Builder createAttachedStemDrops(Block $$0, Item $$1) {
        return LootTable.m_79147_().m_79161_((LootPool.Builder)BlockLootTableAccessor.applyExplosionDecay((ItemLike)$$0, LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)$$1).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)BinomialDistributionGenerator.m_165659_((int)3, (float)0.53333336f))))));
    }

    public static LootTable.Builder createGlowLichenDrops(Block $$0) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)BlockLootTableAccessor.applyExplosionDecay((ItemLike)$$0, ((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)$$0).m_6509_(HAS_SHEARS)).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165414_((NumberProvider)ConstantValue.m_165692_((float)1.0f), (boolean)true).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)$$0).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67703_((Property)PipeBlock.f_55149_, true)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165414_((NumberProvider)ConstantValue.m_165692_((float)1.0f), (boolean)true).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)$$0).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67703_((Property)PipeBlock.f_55151_, true)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165414_((NumberProvider)ConstantValue.m_165692_((float)1.0f), (boolean)true).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)$$0).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67703_((Property)PipeBlock.f_55148_, true)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165414_((NumberProvider)ConstantValue.m_165692_((float)1.0f), (boolean)true).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)$$0).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67703_((Property)PipeBlock.f_55150_, true)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165414_((NumberProvider)ConstantValue.m_165692_((float)1.0f), (boolean)true).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)$$0).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67703_((Property)PipeBlock.f_55152_, true)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165414_((NumberProvider)ConstantValue.m_165692_((float)1.0f), (boolean)true).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)$$0).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67703_((Property)PipeBlock.f_55153_, true)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165414_((NumberProvider)ConstantValue.m_165692_((float)-1.0f), (boolean)true)))));
    }

    public static LootTable.Builder createLeavesDrops(Block $$0, Block $$1, float ... $$2) {
        return BlockLootTableAccessor.createSilkTouchOrShearsDispatchTable($$0, ((LootPoolSingletonContainer.Builder)BlockLootTableAccessor.applyExplosionCondition((ItemLike)$$0, LootItem.m_79579_((ItemLike)$$1))).m_6509_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])$$2))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(HAS_NO_SHEARS_OR_SILK_TOUCH).m_79076_(((LootPoolSingletonContainer.Builder)BlockLootTableAccessor.applyExplosionDecay((ItemLike)$$0, LootItem.m_79579_((ItemLike)Items.f_42398_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))))).m_6509_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f}))));
    }

    public static LootTable.Builder createDoublePlantShearsDrop(Block $$0) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_6509_(HAS_SHEARS).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)$$0).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f)))));
    }

    public static LootTable.Builder createDoublePlantWithSeedDrops(Block $$0, Block $$1) {
        AlternativesEntry.Builder $$2 = ((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)$$1).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f))).m_6509_(HAS_SHEARS)).m_7170_(((LootPoolSingletonContainer.Builder)BlockLootTableAccessor.applyExplosionCondition((ItemLike)$$0, LootItem.m_79579_((ItemLike)Items.f_42404_))).m_6509_(LootItemRandomChanceCondition.m_81927_((float)0.125f)));
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)$$2).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)$$0).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER))).m_6509_(LocationCheck.m_81727_((LocationPredicate.Builder)LocationPredicate.Builder.m_52651_().m_52652_(BlockPredicate.Builder.m_17924_().m_146726_(new Block[]{$$0}).m_17929_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER).m_67706_()).m_17931_()), (BlockPos)new BlockPos(0, 1, 0)))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)$$2).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)$$0).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER))).m_6509_(LocationCheck.m_81727_((LocationPredicate.Builder)LocationPredicate.Builder.m_52651_().m_52652_(BlockPredicate.Builder.m_17924_().m_146726_(new Block[]{$$0}).m_17929_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER).m_67706_()).m_17931_()), (BlockPos)new BlockPos(0, -1, 0))));
    }

    public static LootTable.Builder createDoorTable(Block door) {
        return BlockLootTableAccessor.createSinglePropConditionTable(door, DoorBlock.f_52730_, DoubleBlockHalf.LOWER);
    }

    public void otherWhenSilkTouch(Block block, Block other) {
        this.add(block, BlockLootTableAccessor.createSilkTouchOnlyTable((ItemLike)other));
    }

    public void dropOther(Block block, ItemLike other) {
        this.add(block, BlockLootTableAccessor.createSingleItemTable(other));
    }

    public void dropWhenSilkTouch(Block block) {
        this.otherWhenSilkTouch(block, block);
    }

    public void dropSelf(Block block) {
        this.dropOther(block, (ItemLike)block);
    }

    public static LootTable.Builder noDrop() {
        return LootTable.m_79147_();
    }

    public void add(Block block, Function<Block, LootTable.Builder> function) {
        this.add(block, function.apply(block));
    }

    public void add(Block block, LootTable.Builder builder) {
        this.map.put(block.m_60589_(), builder);
    }
}

