/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.decorative_blocks;

import lilypuree.decorative_blocks.Config;
import lilypuree.decorative_blocks.Constants;
import lilypuree.decorative_blocks.core.DBItems;
import lilypuree.decorative_blocks.core.DBNames;
import lilypuree.decorative_blocks.core.DBTags;
import lilypuree.decorative_blocks.core.Registration;
import lilypuree.decorative_blocks.core.RegistryHelper;
import lilypuree.decorative_blocks.core.setup.ModSetup;
import lilypuree.decorative_blocks.entity.DummyEntityForSitting;
import lilypuree.decorative_blocks.events.ClientEventHandler;
import lilypuree.decorative_blocks.fluid.ForgeThatchFluid;
import lilypuree.decorative_blocks.fluid.ForgeThatchFluidBlock;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(value="decorative_blocks")
public class DecorativeBlocks {
    public DecorativeBlocks() {
        DBTags.init();
        Constants.ITEM_GROUP = new CreativeModeTab(-1, "decorative_blocks.general"){

            public ItemStack m_6976_() {
                return new ItemStack((ItemLike)DBItems.BRAZIER);
            }
        };
        DummyEntityForSitting.factory = (type, level) -> new DummyEntityForSitting(type, level){

            public Packet<?> m_5654_() {
                return NetworkHooks.getEntitySpawningPacket((Entity)this);
            }
        };
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.COMMON_CONFIG);
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(e -> ModSetup.init());
        modBus.addListener(ClientEventHandler::initRenderLayers);
        modBus.addListener(ClientEventHandler::registerItemFunc);
        modBus.addListener(ClientEventHandler::onEntityRendererRegistry);
        modBus.addGenericListener(Block.class, this::registerBlocks);
        modBus.addGenericListener(Item.class, e -> Registration.registerItems(new RegistryHelperForge<Item>(e.getRegistry())));
        modBus.addGenericListener(Fluid.class, this::registerFluids);
        modBus.addGenericListener(EntityType.class, this::registerEntities);
    }

    public void registerBlocks(RegistryEvent.Register<Block> event) {
        Registration.THATCH = new ForgeThatchFluidBlock(() -> Registration.STILL_THATCH, Registration.thatchProperties);
        Registration.registerBlocks(new RegistryHelperForge<Block>(event.getRegistry()));
    }

    public void registerFluids(RegistryEvent.Register<Fluid> event) {
        Registration.STILL_THATCH = new ForgeThatchFluid.Source(Registration.referenceHolder);
        Registration.FLOWING_THATCH = new ForgeThatchFluid.Flowing(Registration.referenceHolder);
        Registration.registerFluids(new RegistryHelperForge<Fluid>(event.getRegistry()));
    }

    public void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        Registration.DUMMY_ENTITY_TYPE = (EntityType)EntityType.Builder.m_20704_(DummyEntityForSitting.factory, (MobCategory)MobCategory.MISC).m_20702_(256).m_20717_(20).m_20699_(1.0E-4f, 1.0E-4f).m_20712_("decorative_blocks:dummy").setRegistryName(DBNames.DUMMY_ENTITY);
        event.getRegistry().register((IForgeRegistryEntry)Registration.DUMMY_ENTITY_TYPE);
    }

    public static class RegistryHelperForge<T extends IForgeRegistryEntry<T>>
    implements RegistryHelper<T> {
        IForgeRegistry<T> registry;

        public RegistryHelperForge(IForgeRegistry<T> registry) {
            this.registry = registry;
        }

        @Override
        public void register(T entry, ResourceLocation name) {
            this.registry.register((IForgeRegistryEntry)entry.setRegistryName(name));
        }
    }
}

