/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.resource.ore;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.resource.IResource;
import mekanism.common.resource.MiscResource;
import mekanism.common.resource.PrimaryResource;
import mekanism.common.resource.ore.BaseOreConfig;
import mekanism.common.resource.ore.OreAnchor;
import mekanism.common.world.height.HeightShape;
import net.minecraft.util.StringRepresentable;

public enum OreType implements StringRepresentable
{
    TIN((IResource)PrimaryResource.TIN, new BaseOreConfig("small", 14, 0.0f, 4, HeightShape.TRAPEZOID, OreAnchor.absolute(-20), OreAnchor.absolute(94)), new BaseOreConfig("large", 12, 0.0f, 9, HeightShape.TRAPEZOID, OreAnchor.absolute(-32), OreAnchor.absolute(72))),
    OSMIUM((IResource)PrimaryResource.OSMIUM, new BaseOreConfig("upper", 65, 0.0f, 7, HeightShape.TRAPEZOID, OreAnchor.absolute(72), OreAnchor.belowTop(-24), 8), new BaseOreConfig("middle", 6, 0.0f, 9, HeightShape.TRAPEZOID, OreAnchor.absolute(-32), OreAnchor.absolute(56)), new BaseOreConfig("small", 8, 0.0f, 4, HeightShape.UNIFORM, OreAnchor.aboveBottom(0), OreAnchor.absolute(64))),
    URANIUM((IResource)PrimaryResource.URANIUM, new BaseOreConfig("small", 4, 0.0f, 4, HeightShape.TRAPEZOID, OreAnchor.aboveBottom(0), OreAnchor.absolute(8)), new BaseOreConfig("buried", 7, 0.75f, 9, HeightShape.TRAPEZOID, OreAnchor.aboveBottom(-24), OreAnchor.aboveBottom(56), 16)),
    FLUORITE((IResource)MiscResource.FLUORITE, 1, 4, new BaseOreConfig("normal", 5, 0.0f, 5, HeightShape.UNIFORM, OreAnchor.aboveBottom(0), OreAnchor.absolute(23)), new BaseOreConfig("buried", 3, 1.0f, 13, HeightShape.TRAPEZOID, OreAnchor.aboveBottom(0), OreAnchor.absolute(4))),
    LEAD((IResource)PrimaryResource.LEAD, new BaseOreConfig("normal", 8, 0.25f, 9, HeightShape.TRAPEZOID, OreAnchor.aboveBottom(-24), OreAnchor.absolute(64)));

    public static Codec<OreType> CODEC;
    private static final Map<String, OreType> NAME_LOOKUP;
    private final List<BaseOreConfig> baseConfigs;
    private final IResource resource;
    private final int minExp;
    private final int maxExp;

    private OreType(IResource resource, BaseOreConfig ... configs) {
        this(resource, 0, configs);
    }

    private OreType(IResource resource, int exp, BaseOreConfig ... configs) {
        this(resource, exp, exp, configs);
    }

    private OreType(IResource resource, int minExp, int maxExp, BaseOreConfig ... configs) {
        this.resource = resource;
        this.minExp = minExp;
        this.maxExp = maxExp;
        this.baseConfigs = List.of(configs);
    }

    public IResource getResource() {
        return this.resource;
    }

    public List<BaseOreConfig> getBaseConfigs() {
        return this.baseConfigs;
    }

    public int getMinExp() {
        return this.minExp;
    }

    public int getMaxExp() {
        return this.maxExp;
    }

    public static OreType get(IResource resource) {
        for (OreType ore : OreType.values()) {
            if (resource != ore.resource) continue;
            return ore;
        }
        return null;
    }

    @Nonnull
    public String m_7912_() {
        return this.resource.getRegistrySuffix();
    }

    @Nullable
    private static OreType byName(String name) {
        return NAME_LOOKUP.get(name);
    }

    static {
        CODEC = StringRepresentable.m_14350_(OreType::values, OreType::byName);
        NAME_LOOKUP = Arrays.stream(OreType.values()).collect(Collectors.toMap(OreType::m_7912_, oreType -> oreType));
    }

    public record OreVeinType(OreType type, int index) {
        public static final Codec<OreVeinType> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)CODEC.fieldOf("type").forGetter(config -> config.type), (App)Codec.INT.fieldOf("index").forGetter(config -> config.index)).apply((Applicative)builder, OreVeinType::new));

        public OreVeinType {
            if (index < 0 || index >= type.getBaseConfigs().size()) {
                throw new IndexOutOfBoundsException("Vein Type index out of range: " + index);
            }
        }

        public String name() {
            return "ore_" + this.type.getResource().getRegistrySuffix() + "_" + this.type.getBaseConfigs().get(this.index).name();
        }
    }
}

