/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.upgrade;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.MekanismAPI;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.security.IOwnerObject;
import mekanism.api.security.SecurityMode;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.recipe.upgrade.RecipeUpgradeData;
import net.minecraft.world.item.ItemStack;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public class SecurityRecipeData
implements RecipeUpgradeData<SecurityRecipeData> {
    private final UUID owner;
    private final SecurityMode mode;

    SecurityRecipeData(UUID owner, SecurityMode mode) {
        this.owner = owner;
        this.mode = mode;
    }

    @Override
    @Nullable
    public SecurityRecipeData merge(SecurityRecipeData other) {
        if (this.owner.equals(other.owner)) {
            return MekanismAPI.getSecurityUtils().moreRestrictive(this.mode, other.mode) ? other : this;
        }
        return null;
    }

    @Override
    public boolean applyToStack(ItemStack stack) {
        Optional ownerCapability = stack.getCapability(Capabilities.OWNER_OBJECT).resolve();
        if (ownerCapability.isPresent()) {
            IOwnerObject ownerObject = (IOwnerObject)ownerCapability.get();
            ownerObject.setOwnerUUID(this.owner);
            stack.getCapability(Capabilities.SECURITY_OBJECT).ifPresent(securityObject -> securityObject.setSecurityMode(this.mode));
            return true;
        }
        return false;
    }
}

