/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.upgrade;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.MekanismAPI;
import mekanism.api.security.ISecurityObject;
import mekanism.api.security.SecurityMode;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeUpgradeSupport;
import mekanism.common.block.interfaces.IHasTileEntity;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.content.qio.IQIODriveItem;
import mekanism.common.recipe.upgrade.EnergyRecipeData;
import mekanism.common.recipe.upgrade.FluidRecipeData;
import mekanism.common.recipe.upgrade.ItemRecipeData;
import mekanism.common.recipe.upgrade.QIORecipeData;
import mekanism.common.recipe.upgrade.RecipeUpgradeType;
import mekanism.common.recipe.upgrade.SecurityRecipeData;
import mekanism.common.recipe.upgrade.UpgradesRecipeData;
import mekanism.common.recipe.upgrade.chemical.GasRecipeData;
import mekanism.common.recipe.upgrade.chemical.InfusionRecipeData;
import mekanism.common.recipe.upgrade.chemical.PigmentRecipeData;
import mekanism.common.recipe.upgrade.chemical.SlurryRecipeData;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.interfaces.ISustainedInventory;
import mekanism.common.util.ItemDataUtils;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidUtil;

@ParametersAreNonnullByDefault
public interface RecipeUpgradeData<TYPE extends RecipeUpgradeData<TYPE>> {
    @Nullable
    public TYPE merge(TYPE var1);

    public boolean applyToStack(ItemStack var1);

    @Nonnull
    public static Set<RecipeUpgradeType> getSupportedTypes(ItemStack stack) {
        if (stack.m_41619_()) {
            return Collections.emptySet();
        }
        EnumSet<RecipeUpgradeType> supportedTypes = EnumSet.noneOf(RecipeUpgradeType.class);
        Item item = stack.m_41720_();
        TileEntityMekanism tile = null;
        if (item instanceof BlockItem) {
            IHasTileEntity hasTileEntity;
            Object tileEntity;
            BlockItem blockItem = (BlockItem)item;
            Block block = blockItem.m_40614_();
            if (block instanceof IHasTileEntity && (tileEntity = (hasTileEntity = (IHasTileEntity)block).createDummyBlockEntity()) instanceof TileEntityMekanism) {
                tile = (TileEntityMekanism)tileEntity;
            }
            if (Attribute.has(block, AttributeUpgradeSupport.class)) {
                supportedTypes.add(RecipeUpgradeType.UPGRADE);
            }
        }
        if (stack.getCapability(Capabilities.STRICT_ENERGY_CAPABILITY).isPresent() || tile != null && tile.handles(SubstanceType.ENERGY)) {
            supportedTypes.add(RecipeUpgradeType.ENERGY);
        }
        if (FluidUtil.getFluidHandler((ItemStack)stack).isPresent() || tile != null && tile.handles(SubstanceType.FLUID)) {
            supportedTypes.add(RecipeUpgradeType.FLUID);
        }
        if (stack.getCapability(Capabilities.GAS_HANDLER_CAPABILITY).isPresent() || tile != null && tile.handles(SubstanceType.GAS)) {
            supportedTypes.add(RecipeUpgradeType.GAS);
        }
        if (stack.getCapability(Capabilities.INFUSION_HANDLER_CAPABILITY).isPresent() || tile != null && tile.handles(SubstanceType.INFUSION)) {
            supportedTypes.add(RecipeUpgradeType.INFUSION);
        }
        if (stack.getCapability(Capabilities.PIGMENT_HANDLER_CAPABILITY).isPresent() || tile != null && tile.handles(SubstanceType.PIGMENT)) {
            supportedTypes.add(RecipeUpgradeType.PIGMENT);
        }
        if (stack.getCapability(Capabilities.SLURRY_HANDLER_CAPABILITY).isPresent() || tile != null && tile.handles(SubstanceType.SLURRY)) {
            supportedTypes.add(RecipeUpgradeType.SLURRY);
        }
        if (item instanceof ISustainedInventory || tile != null && tile.persistInventory()) {
            supportedTypes.add(RecipeUpgradeType.ITEM);
        }
        if (stack.getCapability(Capabilities.OWNER_OBJECT).isPresent() || tile != null && tile.hasSecurity()) {
            supportedTypes.add(RecipeUpgradeType.SECURITY);
        }
        if (item instanceof IQIODriveItem) {
            supportedTypes.add(RecipeUpgradeType.QIO_DRIVE);
        }
        return supportedTypes;
    }

    @Nullable
    private static <TYPE extends RecipeUpgradeData<TYPE>> TYPE getContainerUpgradeData(@Nonnull ItemStack stack, String key, Function<ListTag, TYPE> creator) {
        ListTag containers = ItemDataUtils.getList(stack, key);
        return (TYPE)(containers.isEmpty() ? null : (RecipeUpgradeData)creator.apply(containers));
    }

    @Nullable
    public static RecipeUpgradeData<?> getUpgradeData(@Nonnull RecipeUpgradeType type, @Nonnull ItemStack stack) {
        Item item = stack.m_41720_();
        switch (type) {
            case ENERGY: {
                return RecipeUpgradeData.getContainerUpgradeData(stack, "EnergyContainers", EnergyRecipeData::new);
            }
            case FLUID: {
                return RecipeUpgradeData.getContainerUpgradeData(stack, "FluidTanks", FluidRecipeData::new);
            }
            case GAS: {
                return RecipeUpgradeData.getContainerUpgradeData(stack, "GasTanks", GasRecipeData::new);
            }
            case INFUSION: {
                return RecipeUpgradeData.getContainerUpgradeData(stack, "InfusionTanks", InfusionRecipeData::new);
            }
            case PIGMENT: {
                return RecipeUpgradeData.getContainerUpgradeData(stack, "PigmentTanks", PigmentRecipeData::new);
            }
            case SLURRY: {
                return RecipeUpgradeData.getContainerUpgradeData(stack, "SlurryTanks", SlurryRecipeData::new);
            }
            case ITEM: {
                ListTag inventory = ((ISustainedInventory)item).getInventory(stack);
                return inventory == null || inventory.isEmpty() ? null : new ItemRecipeData(inventory);
            }
            case SECURITY: {
                UUID ownerUUID = MekanismAPI.getSecurityUtils().getOwnerUUID((ICapabilityProvider)stack);
                if (ownerUUID == null) {
                    return null;
                }
                SecurityMode securityMode = stack.getCapability(Capabilities.SECURITY_OBJECT).map(ISecurityObject::getSecurityMode).orElse(SecurityMode.PUBLIC);
                return new SecurityRecipeData(ownerUUID, securityMode);
            }
            case UPGRADE: {
                return UpgradesRecipeData.tryCreate(ItemDataUtils.getCompound(stack, "componentUpgrade"));
            }
            case QIO_DRIVE: {
                IQIODriveItem.DriveMetadata data = IQIODriveItem.DriveMetadata.load(stack);
                if (data.count() <= 0L || !((IQIODriveItem)item).hasStoredItemMap(stack)) break;
                return new QIORecipeData(data, ItemDataUtils.getList(stack, "qioItemMap"));
            }
        }
        return null;
    }

    @Nullable
    public static <TYPE extends RecipeUpgradeData<TYPE>> TYPE mergeUpgradeData(List<RecipeUpgradeData<?>> upgradeData) {
        if (upgradeData.isEmpty()) {
            return null;
        }
        RecipeUpgradeData<?> data = upgradeData.get(0);
        for (int i = 1; i < upgradeData.size(); ++i) {
            if ((data = data.merge(upgradeData.get(i))) != null) continue;
            return null;
        }
        return (TYPE)data;
    }

    @Nullable
    default public TileEntityMekanism getTileFromBlock(Block block) {
        IHasTileEntity hasTileEntity;
        Object tileEntity;
        if (block instanceof IHasTileEntity && (tileEntity = (hasTileEntity = (IHasTileEntity)block).createDummyBlockEntity()) instanceof TileEntityMekanism) {
            return (TileEntityMekanism)tileEntity;
        }
        return null;
    }
}

