/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.annotation.ElementType;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import mekanism.common.Mekanism;
import mekanism.common.integration.computer.ComputerMethodMapper;
import mekanism.common.inventory.container.sync.dynamic.SyncMapper;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.moddiscovery.ModAnnotation;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.objectweb.asm.Type;

public class MekAnnotationScanner {
    public static void collectScanData() {
        Object2ObjectOpenHashMap classNameCache = new Object2ObjectOpenHashMap();
        Object2ObjectArrayMap scanners = new Object2ObjectArrayMap();
        EnumMap<ElementType, List<ScanData>> elementBasedScanData = new EnumMap<ElementType, List<ScanData>>(ElementType.class);
        MekAnnotationScanner.addScanningSupport((Map<BaseAnnotationScanner, ScanData>)scanners, elementBasedScanData, SyncMapper.INSTANCE, ComputerMethodMapper.INSTANCE);
        try {
            for (ModFileScanData modFileScanData : ModList.get().getAllScanData()) {
                for (ModFileScanData.AnnotationData data : modFileScanData.getAnnotations()) {
                    MekAnnotationScanner.gatherScanData(elementBasedScanData, classNameCache, data, modFileScanData.getIModInfoData());
                }
            }
        }
        catch (Throwable throwable) {
            Mekanism.logger.error("Failed to gather scan data", throwable);
        }
        for (Map.Entry entry : scanners.entrySet()) {
            ScanData scannerData = (ScanData)entry.getValue();
            Map<Class<?>, List<ModFileScanData.AnnotationData>> knownClasses = scannerData.knownClasses;
            if (knownClasses.isEmpty()) continue;
            try {
                ((BaseAnnotationScanner)entry.getKey()).collectScanData((Map<String, Class<?>>)classNameCache, knownClasses, scannerData.modFileData);
            }
            catch (Throwable throwable) {
                Mekanism.logger.error("Failed to collect scan data", throwable);
            }
        }
    }

    private static void gatherScanData(Map<ElementType, List<ScanData>> elementBasedScanData, Map<String, Class<?>> classNameCache, ModFileScanData.AnnotationData data, List<IModFileInfo> modFileData) {
        ElementType targetType = data.targetType();
        List elementScanData = elementBasedScanData.getOrDefault((Object)targetType, Collections.emptyList());
        for (ScanData scannerData : elementScanData) {
            for (Type type : scannerData.supportedTypes.get((Object)targetType)) {
                if (!type.equals((Object)data.annotationType())) continue;
                Class<?> clazz = MekAnnotationScanner.getClassForName(classNameCache, data.clazz().getClassName());
                if (clazz != null) {
                    scannerData.knownClasses.computeIfAbsent(clazz, c -> new ArrayList()).add(data);
                    scannerData.modFileData.addAll(modFileData);
                }
                return;
            }
        }
    }

    private static void addScanningSupport(Map<BaseAnnotationScanner, ScanData> scanners, Map<ElementType, List<ScanData>> elementBasedScanData, BaseAnnotationScanner ... baseScanners) {
        for (BaseAnnotationScanner baseScanner : baseScanners) {
            if (!baseScanner.isEnabled()) continue;
            ScanData scanData = new ScanData(baseScanner);
            scanners.put(baseScanner, scanData);
            for (ElementType elementType : scanData.supportedTypes.keySet()) {
                elementBasedScanData.computeIfAbsent(elementType, type -> new ArrayList()).add(scanData);
            }
        }
    }

    @Nullable
    private static Class<?> getClassForName(Map<String, Class<?>> classNameCache, String className) {
        Class<?> clazz;
        if (classNameCache.containsKey(className)) {
            return classNameCache.get(className);
        }
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            Mekanism.logger.error("Failed to find class '{}'", (Object)className);
            clazz = null;
        }
        catch (NoClassDefFoundError e) {
            Mekanism.logger.error("Failed to load class '{}'", (Object)className);
            throw e;
        }
        classNameCache.put(className, clazz);
        return clazz;
    }

    public static abstract class BaseAnnotationScanner {
        protected boolean isEnabled() {
            return true;
        }

        protected abstract Map<ElementType, Type[]> getSupportedTypes();

        protected abstract void collectScanData(Map<String, Class<?>> var1, Map<Class<?>, List<ModFileScanData.AnnotationData>> var2, Set<IModFileInfo> var3);

        @Nullable
        protected static Class<?> getAnnotationValue(Map<String, Class<?>> classNameCache, ModFileScanData.AnnotationData data, String key) {
            Type type = (Type)data.annotationData().get(key);
            return type == null ? null : MekAnnotationScanner.getClassForName(classNameCache, type.getClassName());
        }

        protected static <T> T getAnnotationValue(ModFileScanData.AnnotationData data, String key, T defaultValue) {
            return data.annotationData().getOrDefault(key, defaultValue);
        }

        protected static <T extends Enum<T>> T getAnnotationValue(ModFileScanData.AnnotationData data, String key, T defaultValue) {
            Map annotationData = data.annotationData();
            if (annotationData.containsKey(key)) {
                Object value = annotationData.get(key);
                if (value instanceof ModAnnotation.EnumHolder) {
                    ModAnnotation.EnumHolder enumHolder = (ModAnnotation.EnumHolder)value;
                    try {
                        return Enum.valueOf(defaultValue.getDeclaringClass(), enumHolder.getValue());
                    }
                    catch (IllegalArgumentException e) {
                        Mekanism.logger.error("Could not find enum value of: {}. Defaulting.", (Object)enumHolder.getValue());
                    }
                } else {
                    Mekanism.logger.warn("Unknown property value for enum should have been an enum holder. Defaulting.");
                }
            }
            return defaultValue;
        }

        protected static <T> T getAnnotationValue(ModFileScanData.AnnotationData data, String key, T defaultValue, Predicate<T> validator) {
            Object value;
            Map annotationData = data.annotationData();
            if (annotationData.containsKey(key) && validator.test(value = annotationData.get(key))) {
                return (T)value;
            }
            return defaultValue;
        }

        protected static <T extends Enum<T>> T getAnnotationValue(ModFileScanData.AnnotationData data, String key, T defaultValue, Predicate<T> validator) {
            Map annotationData = data.annotationData();
            if (annotationData.containsKey(key)) {
                Object value = annotationData.get(key);
                if (value instanceof ModAnnotation.EnumHolder) {
                    ModAnnotation.EnumHolder enumHolder = (ModAnnotation.EnumHolder)value;
                    try {
                        T returnValue = Enum.valueOf(defaultValue.getDeclaringClass(), enumHolder.getValue());
                        if (validator.test(returnValue)) {
                            return returnValue;
                        }
                    }
                    catch (IllegalArgumentException e) {
                        Mekanism.logger.error("Could not find enum value of: {}. Defaulting.", (Object)enumHolder.getValue());
                    }
                } else {
                    Mekanism.logger.warn("Unknown property value for enum should have been an enum holder. Defaulting.");
                }
            }
            return defaultValue;
        }

        @Nullable
        protected static Field getField(Class<?> annotatedClass, String fieldName) {
            Field field;
            try {
                field = annotatedClass.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                Mekanism.logger.error("Failed to find field '{}' for class '{}'", (Object)fieldName, (Object)annotatedClass.getSimpleName());
                return null;
            }
            field.setAccessible(true);
            return field;
        }

        @Nullable
        protected static Method getMethod(Class<?> annotatedClass, String methodName, String methodDescriptor) {
            Method method;
            MethodType methodType;
            try {
                methodType = MethodType.fromMethodDescriptorString(methodDescriptor, annotatedClass.getClassLoader());
            }
            catch (IllegalArgumentException | TypeNotPresentException e) {
                Mekanism.logger.error("Failed to generate method type. {}", (Object)e.getMessage());
                return null;
            }
            try {
                method = annotatedClass.getDeclaredMethod(methodName, methodType.parameterList().toArray(new Class[0]));
            }
            catch (NoSuchMethodException e) {
                Mekanism.logger.error("Failed to find method '{}' with descriptor '{}' for class '{}'", (Object)methodName, (Object)methodDescriptor, (Object)annotatedClass.getSimpleName());
                return null;
            }
            method.setAccessible(true);
            return method;
        }

        protected static <DATA> DATA getData(Map<Class<?>, DATA> map, Class<?> clazz, DATA empty) {
            Class<?> current = clazz;
            while (current.getSuperclass() != null) {
                DATA superCache = map.get(current = current.getSuperclass());
                if (superCache == null) continue;
                return superCache;
            }
            return empty;
        }

        protected static <INFO> List<ClassBasedInfo<INFO>> combineWithParents(Map<Class<?>, List<INFO>> flatMap) {
            Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
            for (Map.Entry<Class<?>, List<INFO>> entry2 : flatMap.entrySet()) {
                Class<?> clazz = entry2.getKey();
                List<INFO> info = entry2.getValue();
                Class<?> current = clazz;
                while (current.getSuperclass() != null) {
                    List<INFO> superInfo = (List<INFO>)map.get(current = current.getSuperclass());
                    if (superInfo != null) {
                        info.addAll(superInfo);
                        break;
                    }
                    superInfo = flatMap.get(current);
                    if (superInfo == null) continue;
                    info.addAll(superInfo);
                }
                map.put(clazz, info);
            }
            return map.entrySet().stream().map(entry -> new ClassBasedInfo((Class)entry.getKey(), (List)entry.getValue())).sorted(Comparator.comparing(ClassBasedInfo::className)).toList();
        }

        protected record ClassBasedInfo<INFO>(Class<?> clazz, String className, List<INFO> infoList) {
            public ClassBasedInfo(Class<?> clazz, List<INFO> infoList) {
                this(clazz, clazz.getName(), infoList);
            }
        }
    }

    private static class ScanData {
        private final Map<Class<?>, List<ModFileScanData.AnnotationData>> knownClasses = new Object2ObjectOpenHashMap();
        private final Set<IModFileInfo> modFileData = new HashSet<IModFileInfo>();
        private final Map<ElementType, Type[]> supportedTypes;

        public ScanData(BaseAnnotationScanner scanner) {
            this.supportedTypes = scanner.getSupportedTypes();
        }
    }
}

