/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.gear;

import java.util.List;
import java.util.function.LongSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.AutomationType;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.providers.IGasProvider;
import mekanism.common.capabilities.ItemCapabilityWrapper;
import mekanism.common.capabilities.chemical.item.RateLimitGasHandler;
import mekanism.common.item.gear.ItemSpecialArmor;
import mekanism.common.item.interfaces.IGasItem;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.StorageUtils;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public abstract class ItemGasArmor
extends ItemSpecialArmor
implements IGasItem {
    protected ItemGasArmor(ArmorMaterial material, EquipmentSlot slot, Item.Properties properties) {
        super(material, slot, properties.m_41497_(Rarity.RARE).setNoRepair().m_41487_(1));
    }

    protected abstract LongSupplier getMaxGas();

    protected abstract LongSupplier getFillRate();

    protected abstract IGasProvider getGasType();

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level world, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        StorageUtils.addStoredGas(stack, tooltip, true, false);
    }

    public boolean m_142522_(@Nonnull ItemStack stack) {
        return true;
    }

    public int m_142158_(@Nonnull ItemStack stack) {
        return StorageUtils.getBarWidth(stack);
    }

    public int m_142159_(@Nonnull ItemStack stack) {
        return ChemicalUtil.getRGBDurabilityForDisplay(stack);
    }

    public void m_6787_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> items) {
        super.m_6787_(group, items);
        if (this.m_41389_(group)) {
            items.add((Object)ChemicalUtil.getFilledVariant(new ItemStack((ItemLike)this), this.getMaxGas().getAsLong(), this.getGasType()));
        }
    }

    @Override
    protected void gatherCapabilities(List<ItemCapabilityWrapper.ItemCapability> capabilities, ItemStack stack, CompoundTag nbt) {
        super.gatherCapabilities(capabilities, stack, nbt);
        capabilities.add(RateLimitGasHandler.create(this.getFillRate(), this.getMaxGas(), (item, automationType) -> automationType != AutomationType.EXTERNAL, ChemicalTankBuilder.GAS.alwaysTrueBi, gas -> gas == this.getGasType().getChemical()));
    }
}

