/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IHUDElement;
import mekanism.api.gear.IModule;
import mekanism.api.gear.ModuleData;
import mekanism.api.gear.config.IModuleConfigItem;
import mekanism.api.gear.config.ModuleBooleanData;
import mekanism.api.gear.config.ModuleConfigData;
import mekanism.api.gear.config.ModuleConfigItemCreator;
import mekanism.api.math.FloatingLong;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.ILangEntry;
import mekanism.common.MekanismLang;
import mekanism.common.content.gear.ModuleConfigItem;
import mekanism.common.content.gear.ModuleHelper;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class Module<MODULE extends ICustomModule<MODULE>>
implements IModule<MODULE> {
    public static final String ENABLED_KEY = "enabled";
    public static final String HANDLE_MODE_CHANGE_KEY = "handleModeChange";
    private final List<ModuleConfigItem<?>> configItems = new ArrayList();
    private final ModuleData<MODULE> data;
    private final ItemStack container;
    private final MODULE customModule;
    private ModuleConfigItem<Boolean> enabled;
    private ModuleConfigItem<Boolean> handleModeChange;
    private ModuleConfigItem<Boolean> renderHUD;
    private int installed = 1;

    public Module(ModuleData<MODULE> data, ItemStack container) {
        this.data = data;
        this.container = container;
        this.customModule = data.get();
    }

    @Override
    public MODULE getCustomInstance() {
        return this.customModule;
    }

    public void init() {
        this.enabled = this.addConfigItem(new ModuleConfigItem<Boolean>(this, ENABLED_KEY, (ILangEntry)MekanismLang.MODULE_ENABLED, (ModuleConfigData)new ModuleBooleanData(!this.data.isDisabledByDefault())){

            @Override
            public void set(@Nonnull Boolean val, @Nullable Runnable callback) {
                boolean wasEnabled = (Boolean)this.get();
                super.set(val, callback);
                if (callback == null && wasEnabled != (Boolean)this.get()) {
                    Module.this.customModule.onEnabledStateChange(Module.this);
                }
            }
        });
        if (this.data.handlesModeChange()) {
            this.handleModeChange = this.addConfigItem(new ModuleConfigItem<Boolean>(this, HANDLE_MODE_CHANGE_KEY, MekanismLang.MODULE_HANDLE_MODE_CHANGE, new ModuleBooleanData()));
        }
        if (this.data.rendersHUD()) {
            this.renderHUD = this.addConfigItem(new ModuleConfigItem<Boolean>(this, "renderHUD", MekanismLang.MODULE_RENDER_HUD, new ModuleBooleanData()));
        }
        this.customModule.init(this, new ModuleConfigItemCreator(){

            @Override
            public <TYPE> IModuleConfigItem<TYPE> createConfigItem(String name, ILangEntry description, ModuleConfigData<TYPE> data) {
                return Module.this.addConfigItem(new ModuleConfigItem<TYPE>(Module.this, name, description, data));
            }

            @Override
            public IModuleConfigItem<Boolean> createDisableableConfigItem(String name, ILangEntry description, boolean def, BooleanSupplier isConfigEnabled) {
                return Module.this.addConfigItem(new ModuleConfigItem.DisableableModuleConfigItem(Module.this, name, description, def, isConfigEnabled));
            }
        });
    }

    private <T> ModuleConfigItem<T> addConfigItem(ModuleConfigItem<T> item) {
        this.configItems.add(item);
        return item;
    }

    public void tick(Player player) {
        if (this.isEnabled()) {
            if (player.f_19853_.m_5776_()) {
                this.customModule.tickClient(this, player);
            } else {
                this.customModule.tickServer(this, player);
            }
        }
    }

    @Override
    @Nullable
    public IEnergyContainer getEnergyContainer() {
        return StorageUtils.getEnergyContainer(this.getContainer(), 0);
    }

    @Override
    public FloatingLong getContainerEnergy() {
        IEnergyContainer energyContainer = this.getEnergyContainer();
        return energyContainer == null ? FloatingLong.ZERO : energyContainer.getEnergy();
    }

    @Override
    public boolean canUseEnergy(LivingEntity wearer, FloatingLong energy) {
        return this.canUseEnergy(wearer, energy, false);
    }

    @Override
    public boolean canUseEnergy(LivingEntity wearer, FloatingLong energy, boolean ignoreCreative) {
        return this.canUseEnergy(wearer, this.getEnergyContainer(), energy, ignoreCreative);
    }

    @Override
    public boolean canUseEnergy(LivingEntity wearer, @Nullable IEnergyContainer energyContainer, FloatingLong energy, boolean ignoreCreative) {
        Player player;
        if (!(energyContainer == null || wearer.m_5833_() || ignoreCreative && wearer instanceof Player && (player = (Player)wearer).m_7500_())) {
            return energyContainer.extract(energy, Action.SIMULATE, AutomationType.MANUAL).equals(energy);
        }
        return false;
    }

    @Override
    public FloatingLong useEnergy(LivingEntity wearer, FloatingLong energy) {
        return this.useEnergy(wearer, energy, true);
    }

    @Override
    public FloatingLong useEnergy(LivingEntity wearer, FloatingLong energy, boolean freeCreative) {
        return this.useEnergy(wearer, this.getEnergyContainer(), energy, freeCreative);
    }

    @Override
    public FloatingLong useEnergy(LivingEntity wearer, @Nullable IEnergyContainer energyContainer, FloatingLong energy, boolean freeCreative) {
        Player player;
        if (!(energyContainer == null || freeCreative && wearer instanceof Player && !MekanismUtils.isPlayingMode(player = (Player)wearer))) {
            return energyContainer.extract(energy, Action.EXECUTE, AutomationType.MANUAL);
        }
        return FloatingLong.ZERO;
    }

    public void read(CompoundTag nbt) {
        if (nbt.m_128425_("amount", 3)) {
            this.installed = nbt.m_128451_("amount");
        }
        this.init();
        for (ModuleConfigItem<?> item : this.configItems) {
            item.read(nbt);
        }
    }

    public void save(@Nullable Runnable callback) {
        CompoundTag modulesTag = ItemDataUtils.getOrAddCompound(this.container, "modules");
        String registryName = this.data.getRegistryName().toString();
        CompoundTag nbt = modulesTag.m_128469_(registryName);
        nbt.m_128405_("amount", this.installed);
        for (ModuleConfigItem<?> item : this.configItems) {
            item.write(nbt);
        }
        modulesTag.m_128365_(registryName, (Tag)nbt);
        if (callback != null) {
            callback.run();
        }
    }

    @Override
    public ModuleData<MODULE> getData() {
        return this.data;
    }

    @Override
    public int getInstalledCount() {
        return this.installed;
    }

    public void setInstalledCount(int installed) {
        this.installed = installed;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled.get();
    }

    public void setDisabledForce(boolean hasCallback) {
        if (this.isEnabled()) {
            this.enabled.getData().set(false);
            this.save(null);
            if (!hasCallback) {
                this.customModule.onEnabledStateChange(this);
            }
        }
    }

    @Override
    public ItemStack getContainer() {
        return this.container;
    }

    public List<ModuleConfigItem<?>> getConfigItems() {
        return this.configItems;
    }

    public void addHUDStrings(Player player, List<Component> list) {
        this.customModule.addHUDStrings(this, player, list::add);
    }

    public void addHUDElements(Player player, List<IHUDElement> list) {
        this.customModule.addHUDElements(this, player, list::add);
    }

    public void changeMode(@Nonnull Player player, @Nonnull ItemStack stack, int shift, boolean displayChangeMessage) {
        this.customModule.changeMode(this, player, stack, shift, displayChangeMessage);
    }

    @Override
    public boolean handlesModeChange() {
        return this.data.handlesModeChange() && this.handleModeChange.get() != false && (this.isEnabled() || this.customModule.canChangeModeWhenDisabled(this));
    }

    public void setModeHandlingDisabledForce() {
        if (this.data.handlesModeChange()) {
            this.handleModeChange.getData().set(false);
            this.save(null);
        }
    }

    @Override
    public boolean renderHUD() {
        return this.data.rendersHUD() && this.renderHUD.get() != false;
    }

    public void onAdded(boolean first) {
        for (Module<?> module : ModuleHelper.INSTANCE.loadAll(this.getContainer())) {
            if (module.getData() == this.getData()) continue;
            if (this.getData().isExclusive() && module.getData().isExclusive()) {
                module.setDisabledForce(false);
            }
            if (!this.handlesModeChange() || !module.handlesModeChange()) continue;
            module.setModeHandlingDisabledForce();
        }
        this.customModule.onAdded(this, first);
    }

    public void onRemoved(boolean last) {
        this.customModule.onRemoved(this, last);
    }

    @Override
    public void displayModeChange(Player player, Component modeName, IHasTextComponent mode) {
        player.m_6352_(MekanismUtils.logFormat(MekanismLang.MODULE_MODE_CHANGE.translate(modeName, EnumColor.INDIGO, mode)), Util.f_137441_);
    }

    @Override
    public void toggleEnabled(Player player, Component modeName) {
        this.enabled.set(!this.isEnabled());
        TranslatableComponent message = this.isEnabled() ? MekanismLang.GENERIC_STORED.translate(modeName, EnumColor.BRIGHT_GREEN, MekanismLang.MODULE_ENABLED_LOWER) : MekanismLang.GENERIC_STORED.translate(modeName, EnumColor.DARK_RED, MekanismLang.MODULE_DISABLED_LOWER);
        player.m_6352_(MekanismUtils.logFormat(message), Util.f_137441_);
    }
}

