/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.evaporation;

import java.util.Arrays;
import java.util.List;
import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.IEvaporationSolar;
import mekanism.api.annotations.NonNull;
import mekanism.api.heat.HeatAPI;
import mekanism.api.recipes.FluidToFluidRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.OneInputCachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.fluid.MultiblockFluidTank;
import mekanism.common.capabilities.heat.BasicHeatCapacitor;
import mekanism.common.capabilities.heat.MultiblockHeatCapacitor;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.SyntheticComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.container.sync.dynamic.ContainerSync;
import mekanism.common.inventory.slot.FluidInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.lib.multiblock.IValveHandler;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.ISingleRecipeLookupHandler;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.recipe.lookup.monitor.RecipeCacheLookupMonitor;
import mekanism.common.tile.multiblock.TileEntityThermalEvaporationBlock;
import mekanism.common.tile.prefab.TileEntityRecipeMachine;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;

public class EvaporationMultiblockData
extends MultiblockData
implements IValveHandler,
ISingleRecipeLookupHandler.FluidRecipeLookupHandler<FluidToFluidRecipe> {
    private static final List<CachedRecipe.OperationTracker.RecipeError> TRACKED_ERROR_TYPES = List.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
    private static final int MAX_OUTPUT = 10000;
    public static final int MAX_HEIGHT = 18;
    public static final double MAX_MULTIPLIER_TEMP = 3000.0;
    public static final int FLUID_PER_TANK = 64000;
    @ContainerSync
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerFluidTankWrapper.class, methodNames={"getInput", "getInputCapacity", "getInputNeeded", "getInputFilledPercentage"})
    public BasicFluidTank inputTank;
    @ContainerSync
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerFluidTankWrapper.class, methodNames={"getOutput", "getOutputCapacity", "getOutputNeeded", "getOutputFilledPercentage"})
    public BasicFluidTank outputTank;
    @ContainerSync
    public BasicHeatCapacitor heatCapacitor;
    private double biomeAmbientTemp;
    private double tempMultiplier;
    public float prevScale;
    @ContainerSync
    @SyntheticComputerMethod(getter="getProductionAmount")
    public double lastGain;
    @ContainerSync
    @SyntheticComputerMethod(getter="getEnvironmentalLoss")
    public double lastEnvironmentLoss;
    private final RecipeCacheLookupMonitor<FluidToFluidRecipe> recipeCacheLookupMonitor;
    private final BooleanSupplier recheckAllRecipeErrors;
    @ContainerSync
    private final boolean[] trackedErrors = new boolean[TRACKED_ERROR_TYPES.size()];
    private final IEvaporationSolar[] solars = new IEvaporationSolar[4];
    private final IOutputHandler<@NonNull FluidStack> outputHandler;
    private final IInputHandler<@NonNull FluidStack> inputHandler;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getInputItemInput"})
    private final FluidInventorySlot inputInputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getInputItemOutput"})
    private final OutputInventorySlot outputInputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getOutputItemInput"})
    private final FluidInventorySlot inputOutputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getOutputItemOutput"})
    private final OutputInventorySlot outputOutputSlot;

    public EvaporationMultiblockData(TileEntityThermalEvaporationBlock tile) {
        super(tile);
        this.recipeCacheLookupMonitor = new RecipeCacheLookupMonitor<FluidToFluidRecipe>(this);
        this.recheckAllRecipeErrors = TileEntityRecipeMachine.shouldRecheckAllErrors(tile);
        this.biomeAmbientTemp = HeatAPI.getAmbientTemp((LevelReader)tile.m_58904_(), tile.getTilePos());
        this.inputTank = MultiblockFluidTank.input(this, tile, this::getMaxFluid, this::containsRecipe, this.recipeCacheLookupMonitor);
        this.fluidTanks.add(this.inputTank);
        this.outputTank = MultiblockFluidTank.output(this, tile, () -> 10000, BasicFluidTank.alwaysTrue);
        this.fluidTanks.add(this.outputTank);
        this.inputHandler = InputHelper.getInputHandler(this.inputTank, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT);
        this.outputHandler = OutputHelper.getOutputHandler(this.outputTank, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE);
        this.inputInputSlot = FluidInventorySlot.fill(this.inputTank, this, 28, 20);
        this.inventorySlots.add(this.inputInputSlot);
        this.outputInputSlot = OutputInventorySlot.at(this, 28, 51);
        this.inventorySlots.add(this.outputInputSlot);
        this.inputOutputSlot = FluidInventorySlot.drain(this.outputTank, this, 132, 20);
        this.inventorySlots.add(this.inputOutputSlot);
        this.outputOutputSlot = OutputInventorySlot.at(this, 132, 51);
        this.inventorySlots.add(this.outputOutputSlot);
        this.inputInputSlot.setSlotType(ContainerSlotType.INPUT);
        this.inputOutputSlot.setSlotType(ContainerSlotType.INPUT);
        this.heatCapacitor = MultiblockHeatCapacitor.create(this, tile, MekanismConfig.general.evaporationHeatCapacity.get() * 3.0, () -> this.biomeAmbientTemp);
        this.heatCapacitors.add(this.heatCapacitor);
    }

    @Override
    public void onCreated(Level world) {
        super.onCreated(world);
        this.biomeAmbientTemp = this.calculateAverageAmbientTemperature(world);
        this.heatCapacitor.setHeatCapacity(MekanismConfig.general.evaporationHeatCapacity.get() * (double)this.height(), true);
        this.updateSolars(world);
    }

    @Override
    public boolean tick(Level world) {
        boolean needsPacket = super.tick(world);
        this.lastEnvironmentLoss = this.simulateEnvironment();
        this.updateHeatCapacitors(null);
        this.tempMultiplier = (Math.min(3000.0, this.getTemperature()) - 300.0) * MekanismConfig.general.evaporationTempMultiplier.get() * ((double)this.height() / 18.0);
        this.inputOutputSlot.drainTank(this.outputOutputSlot);
        this.inputInputSlot.fillTank(this.outputInputSlot);
        this.recipeCacheLookupMonitor.updateAndProcess();
        float scale = MekanismUtils.getScale(this.prevScale, this.inputTank);
        if (scale != this.prevScale) {
            this.prevScale = scale;
            needsPacket = true;
        }
        return needsPacket;
    }

    @Override
    public void readUpdateTag(CompoundTag tag) {
        super.readUpdateTag(tag);
        NBTUtils.setFluidStackIfPresent(tag, "fluid", fluid -> this.inputTank.setStack((FluidStack)fluid));
        NBTUtils.setFloatIfPresent(tag, "scale", scale -> {
            this.prevScale = scale;
        });
        this.readValves(tag);
    }

    @Override
    public void writeUpdateTag(CompoundTag tag) {
        super.writeUpdateTag(tag);
        tag.m_128365_("fluid", (Tag)this.inputTank.getFluid().writeToNBT(new CompoundTag()));
        tag.m_128350_("scale", this.prevScale);
        this.writeValves(tag);
    }

    @Override
    public double simulateEnvironment() {
        double currentTemperature = this.getTemperature();
        double heatCapacity = this.heatCapacitor.getHeatCapacity();
        this.heatCapacitor.handleHeat((double)this.getActiveSolars() * MekanismConfig.general.evaporationSolarMultiplier.get() * heatCapacity);
        if (Math.abs(currentTemperature - this.biomeAmbientTemp) < 0.001) {
            this.heatCapacitor.handleHeat(this.biomeAmbientTemp * heatCapacity - this.heatCapacitor.getHeat());
        } else {
            double incr = MekanismConfig.general.evaporationHeatDissipation.get() * Math.sqrt(Math.abs(currentTemperature - this.biomeAmbientTemp));
            if (currentTemperature > this.biomeAmbientTemp) {
                incr = -incr;
            }
            this.heatCapacitor.handleHeat(heatCapacity * incr);
            if (incr < 0.0) {
                return -incr;
            }
        }
        return 0.0;
    }

    @ComputerMethod
    public double getTemperature() {
        return this.heatCapacitor.getTemperature();
    }

    public int getMaxFluid() {
        return this.height() * 4 * 64000;
    }

    @Override
    @Nonnull
    public IMekanismRecipeTypeProvider<FluidToFluidRecipe, InputRecipeCache.SingleFluid<FluidToFluidRecipe>> getRecipeType() {
        return MekanismRecipeType.EVAPORATING;
    }

    @Override
    @Nullable
    public FluidToFluidRecipe getRecipe(int cacheIndex) {
        return (FluidToFluidRecipe)this.findFirstRecipe(this.inputHandler);
    }

    @Override
    public void clearRecipeErrors(int cacheIndex) {
        Arrays.fill(this.trackedErrors, false);
    }

    @Override
    @Nonnull
    public CachedRecipe<FluidToFluidRecipe> createNewCachedRecipe(@Nonnull FluidToFluidRecipe recipe, int cacheIndex) {
        return OneInputCachedRecipe.fluidToFluid(recipe, this.recheckAllRecipeErrors, this.inputHandler, this.outputHandler).setErrorsChanged(errors -> {
            for (int i = 0; i < this.trackedErrors.length; ++i) {
                this.trackedErrors[i] = errors.contains(TRACKED_ERROR_TYPES.get(i));
            }
        }).setActive(active -> {
            this.lastGain = active ? (this.tempMultiplier > 0.0 && this.tempMultiplier < 1.0 ? (double)(1.0f / (float)((int)Math.ceil(1.0 / this.tempMultiplier))) : this.tempMultiplier) : 0.0;
        }).setRequiredTicks(() -> this.tempMultiplier > 0.0 && this.tempMultiplier < 1.0 ? (int)Math.ceil(1.0 / this.tempMultiplier) : 1).setBaselineMaxOperations(() -> this.tempMultiplier > 0.0 && this.tempMultiplier < 1.0 ? 1 : (int)this.tempMultiplier);
    }

    public boolean hasWarning(CachedRecipe.OperationTracker.RecipeError error) {
        int errorIndex = TRACKED_ERROR_TYPES.indexOf(error);
        if (errorIndex == -1) {
            return false;
        }
        return this.trackedErrors[errorIndex];
    }

    @Override
    public Level getHandlerWorld() {
        return this.getWorld();
    }

    @ComputerMethod
    private int getActiveSolars() {
        int ret = 0;
        for (IEvaporationSolar solar : this.solars) {
            if (solar == null || !solar.canSeeSun()) continue;
            ++ret;
        }
        return ret;
    }

    private void updateSolarSpot(Level world, BlockPos pos, int i) {
        BlockEntity tile = WorldUtils.getTileEntity((BlockGetter)world, pos);
        this.solars[i] = tile == null || tile.m_58901_() ? null : (IEvaporationSolar)CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.EVAPORATION_SOLAR_CAPABILITY, Direction.DOWN).resolve().orElse(null);
    }

    public void updateSolarSpot(Level world, BlockPos pos) {
        BlockPos maxPos = this.getMaxPos();
        if (pos.m_123342_() == maxPos.m_123342_() && this.getBounds().isOnCorner(pos)) {
            int i = 0;
            if (pos.m_123341_() + 3 == maxPos.m_123341_()) {
                ++i;
            }
            if (pos.m_123343_() + 3 == maxPos.m_123343_()) {
                i += 2;
            }
            this.updateSolarSpot(world, pos, i);
        }
    }

    private void updateSolars(Level world) {
        BlockPos maxPos = this.getMaxPos();
        this.updateSolarSpot(world, maxPos, 0);
        this.updateSolarSpot(world, maxPos.m_142386_(3), 1);
        this.updateSolarSpot(world, maxPos.m_142390_(3), 2);
        this.updateSolarSpot(world, maxPos.m_142082_(-3, 0, -3), 3);
    }

    @Override
    protected int getMultiblockRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents(this.inputTank.getFluidAmount(), this.inputTank.getCapacity());
    }
}

