/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block.transmitter;

import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.block.BlockMekanism;
import mekanism.common.block.states.IStateFluidLoggable;
import mekanism.common.content.network.transmitter.Transmitter;
import mekanism.common.lib.transmitter.ConnectionType;
import mekanism.common.registries.MekanismItems;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.MultipartUtils;
import mekanism.common.util.VoxelShapeUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class BlockTransmitter
extends BlockMekanism
implements IStateFluidLoggable {
    private static final Short2ObjectMap<VoxelShape> cachedShapes = new Short2ObjectOpenHashMap();

    protected BlockTransmitter() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76283_).m_60913_(1.0f, 6.0f));
    }

    @Nonnull
    @Deprecated
    public InteractionResult m_6227_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (MekanismUtils.canUseAsWrench(stack) && player.m_6144_()) {
            if (!world.f_46443_) {
                WorldUtils.dismantleBlock(state, world, pos);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public void m_6402_(@Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable LivingEntity placer, @Nonnull ItemStack stack) {
        TileEntityTransmitter tile = WorldUtils.getTileEntity(TileEntityTransmitter.class, (BlockGetter)world, pos);
        if (tile != null) {
            tile.onAdded();
        }
    }

    @Deprecated
    public void m_6861_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull Block neighborBlock, @Nonnull BlockPos neighborPos, boolean isMoving) {
        TileEntityTransmitter tile = WorldUtils.getTileEntity(TileEntityTransmitter.class, (BlockGetter)world, pos);
        if (tile != null) {
            Direction side = Direction.m_122372_((float)(neighborPos.m_123341_() - pos.m_123341_()), (float)(neighborPos.m_123342_() - pos.m_123342_()), (float)(neighborPos.m_123343_() - pos.m_123343_()));
            tile.onNeighborBlockChange(side);
        }
    }

    public void onNeighborChange(BlockState state, LevelReader world, BlockPos pos, BlockPos neighbor) {
        TileEntityTransmitter tile = WorldUtils.getTileEntity(TileEntityTransmitter.class, (BlockGetter)world, pos);
        if (tile != null) {
            Direction side = Direction.m_122372_((float)(neighbor.m_123341_() - pos.m_123341_()), (float)(neighbor.m_123342_() - pos.m_123342_()), (float)(neighbor.m_123343_() - pos.m_123343_()));
            tile.onNeighborTileChange(side);
        }
    }

    @Deprecated
    public boolean m_7357_(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nonnull PathComputationType type) {
        return false;
    }

    @Nonnull
    @Deprecated
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos, CollisionContext context) {
        EntityCollisionContext entityContext;
        if (!context.m_7142_((Item)MekanismItems.CONFIGURATOR.m_5456_())) {
            return this.getRealShape(world, pos);
        }
        if (!(context instanceof EntityCollisionContext) || (entityContext = (EntityCollisionContext)context).m_193113_() == null) {
            return this.getRealShape(world, pos);
        }
        TileEntityTransmitter tile = WorldUtils.getTileEntity(TileEntityTransmitter.class, world, pos);
        if (tile == null) {
            return this.getCenter();
        }
        MultipartUtils.AdvancedRayTraceResult result = MultipartUtils.collisionRayTrace(entityContext.m_193113_(), pos, tile.getCollisionBoxes());
        if (result != null && result.valid()) {
            return result.bounds;
        }
        return this.getCenter();
    }

    @Nonnull
    @Deprecated
    public VoxelShape m_7952_(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos) {
        return this.getRealShape(world, pos);
    }

    @Nonnull
    @Deprecated
    public VoxelShape m_5939_(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return this.getRealShape(world, pos);
    }

    protected abstract VoxelShape getCenter();

    protected abstract VoxelShape getSide(ConnectionType var1, Direction var2);

    private VoxelShape getRealShape(BlockGetter world, BlockPos pos) {
        TileEntityTransmitter tile = WorldUtils.getTileEntity(TileEntityTransmitter.class, world, pos);
        if (tile == null) {
            return this.getCenter();
        }
        Transmitter<?, ?, ?> transmitter = tile.getTransmitter();
        int packedKey = tile.getTransmitterType().getSize().ordinal() << 12;
        for (Direction side : EnumUtils.DIRECTIONS) {
            ConnectionType connectionType = transmitter.getConnectionType(side);
            packedKey |= connectionType.ordinal() << side.ordinal() * 2;
        }
        return (VoxelShape)cachedShapes.computeIfAbsent((short)packedKey, packed -> {
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>(EnumUtils.DIRECTIONS.length);
            for (Direction side : EnumUtils.DIRECTIONS) {
                int index = packed >> side.ordinal() * 2 & 3;
                ConnectionType connectionType = ConnectionType.byIndexStatic(index);
                if (connectionType == ConnectionType.NONE) continue;
                shapes.add(this.getSide(connectionType, side));
            }
            VoxelShape center = this.getCenter();
            if (shapes.isEmpty()) {
                return center;
            }
            return VoxelShapeUtils.batchCombine(center, BooleanOp.f_82695_, true, shapes);
        });
    }
}

