/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.client.MekanismClient;
import mekanism.client.model.ModelEnergyCube;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.common.tile.TileEntityEnergyCube;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.util.profiling.ProfilerFiller;

@ParametersAreNonnullByDefault
public class RenderEnergyCube
extends MekanismTileEntityRenderer<TileEntityEnergyCube> {
    public static final Vector3f coreVec = new Vector3f(0.0f, MekanismUtils.ONE_OVER_ROOT_TWO, MekanismUtils.ONE_OVER_ROOT_TWO);
    private final ModelEnergyCube model;
    private final ModelEnergyCube.ModelEnergyCore core;

    public RenderEnergyCube(BlockEntityRendererProvider.Context context) {
        super(context);
        this.model = new ModelEnergyCube(context.m_173585_());
        this.core = new ModelEnergyCube.ModelEnergyCore(context.m_173585_());
    }

    @Override
    protected void render(TileEntityEnergyCube tile, float partialTick, PoseStack matrix, MultiBufferSource renderer, int light, int overlayLight, ProfilerFiller profiler) {
        profiler.m_6180_("frame");
        matrix.m_85836_();
        matrix.m_85837_(0.5, 1.5, 0.5);
        switch (tile.getDirection()) {
            case DOWN: {
                matrix.m_85845_(Vector3f.f_122222_.m_122240_(90.0f));
                matrix.m_85837_(0.0, 1.0, -1.0);
                break;
            }
            case UP: {
                matrix.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
                matrix.m_85837_(0.0, 1.0, 1.0);
                break;
            }
            default: {
                MekanismRenderer.rotate(matrix, tile.getDirection(), 0.0f, 180.0f, 90.0f, 270.0f);
            }
        }
        matrix.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        profiler.m_6180_("corners");
        this.model.render(matrix, renderer, light, overlayLight, tile.getTier(), false, false);
        profiler.m_6182_("sides");
        this.model.renderSidesBatched(tile, matrix, renderer, light, overlayLight);
        profiler.m_7238_();
        matrix.m_85849_();
        profiler.m_6182_("core");
        float energyScale = tile.getEnergyScale();
        if (energyScale > 0.0f) {
            matrix.m_85836_();
            matrix.m_85837_(0.5, 0.5, 0.5);
            float ticks = (float)MekanismClient.ticksPassed + partialTick;
            matrix.m_85841_(0.4f, 0.4f, 0.4f);
            matrix.m_85837_(0.0, Math.sin(Math.toRadians(3.0f * ticks)) / 7.0, 0.0);
            float scaledTicks = 4.0f * ticks;
            matrix.m_85845_(Vector3f.f_122225_.m_122240_(scaledTicks));
            matrix.m_85845_(coreVec.m_122240_(36.0f + scaledTicks));
            this.core.render(matrix, renderer, 0xF000F0, overlayLight, tile.getTier().getBaseTier().getColor(), energyScale);
            matrix.m_85849_();
        }
        profiler.m_7238_();
    }

    @Override
    protected String getProfilerSection() {
        return "energyCube";
    }
}

