/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.obj;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.client.model.data.TransmitterModelData;
import mekanism.client.render.obj.VisibleModelConfiguration;
import mekanism.common.config.MekanismConfig;
import mekanism.common.lib.transmitter.ConnectionType;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.data.IModelData;

public class TransmitterModelConfiguration
extends VisibleModelConfiguration {
    @Nonnull
    private final TransmitterModelData modelData;

    public TransmitterModelConfiguration(IModelConfiguration internal, List<String> visibleGroups, @Nonnull IModelData modelData) {
        super(internal, visibleGroups);
        this.modelData = (TransmitterModelData)modelData.getData(TileEntityTransmitter.TRANSMITTER_PROPERTY);
    }

    @Nullable
    private static Direction directionForPiece(@Nonnull String piece) {
        if (piece.endsWith("down")) {
            return Direction.DOWN;
        }
        if (piece.endsWith("up")) {
            return Direction.UP;
        }
        if (piece.endsWith("north")) {
            return Direction.NORTH;
        }
        if (piece.endsWith("south")) {
            return Direction.SOUTH;
        }
        if (piece.endsWith("east")) {
            return Direction.EAST;
        }
        if (piece.endsWith("west")) {
            return Direction.WEST;
        }
        return null;
    }

    private String adjustTextureName(String name) {
        Direction direction = TransmitterModelConfiguration.directionForPiece(name);
        if (direction != null) {
            if (this.getIconStatus(direction) != IconStatus.NO_SHOW) {
                String string = name = name.contains("glass") ? "#side_glass" : "#side";
            }
            if (MekanismConfig.client.opaqueTransmitters.get()) {
                if (name.startsWith("#side")) {
                    return name + "_opaque";
                }
                if (name.startsWith("#center")) {
                    return name.contains("glass") ? "#center_glass_opaque" : "#center_opaque";
                }
            }
            return name;
        }
        if (MekanismConfig.client.opaqueTransmitters.get() && name.startsWith("#side")) {
            return name + "_opaque";
        }
        return name;
    }

    public IconStatus getIconStatus(Direction side) {
        if (this.modelData instanceof TransmitterModelData.Diversion) {
            return IconStatus.NO_SHOW;
        }
        boolean hasConnection = this.modelData.getConnectionType(side) != ConnectionType.NONE;
        Predicate<Direction> has = dir -> this.modelData.getConnectionType((Direction)dir) != ConnectionType.NONE;
        if (!hasConnection) {
            boolean hasUpDown = has.test(Direction.DOWN) || has.test(Direction.UP);
            boolean hasNorthSouth = has.test(Direction.NORTH) || has.test(Direction.SOUTH);
            boolean hasEastWest = has.test(Direction.EAST) || has.test(Direction.WEST);
            switch (side) {
                case DOWN: 
                case UP: {
                    if ((!hasNorthSouth || hasEastWest) && (hasNorthSouth || !hasEastWest)) break;
                    if (has.test(Direction.NORTH) && has.test(Direction.SOUTH)) {
                        return IconStatus.NO_ROTATION;
                    }
                    if (!has.test(Direction.EAST) || !has.test(Direction.WEST)) break;
                    return IconStatus.ROTATE_270;
                }
                case NORTH: 
                case SOUTH: {
                    if ((!hasUpDown || hasEastWest) && (hasUpDown || !hasEastWest)) break;
                    if (has.test(Direction.UP) && has.test(Direction.DOWN)) {
                        return IconStatus.NO_ROTATION;
                    }
                    if (!has.test(Direction.EAST) || !has.test(Direction.WEST)) break;
                    return IconStatus.ROTATE_270;
                }
                case WEST: 
                case EAST: {
                    if ((!hasUpDown || hasNorthSouth) && (hasUpDown || !hasNorthSouth)) break;
                    if (has.test(Direction.UP) && has.test(Direction.DOWN)) {
                        return IconStatus.NO_ROTATION;
                    }
                    if (!has.test(Direction.NORTH) || !has.test(Direction.SOUTH)) break;
                    return IconStatus.ROTATE_270;
                }
            }
        }
        return IconStatus.NO_SHOW;
    }

    @Override
    public boolean isTexturePresent(@Nonnull String name) {
        return this.internal.isTexturePresent(this.adjustTextureName(name));
    }

    @Override
    @Nonnull
    public Material resolveTexture(@Nonnull String name) {
        return this.internal.resolveTexture(this.adjustTextureName(name));
    }

    public static enum IconStatus {
        NO_ROTATION(0.0f),
        ROTATE_270(270.0f),
        NO_SHOW(0.0f);

        private final float angle;

        private IconStatus(float angle) {
            this.angle = angle;
        }

        public float getAngle() {
            return this.angle;
        }
    }
}

