/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.lib;

import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import mekanism.common.lib.Color;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.phys.Vec3;

public class Vertex {
    private static final float LIGHT_PACK_FACTOR = 0.0073244423f;
    private Vec3 pos;
    private Vec3 normal;
    private Color color;
    private float texU;
    private float texV;
    private float lightU;
    private float lightV;

    public Vertex() {
    }

    public Vertex(Vec3 pos, Vec3 normal, Color color, float texU, float texV, float lightU, float lightV) {
        this.pos = pos;
        this.normal = normal;
        this.color = color;
        this.texU = texU;
        this.texV = texV;
        this.lightU = lightU;
        this.lightV = lightV;
    }

    public static Vertex create(Vec3 pos, Vec3 normal, Color color, TextureAtlasSprite sprite, float texU, float texV, float lightU, float lightV) {
        return new Vertex(pos, normal, color, sprite.m_118367_((double)texU), sprite.m_118393_((double)texV), lightU, lightV);
    }

    public static Vertex create(Vec3 pos, Vec3 normal, TextureAtlasSprite sprite, float u, float v) {
        return Vertex.create(pos, normal, Color.WHITE, sprite, u, v, 0.0f, 0.0f);
    }

    public Vec3 getPos() {
        return this.pos;
    }

    public Vec3 getNormal() {
        return this.normal;
    }

    public Color getColor() {
        return this.color;
    }

    public float getTexU() {
        return this.texU;
    }

    public float getTexV() {
        return this.texV;
    }

    public float getLightU() {
        return this.lightU;
    }

    public float getLightV() {
        return this.lightV;
    }

    public Vertex color(Color color) {
        this.color = color;
        return this;
    }

    public Vertex pos(Vec3 pos) {
        this.pos = pos;
        return this;
    }

    public Vertex normal(Vec3 normal) {
        this.normal = normal;
        return this;
    }

    public Vertex texRaw(float u, float v) {
        this.texU = u;
        this.texV = v;
        return this;
    }

    public Vertex lightRaw(float u, float v) {
        this.lightU = u;
        this.lightV = v;
        return this;
    }

    public Vertex light(float u, float v) {
        return this.lightRaw(u * 0.0073244423f, v * 0.0073244423f);
    }

    public Vertex copy() {
        return new Vertex(this.pos, this.normal, this.color, this.texU, this.texV, this.lightU, this.lightV);
    }

    public float[][] pack(VertexFormat format) {
        float[][] ret = new float[format.m_86023_().size()][4];
        block6: for (int i = 0; i < format.m_86023_().size(); ++i) {
            VertexFormatElement element = (VertexFormatElement)format.m_86023_().get(i);
            switch (element.m_86048_()) {
                case POSITION: {
                    ret[i][0] = (float)this.pos.m_7096_();
                    ret[i][1] = (float)this.pos.m_7098_();
                    ret[i][2] = (float)this.pos.m_7094_();
                    continue block6;
                }
                case NORMAL: {
                    ret[i][0] = (float)this.normal.m_7096_();
                    ret[i][1] = (float)this.normal.m_7098_();
                    ret[i][2] = (float)this.normal.m_7094_();
                    continue block6;
                }
                case COLOR: {
                    ret[i][0] = this.color.rf();
                    ret[i][1] = this.color.gf();
                    ret[i][2] = this.color.bf();
                    ret[i][3] = this.color.af();
                    continue block6;
                }
                case UV: {
                    if (element.m_86049_() == 0) {
                        ret[i][0] = this.texU;
                        ret[i][1] = this.texV;
                        continue block6;
                    }
                    if (element.m_86049_() != 2) continue block6;
                    ret[i][0] = this.lightU;
                    ret[i][1] = this.lightV;
                    continue block6;
                }
            }
        }
        return ret;
    }
}

