/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.Arrays;
import javax.annotation.Nullable;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.util.EnumUtils;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;

public class RenderResizableCuboid {
    private static final int[] combinedARGB = new int[EnumUtils.DIRECTIONS.length];
    private static final Vector3f NORMAL = new Vector3f(1.0f, 1.0f, 1.0f);

    private RenderResizableCuboid() {
    }

    public static void renderCube(MekanismRenderer.Model3D cube, PoseStack matrix, VertexConsumer buffer, int argb, int light, int overlay, FaceDisplay faceDisplay, boolean fakeDisableDiffuse) {
        Arrays.fill(combinedARGB, argb);
        RenderResizableCuboid.renderCube(cube, matrix, buffer, combinedARGB, light, overlay, faceDisplay, fakeDisableDiffuse);
    }

    public static void renderCube(MekanismRenderer.Model3D cube, PoseStack matrix, VertexConsumer buffer, int[] colors, int light, int overlay, FaceDisplay faceDisplay, boolean fakeDisableDiffuse) {
        float xShift = Mth.m_14143_((float)cube.minX);
        float yShift = Mth.m_14143_((float)cube.minY);
        float zShift = Mth.m_14143_((float)cube.minZ);
        matrix.m_85836_();
        matrix.m_85837_((double)xShift, (double)yShift, (double)zShift);
        float minX = cube.minX - xShift;
        float minY = cube.minY - yShift;
        float minZ = cube.minZ - zShift;
        float maxX = cube.maxX - xShift;
        float maxY = cube.maxY - yShift;
        float maxZ = cube.maxZ - zShift;
        int xDelta = RenderResizableCuboid.calculateDelta(minX, maxX);
        int yDelta = RenderResizableCuboid.calculateDelta(minY, maxY);
        int zDelta = RenderResizableCuboid.calculateDelta(minZ, maxZ);
        float[] xBounds = RenderResizableCuboid.getBlockBounds(xDelta, minX, maxX);
        float[] yBounds = RenderResizableCuboid.getBlockBounds(yDelta, minY, maxY);
        float[] zBounds = RenderResizableCuboid.getBlockBounds(zDelta, minZ, maxZ);
        PoseStack.Pose lastMatrix = matrix.m_85850_();
        Matrix4f matrix4f = lastMatrix.m_85861_();
        Matrix3f normalMatrix = lastMatrix.m_85864_();
        Vector3f normal = fakeDisableDiffuse ? NORMAL : Vector3f.f_122225_;
        Vector3f from = new Vector3f();
        Vector3f to = new Vector3f();
        for (int y = 0; y <= yDelta; ++y) {
            MekanismRenderer.Model3D.SpriteInfo upSprite = y == yDelta ? cube.getSpriteToRender(Direction.UP) : null;
            MekanismRenderer.Model3D.SpriteInfo downSprite = y == 0 ? cube.getSpriteToRender(Direction.DOWN) : null;
            from.setY(yBounds[y]);
            to.setY(yBounds[y + 1]);
            for (int z = 0; z <= zDelta; ++z) {
                MekanismRenderer.Model3D.SpriteInfo northSprite = z == 0 ? cube.getSpriteToRender(Direction.NORTH) : null;
                MekanismRenderer.Model3D.SpriteInfo southSprite = z == zDelta ? cube.getSpriteToRender(Direction.SOUTH) : null;
                from.setZ(zBounds[z]);
                to.setZ(zBounds[z + 1]);
                for (int x = 0; x <= xDelta; ++x) {
                    MekanismRenderer.Model3D.SpriteInfo westSprite = x == 0 ? cube.getSpriteToRender(Direction.WEST) : null;
                    MekanismRenderer.Model3D.SpriteInfo eastSprite = x == xDelta ? cube.getSpriteToRender(Direction.EAST) : null;
                    from.setX(xBounds[x]);
                    to.setX(xBounds[x + 1]);
                    RenderResizableCuboid.putTexturedQuad(buffer, matrix4f, normalMatrix, westSprite, from, to, Direction.WEST, colors, light, overlay, faceDisplay, normal);
                    RenderResizableCuboid.putTexturedQuad(buffer, matrix4f, normalMatrix, eastSprite, from, to, Direction.EAST, colors, light, overlay, faceDisplay, normal);
                    RenderResizableCuboid.putTexturedQuad(buffer, matrix4f, normalMatrix, northSprite, from, to, Direction.NORTH, colors, light, overlay, faceDisplay, normal);
                    RenderResizableCuboid.putTexturedQuad(buffer, matrix4f, normalMatrix, southSprite, from, to, Direction.SOUTH, colors, light, overlay, faceDisplay, normal);
                    RenderResizableCuboid.putTexturedQuad(buffer, matrix4f, normalMatrix, upSprite, from, to, Direction.UP, colors, light, overlay, faceDisplay, normal);
                    RenderResizableCuboid.putTexturedQuad(buffer, matrix4f, normalMatrix, downSprite, from, to, Direction.DOWN, colors, light, overlay, faceDisplay, normal);
                }
            }
        }
        matrix.m_85849_();
    }

    private static float[] getBlockBounds(int delta, float start, float end) {
        float[] bounds = new float[2 + delta];
        bounds[0] = start;
        int offset = (int)start;
        for (int i = 1; i <= delta; ++i) {
            bounds[i] = i + offset;
        }
        bounds[delta + 1] = end;
        return bounds;
    }

    private static int calculateDelta(float min, float max) {
        int delta = (int)(max - (float)((int)min));
        if ((double)max % 1.0 == 0.0) {
            --delta;
        }
        return delta;
    }

    private static void putTexturedQuad(VertexConsumer buffer, Matrix4f matrix, Matrix3f normalMatrix, @Nullable MekanismRenderer.Model3D.SpriteInfo spriteInfo, Vector3f from, Vector3f to, Direction face, int[] colors, int light, int overlay, FaceDisplay faceDisplay, Vector3f normal) {
        float v1;
        float u2;
        float u1;
        if (spriteInfo == null) {
            return;
        }
        float x1 = from.m_122239_();
        float y1 = from.m_122260_();
        float z1 = from.m_122269_();
        float x2 = to.m_122239_();
        float y2 = to.m_122260_();
        float z2 = to.m_122269_();
        float v2 = switch (face.m_122434_()) {
            case Direction.Axis.Z -> {
                u1 = x2;
                u2 = x1;
                v1 = y1;
                yield y2;
            }
            case Direction.Axis.X -> {
                u1 = z2;
                u2 = z1;
                v1 = y1;
                yield y2;
            }
            default -> {
                u1 = x1;
                u2 = x2;
                v1 = z2;
                yield z1;
            }
        };
        boolean bigger = u1 > u2;
        u1 %= 1.0f;
        u2 %= 1.0f;
        if (bigger) {
            if (u1 == 0.0f) {
                u1 = 1.0f;
            }
        } else if (u2 == 0.0f) {
            u2 = 1.0f;
        }
        bigger = v1 > v2;
        v1 %= 1.0f;
        v2 %= 1.0f;
        if (bigger) {
            if (v1 == 0.0f) {
                v1 = 1.0f;
            }
        } else if (v2 == 0.0f) {
            v2 = 1.0f;
        }
        float temp = v1;
        v1 = 1.0f - v2;
        v2 = 1.0f - temp;
        float minU = spriteInfo.sprite().m_118367_((double)(u1 * (float)spriteInfo.size()));
        float maxU = spriteInfo.sprite().m_118367_((double)(u2 * (float)spriteInfo.size()));
        float minV = spriteInfo.sprite().m_118393_((double)(v1 * (float)spriteInfo.size()));
        float maxV = spriteInfo.sprite().m_118393_((double)(v2 * (float)spriteInfo.size()));
        int argb = colors[face.ordinal()];
        float red = MekanismRenderer.getRed(argb);
        float green = MekanismRenderer.getGreen(argb);
        float blue = MekanismRenderer.getBlue(argb);
        float alpha = MekanismRenderer.getAlpha(argb);
        switch (face) {
            case DOWN: {
                RenderResizableCuboid.drawFace(buffer, matrix, normalMatrix, red, green, blue, alpha, minU, maxU, minV, maxV, light, overlay, faceDisplay, normal, x1, y1, z2, x1, y1, z1, x2, y1, z1, x2, y1, z2);
                break;
            }
            case UP: {
                RenderResizableCuboid.drawFace(buffer, matrix, normalMatrix, red, green, blue, alpha, minU, maxU, minV, maxV, light, overlay, faceDisplay, normal, x1, y2, z1, x1, y2, z2, x2, y2, z2, x2, y2, z1);
                break;
            }
            case NORTH: {
                RenderResizableCuboid.drawFace(buffer, matrix, normalMatrix, red, green, blue, alpha, minU, maxU, minV, maxV, light, overlay, faceDisplay, normal, x1, y1, z1, x1, y2, z1, x2, y2, z1, x2, y1, z1);
                break;
            }
            case SOUTH: {
                RenderResizableCuboid.drawFace(buffer, matrix, normalMatrix, red, green, blue, alpha, minU, maxU, minV, maxV, light, overlay, faceDisplay, normal, x2, y1, z2, x2, y2, z2, x1, y2, z2, x1, y1, z2);
                break;
            }
            case WEST: {
                RenderResizableCuboid.drawFace(buffer, matrix, normalMatrix, red, green, blue, alpha, minU, maxU, minV, maxV, light, overlay, faceDisplay, normal, x1, y1, z2, x1, y2, z2, x1, y2, z1, x1, y1, z1);
                break;
            }
            case EAST: {
                RenderResizableCuboid.drawFace(buffer, matrix, normalMatrix, red, green, blue, alpha, minU, maxU, minV, maxV, light, overlay, faceDisplay, normal, x2, y1, z1, x2, y2, z1, x2, y2, z2, x2, y1, z2);
            }
        }
    }

    private static void drawFace(VertexConsumer buffer, Matrix4f matrix, Matrix3f normalMatrix, float red, float green, float blue, float alpha, float minU, float maxU, float minV, float maxV, int light, int overlay, FaceDisplay faceDisplay, Vector3f normal, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        if (faceDisplay.front) {
            buffer.m_85982_(matrix, x1, y1, z1).m_85950_(red, green, blue, alpha).m_7421_(minU, maxV).m_86008_(overlay).m_85969_(light).m_85977_(normalMatrix, normal.m_122239_(), normal.m_122260_(), normal.m_122269_()).m_5752_();
            buffer.m_85982_(matrix, x2, y2, z2).m_85950_(red, green, blue, alpha).m_7421_(minU, minV).m_86008_(overlay).m_85969_(light).m_85977_(normalMatrix, normal.m_122239_(), normal.m_122260_(), normal.m_122269_()).m_5752_();
            buffer.m_85982_(matrix, x3, y3, z3).m_85950_(red, green, blue, alpha).m_7421_(maxU, minV).m_86008_(overlay).m_85969_(light).m_85977_(normalMatrix, normal.m_122239_(), normal.m_122260_(), normal.m_122269_()).m_5752_();
            buffer.m_85982_(matrix, x4, y4, z4).m_85950_(red, green, blue, alpha).m_7421_(maxU, maxV).m_86008_(overlay).m_85969_(light).m_85977_(normalMatrix, normal.m_122239_(), normal.m_122260_(), normal.m_122269_()).m_5752_();
        }
        if (faceDisplay.back) {
            buffer.m_85982_(matrix, x4, y4, z4).m_85950_(red, green, blue, alpha).m_7421_(maxU, maxV).m_86008_(overlay).m_85969_(light).m_85977_(normalMatrix, 0.0f, -1.0f, 0.0f).m_5752_();
            buffer.m_85982_(matrix, x3, y3, z3).m_85950_(red, green, blue, alpha).m_7421_(maxU, minV).m_86008_(overlay).m_85969_(light).m_85977_(normalMatrix, 0.0f, -1.0f, 0.0f).m_5752_();
            buffer.m_85982_(matrix, x2, y2, z2).m_85950_(red, green, blue, alpha).m_7421_(minU, minV).m_86008_(overlay).m_85969_(light).m_85977_(normalMatrix, 0.0f, -1.0f, 0.0f).m_5752_();
            buffer.m_85982_(matrix, x1, y1, z1).m_85950_(red, green, blue, alpha).m_7421_(minU, maxV).m_86008_(overlay).m_85969_(light).m_85977_(normalMatrix, 0.0f, -1.0f, 0.0f).m_5752_();
        }
    }

    static {
        NORMAL.m_122278_();
    }

    public static enum FaceDisplay {
        FRONT(true, false),
        BACK(false, true),
        BOTH(true, true);

        private final boolean front;
        private final boolean back;

        private FaceDisplay(boolean front, boolean back) {
            this.front = front;
            this.back = back;
        }
    }
}

