/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.particle;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import javax.annotation.Nonnull;
import mekanism.common.lib.math.Pos3D;
import mekanism.common.particle.LaserParticleData;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class LaserParticle
extends TextureSheetParticle {
    private static final ParticleRenderType LASER_TYPE = new ParticleRenderType(){

        public void m_6505_(@Nonnull BufferBuilder buffer, @Nonnull TextureManager manager) {
            RenderSystem.m_69464_();
            ParticleRenderType.f_107431_.m_6505_(buffer, manager);
        }

        public void m_6294_(@Nonnull Tesselator tesselator) {
            ParticleRenderType.f_107431_.m_6294_(tesselator);
        }

        public String toString() {
            return "MEK_LASER_PARTICLE_TYPE";
        }
    };
    private static final float RADIAN_45 = (float)Math.toRadians(45.0);
    private static final float RADIAN_90 = (float)Math.toRadians(90.0);
    private final Direction direction;
    private final float halfLength;

    private LaserParticle(ClientLevel world, Vec3 start, Vec3 end, Direction dir, float energyScale) {
        super(world, (start.f_82479_ + end.f_82479_) / 2.0, (start.f_82480_ + end.f_82480_) / 2.0, (start.f_82481_ + end.f_82481_) / 2.0);
        this.f_107225_ = 5;
        this.f_107227_ = 1.0f;
        this.f_107228_ = 0.0f;
        this.f_107229_ = 0.0f;
        this.f_107230_ = 0.11f;
        this.f_107663_ = energyScale;
        this.halfLength = (float)(end.m_82554_(start) / 2.0);
        this.direction = dir;
        this.updateBoundingBox();
    }

    public void m_5744_(@Nonnull VertexConsumer vertexBuilder, Camera renderInfo, float partialTicks) {
        Vec3 view = renderInfo.m_90583_();
        float newX = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - view.m_7096_());
        float newY = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - view.m_7098_());
        float newZ = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - view.m_7094_());
        float uMin = this.m_5970_();
        float uMax = this.m_5952_();
        float vMin = this.m_5951_();
        float vMax = this.m_5950_();
        Quaternion quaternion = this.direction.m_122406_();
        quaternion.m_80148_(Vector3f.f_122225_.m_122270_(RADIAN_45));
        this.drawComponent(vertexBuilder, this.getResultVector(quaternion, newX, newY, newZ), uMin, uMax, vMin, vMax);
        Quaternion quaternion2 = new Quaternion(quaternion);
        quaternion2.m_80148_(Vector3f.f_122225_.m_122270_(RADIAN_90));
        this.drawComponent(vertexBuilder, this.getResultVector(quaternion2, newX, newY, newZ), uMin, uMax, vMin, vMax);
    }

    private Vector3f[] getResultVector(Quaternion quaternion, float newX, float newY, float newZ) {
        Vector3f[] resultVector;
        for (Vector3f vec : resultVector = new Vector3f[]{new Vector3f(-this.f_107663_, -this.halfLength, 0.0f), new Vector3f(-this.f_107663_, this.halfLength, 0.0f), new Vector3f(this.f_107663_, this.halfLength, 0.0f), new Vector3f(this.f_107663_, -this.halfLength, 0.0f)}) {
            vec.m_122251_(quaternion);
            vec.m_122272_(newX, newY, newZ);
        }
        return resultVector;
    }

    private void drawComponent(VertexConsumer vertexBuilder, Vector3f[] resultVector, float uMin, float uMax, float vMin, float vMax) {
        vertexBuilder.m_5483_((double)resultVector[0].m_122239_(), (double)resultVector[0].m_122260_(), (double)resultVector[0].m_122269_()).m_7421_(uMax, vMax).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_7120_(240, 240).m_5752_();
        vertexBuilder.m_5483_((double)resultVector[1].m_122239_(), (double)resultVector[1].m_122260_(), (double)resultVector[1].m_122269_()).m_7421_(uMax, vMin).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_7120_(240, 240).m_5752_();
        vertexBuilder.m_5483_((double)resultVector[2].m_122239_(), (double)resultVector[2].m_122260_(), (double)resultVector[2].m_122269_()).m_7421_(uMin, vMin).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_7120_(240, 240).m_5752_();
        vertexBuilder.m_5483_((double)resultVector[3].m_122239_(), (double)resultVector[3].m_122260_(), (double)resultVector[3].m_122269_()).m_7421_(uMin, vMax).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_7120_(240, 240).m_5752_();
    }

    @Nonnull
    public ParticleRenderType m_7556_() {
        return LASER_TYPE;
    }

    protected void m_107250_(float particleWidth, float particleHeight) {
        if (particleWidth != this.f_107221_ || particleHeight != this.f_107222_) {
            this.f_107221_ = particleWidth;
            this.f_107222_ = particleHeight;
        }
    }

    public void m_107264_(double x, double y, double z) {
        this.f_107212_ = x;
        this.f_107213_ = y;
        this.f_107214_ = z;
        if (this.direction != null) {
            this.updateBoundingBox();
        }
    }

    private void updateBoundingBox() {
        float halfDiameter = this.f_107663_ / 2.0f;
        switch (this.direction) {
            case DOWN: 
            case UP: {
                this.m_107259_(new AABB(this.f_107212_ - (double)halfDiameter, this.f_107213_ - (double)this.halfLength, this.f_107214_ - (double)halfDiameter, this.f_107212_ + (double)halfDiameter, this.f_107213_ + (double)this.halfLength, this.f_107214_ + (double)halfDiameter));
                break;
            }
            case NORTH: 
            case SOUTH: {
                this.m_107259_(new AABB(this.f_107212_ - (double)halfDiameter, this.f_107213_ - (double)halfDiameter, this.f_107214_ - (double)this.halfLength, this.f_107212_ + (double)halfDiameter, this.f_107213_ + (double)halfDiameter, this.f_107214_ + (double)this.halfLength));
                break;
            }
            case WEST: 
            case EAST: {
                this.m_107259_(new AABB(this.f_107212_ - (double)this.halfLength, this.f_107213_ - (double)halfDiameter, this.f_107214_ - (double)halfDiameter, this.f_107212_ + (double)this.halfLength, this.f_107213_ + (double)halfDiameter, this.f_107214_ + (double)halfDiameter));
            }
        }
    }

    public static class Factory
    implements ParticleProvider<LaserParticleData> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public LaserParticle createParticle(LaserParticleData data, @Nonnull ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            Pos3D start = new Pos3D(x, y, z);
            Pos3D end = start.translate(data.direction(), data.distance());
            LaserParticle particleLaser = new LaserParticle(world, start, end, data.direction(), data.energyScale());
            particleLaser.m_108335_(this.spriteSet);
            return particleLaser;
        }
    }
}

