/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.item;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Set;
import javax.annotation.Nonnull;
import mekanism.api.text.ILangEntry;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.element.GuiDropdown;
import mekanism.client.gui.element.custom.GuiDictionaryTarget;
import mekanism.client.gui.element.scroll.GuiTextScrollList;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.GuiComponents;
import mekanism.common.inventory.container.item.DictionaryContainer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class GuiDictionary
extends GuiMekanism<DictionaryContainer> {
    private GuiTextScrollList scrollList;
    private GuiDictionaryTarget target;
    private DictionaryTagType currentType = DictionaryTagType.ITEM;

    public GuiDictionary(DictionaryContainer container, Inventory inv, Component title) {
        super(container, inv, title);
        this.f_97727_ += 5;
        this.f_97731_ = this.f_97727_ - 96;
        this.f_97729_ = 5;
        this.dynamicSlots = true;
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.addRenderableWidget(new GuiSlot(SlotType.NORMAL, this, 5, 5).setRenderHover(true));
        this.scrollList = this.addRenderableWidget(new GuiTextScrollList(this, 7, 29, 162, 42));
        this.addRenderableWidget(new GuiDropdown<DictionaryTagType>(this, 124, 73, 45, DictionaryTagType.class, () -> this.currentType, this::setCurrentType));
        this.target = this.addRenderableWidget(new GuiDictionaryTarget(this, 6, 6, this::updateScrollList));
    }

    private void setCurrentType(DictionaryTagType type) {
        this.currentType = type;
        this.scrollList.setText(this.target.getTags(this.currentType));
    }

    private void updateScrollList(Set<DictionaryTagType> supportedTypes) {
        if (!supportedTypes.contains(this.currentType) && !supportedTypes.isEmpty()) {
            this.currentType = supportedTypes.stream().findFirst().orElse(this.currentType);
        }
        this.scrollList.setText(this.target.getTags(this.currentType));
    }

    @Override
    protected void drawForegroundText(@Nonnull PoseStack matrix, int mouseX, int mouseY) {
        this.renderTitleText(matrix);
        this.drawString(matrix, this.f_169604_, this.f_97730_, this.f_97731_, this.titleTextColor());
        this.drawTextScaledBound(matrix, (Component)MekanismLang.DICTIONARY_TAG_TYPE.translate(new Object[0]), 77.0f, this.f_97731_, this.titleTextColor(), 45.0f);
        super.drawForegroundText(matrix, mouseX, mouseY);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0 && GuiDictionary.m_96638_() && !this.target.hasTarget()) {
            for (int i = 0; i < ((DictionaryContainer)this.f_97732_).f_38839_.size(); ++i) {
                Slot slot = (Slot)((DictionaryContainer)this.f_97732_).f_38839_.get(i);
                if (!this.isMouseOverSlot(slot, mouseX, mouseY)) continue;
                ItemStack stack = slot.m_7993_();
                if (stack.m_41619_()) break;
                this.target.setTargetSlot(stack, true);
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public static enum DictionaryTagType implements GuiComponents.IDropdownEnum<DictionaryTagType>
    {
        ITEM(MekanismLang.DICTIONARY_ITEM, MekanismLang.DICTIONARY_ITEM_DESC),
        BLOCK(MekanismLang.DICTIONARY_BLOCK, MekanismLang.DICTIONARY_BLOCK_DESC),
        BLOCK_ENTITY_TYPE(MekanismLang.DICTIONARY_BLOCK_ENTITY_TYPE, MekanismLang.DICTIONARY_BLOCK_ENTITY_TYPE_DESC),
        FLUID(MekanismLang.DICTIONARY_FLUID, MekanismLang.DICTIONARY_FLUID_DESC),
        ENTITY_TYPE(MekanismLang.DICTIONARY_ENTITY_TYPE, MekanismLang.DICTIONARY_ENTITY_TYPE_DESC),
        ATTRIBUTE(MekanismLang.DICTIONARY_ATTRIBUTE, MekanismLang.DICTIONARY_ATTRIBUTE_DESC),
        POTION(MekanismLang.DICTIONARY_POTION, MekanismLang.DICTIONARY_POTION_DESC),
        MOB_EFFECT(MekanismLang.DICTIONARY_MOB_EFFECT, MekanismLang.DICTIONARY_MOB_EFFECT_DESC),
        ENCHANTMENT(MekanismLang.DICTIONARY_ENCHANTMENT, MekanismLang.DICTIONARY_ENCHANTMENT_DESC),
        GAS(MekanismLang.DICTIONARY_GAS, MekanismLang.DICTIONARY_GAS_DESC),
        INFUSE_TYPE(MekanismLang.DICTIONARY_INFUSE_TYPE, MekanismLang.DICTIONARY_INFUSE_TYPE_DESC),
        PIGMENT(MekanismLang.DICTIONARY_PIGMENT, MekanismLang.DICTIONARY_PIGMENT_DESC),
        SLURRY(MekanismLang.DICTIONARY_SLURRY, MekanismLang.DICTIONARY_SLURRY_DESC);

        private final ILangEntry name;
        private final ILangEntry tooltip;

        private DictionaryTagType(ILangEntry name, ILangEntry tooltip) {
            this.name = name;
            this.tooltip = tooltip;
        }

        @Override
        public Component getTooltip() {
            return this.tooltip.translate(new Object[0]);
        }

        @Override
        public Component getShortName() {
            return this.name.translate(new Object[0]);
        }
    }
}

