/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.tab;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import mekanism.api.text.TextComponentUtil;
import mekanism.client.SpecialColors;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInsetElement;
import mekanism.client.gui.element.window.GuiSideConfiguration;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.util.MekanismUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class GuiConfigTypeTab
extends GuiInsetElement<Void> {
    private final TransmissionType transmission;
    private final GuiSideConfiguration<?> config;

    public GuiConfigTypeTab(IGuiWrapper gui, TransmissionType type, int x, int y, GuiSideConfiguration<?> config, boolean left) {
        super(GuiConfigTypeTab.getResource(type), gui, null, x, y, 26, 18, left);
        this.config = config;
        this.transmission = type;
    }

    private static ResourceLocation getResource(TransmissionType t) {
        return MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, t.getTransmission() + ".png");
    }

    public TransmissionType getTransmissionType() {
        return this.transmission;
    }

    @Override
    protected void colorTab() {
        switch (this.transmission) {
            case ENERGY: {
                MekanismRenderer.color(SpecialColors.TAB_ENERGY_CONFIG);
                break;
            }
            case FLUID: {
                MekanismRenderer.color(SpecialColors.TAB_FLUID_CONFIG);
                break;
            }
            case GAS: {
                MekanismRenderer.color(SpecialColors.TAB_GAS_CONFIG);
                break;
            }
            case INFUSION: {
                MekanismRenderer.color(SpecialColors.TAB_INFUSION_CONFIG);
                break;
            }
            case PIGMENT: {
                MekanismRenderer.color(SpecialColors.TAB_PIGMENT_CONFIG);
                break;
            }
            case SLURRY: {
                MekanismRenderer.color(SpecialColors.TAB_SLURRY_CONFIG);
                break;
            }
            case ITEM: {
                MekanismRenderer.color(SpecialColors.TAB_ITEM_CONFIG);
                break;
            }
            case HEAT: {
                MekanismRenderer.color(SpecialColors.TAB_HEAT_CONFIG);
            }
        }
    }

    @Override
    public void m_7428_(@Nonnull PoseStack matrix, int mouseX, int mouseY) {
        super.m_7428_(matrix, mouseX, mouseY);
        this.displayTooltips(matrix, mouseX, mouseY, new Component[]{TextComponentUtil.build(this.transmission)});
    }

    public void m_5716_(double mouseX, double mouseY) {
        this.config.setCurrentType(this.transmission);
        this.config.updateTabs();
    }
}

