/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.graph;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import javax.annotation.Nonnull;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.GuiTexturedElement;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.util.MekanismUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public abstract class GuiGraph<COLLECTION extends Collection<?>, HANDLER extends GraphDataHandler>
extends GuiTexturedElement {
    private static final int TEXTURE_WIDTH = 3;
    private static final int TEXTURE_HEIGHT = 2;
    protected final COLLECTION graphData;
    protected final HANDLER dataHandler;
    protected boolean fixedScale = false;

    protected GuiGraph(IGuiWrapper gui, int x, int y, int width, int height, COLLECTION graphData, HANDLER handler) {
        super(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "graph.png"), gui, x, y, width, height);
        this.graphData = graphData;
        this.dataHandler = handler;
    }

    @Override
    public void drawBackground(@Nonnull PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(matrix, mouseX, mouseY, partialTicks);
        this.renderBackgroundTexture(matrix, GuiInnerScreen.SCREEN, GuiInnerScreen.SCREEN_SIZE, GuiInnerScreen.SCREEN_SIZE);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getResource());
        int size = this.graphData.size();
        int x = this.f_93620_ + 1;
        int y = this.f_93621_ + 1;
        int height = this.f_93619_ - 2;
        for (int i = 0; i < size; ++i) {
            int relativeHeight = this.getRelativeHeight(i, height);
            GuiGraph.m_93133_((PoseStack)matrix, (int)(x + i), (int)(y + height - relativeHeight), (float)0.0f, (float)0.0f, (int)1, (int)1, (int)3, (int)2);
            RenderSystem.m_69478_();
            RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.2f + 0.8f * (float)i / (float)size));
            GuiGraph.m_93133_((PoseStack)matrix, (int)(x + i), (int)(y + height - relativeHeight), (float)1.0f, (float)0.0f, (int)1, (int)relativeHeight, (int)3, (int)2);
            int hoverIndex = mouseX - this.getButtonX();
            if (hoverIndex == i && mouseY >= this.getButtonY() && mouseY < this.getButtonY() + height) {
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                GuiGraph.m_93133_((PoseStack)matrix, (int)(x + i), (int)y, (float)2.0f, (float)0.0f, (int)1, (int)height, (int)3, (int)2);
                MekanismRenderer.resetColor();
                GuiGraph.m_93133_((PoseStack)matrix, (int)(x + i), (int)(y + height - relativeHeight), (float)0.0f, (float)1.0f, (int)1, (int)1, (int)3, (int)2);
            }
            MekanismRenderer.resetColor();
            RenderSystem.m_69461_();
        }
    }

    protected abstract int getRelativeHeight(int var1, int var2);

    protected abstract Component getDataDisplay(int var1);

    @Override
    public void m_7428_(@Nonnull PoseStack matrix, int mouseX, int mouseY) {
        super.m_7428_(matrix, mouseX, mouseY);
        int hoverIndex = mouseX - this.f_93620_;
        if (hoverIndex >= 0 && hoverIndex < this.graphData.size()) {
            this.displayTooltips(matrix, mouseX, mouseY, this.getDataDisplay(hoverIndex));
        }
    }

    public static interface GraphDataHandler {
    }
}

