/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.button;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.button.MekanismButton;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public class ColorButton
extends MekanismButton {
    private final Supplier<EnumColor> colorSupplier;

    public ColorButton(IGuiWrapper gui, int x, int y, int width, int height, Supplier<EnumColor> colorSupplier, Runnable onPress, Runnable onRightClick) {
        super(gui, x, y, width, height, TextComponent.f_131282_, onPress, onRightClick, (onHover, matrix, mouseX, mouseY) -> {
            EnumColor color = (EnumColor)colorSupplier.get();
            if (color != null) {
                gui.displayTooltips(matrix, mouseX, mouseY, color.getColoredName());
            } else {
                gui.displayTooltips(matrix, mouseX, mouseY, new Component[]{MekanismLang.NONE.translate(new Object[0])});
            }
        });
        this.colorSupplier = colorSupplier;
    }

    @Override
    public void drawBackground(@Nonnull PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        EnumColor color = this.colorSupplier.get();
        if (color != null) {
            ColorButton.m_93172_((PoseStack)matrix, (int)this.f_93620_, (int)this.f_93621_, (int)(this.f_93620_ + this.f_93618_), (int)(this.f_93621_ + this.f_93619_), (int)MekanismRenderer.getColorARGB(color, 1.0f));
            MekanismRenderer.resetColor();
        }
    }
}

