/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import mekanism.api.MekanismAPI;
import mekanism.api.gear.IModule;
import mekanism.api.math.FloatingLong;
import mekanism.client.MekanismClient;
import mekanism.client.gui.GuiRadialSelector;
import mekanism.client.key.MekKeyHandler;
import mekanism.client.render.RenderTickHandler;
import mekanism.client.sound.GeigerSound;
import mekanism.client.sound.SoundHandler;
import mekanism.common.CommonPlayerTickHandler;
import mekanism.common.Mekanism;
import mekanism.common.base.HolidayManager;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.gear.mekasuit.ModuleJetpackUnit;
import mekanism.common.content.gear.mekasuit.ModuleVisionEnhancementUnit;
import mekanism.common.item.gear.ItemFlamethrower;
import mekanism.common.item.gear.ItemHDPEElytra;
import mekanism.common.item.gear.ItemJetpack;
import mekanism.common.item.gear.ItemMekaSuitArmor;
import mekanism.common.item.interfaces.IModeItem;
import mekanism.common.item.interfaces.IRadialModeItem;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.radiation.RadiationManager;
import mekanism.common.network.to_server.PacketModeChange;
import mekanism.common.network.to_server.PacketPortableTeleporterTeleport;
import mekanism.common.network.to_server.PacketRadialModeChange;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.registries.MekanismModules;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.ArmorStandModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ClientTickHandler {
    public static final Minecraft minecraft = Minecraft.m_91087_();
    public static final Random rand = new Random();
    public static final Map<Player, TeleportData> portableTeleports = new Object2ObjectArrayMap(1);
    public boolean initHoliday = false;
    public boolean shouldReset = false;
    public static boolean firstTick = true;
    public static boolean visionEnhancement = false;
    private static long lastScrollTime = -1L;
    private static double scrollDelta;

    public static boolean isJetpackActive(Player player) {
        ItemStack chest;
        if (player != ClientTickHandler.minecraft.f_91074_) {
            return Mekanism.playerState.isJetpackOn(player);
        }
        if (!player.m_5833_() && !(chest = ItemJetpack.getJetpack((LivingEntity)player)).m_41619_()) {
            ItemJetpack.JetpackMode mode = CommonPlayerTickHandler.getJetpackMode(chest);
            if (mode == ItemJetpack.JetpackMode.NORMAL) {
                return ClientTickHandler.minecraft.f_91080_ == null && ClientTickHandler.minecraft.f_91074_.f_108618_.f_108572_;
            }
            if (mode == ItemJetpack.JetpackMode.HOVER) {
                boolean ascending = ClientTickHandler.minecraft.f_91074_.f_108618_.f_108572_;
                boolean descending = ClientTickHandler.minecraft.f_91074_.f_108618_.f_108573_;
                if (!ascending || descending || ClientTickHandler.minecraft.f_91080_ != null) {
                    return !CommonPlayerTickHandler.isOnGroundOrSleeping(player);
                }
                return true;
            }
        }
        return false;
    }

    public static boolean isScubaMaskOn(Player player) {
        if (player != ClientTickHandler.minecraft.f_91074_) {
            return Mekanism.playerState.isScubaMaskOn(player);
        }
        return CommonPlayerTickHandler.isScubaMaskOn(player, player.m_6844_(EquipmentSlot.CHEST));
    }

    public static boolean isGravitationalModulationOn(Player player) {
        if (player != ClientTickHandler.minecraft.f_91074_) {
            return Mekanism.playerState.isGravitationalModulationOn(player);
        }
        return CommonPlayerTickHandler.isGravitationalModulationOn(player);
    }

    public static boolean isVisionEnhancementOn(Player player) {
        IModule<ModuleVisionEnhancementUnit> module = MekanismAPI.getModuleHelper().load(player.m_6844_(EquipmentSlot.HEAD), MekanismModules.VISION_ENHANCEMENT_UNIT);
        return module != null && module.isEnabled() && module.getContainerEnergy().greaterThan((FloatingLong)MekanismConfig.gear.mekaSuitEnergyUsageVisionEnhancement.get());
    }

    public static boolean isFlamethrowerOn(Player player) {
        if (player != ClientTickHandler.minecraft.f_91074_) {
            return Mekanism.playerState.isFlamethrowerOn(player);
        }
        return ClientTickHandler.hasFlamethrower(player) && ClientTickHandler.minecraft.f_91066_.f_92095_.m_90857_();
    }

    public static boolean hasFlamethrower(Player player) {
        ItemStack currentItem = player.m_150109_().m_36056_();
        return !currentItem.m_41619_() && currentItem.m_41720_() instanceof ItemFlamethrower && ChemicalUtil.hasGas(currentItem);
    }

    public static void portableTeleport(Player player, InteractionHand hand, Frequency.FrequencyIdentity identity) {
        int delay = MekanismConfig.gear.portableTeleporterDelay.get();
        if (delay == 0) {
            Mekanism.packetHandler().sendToServer(new PacketPortableTeleporterTeleport(hand, identity));
        } else {
            portableTeleports.put(player, new TeleportData(hand, identity, ClientTickHandler.minecraft.f_91073_.m_46467_() + (long)delay));
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.tickStart();
        }
    }

    public void tickStart() {
        ++MekanismClient.ticksPassed;
        if (firstTick && ClientTickHandler.minecraft.f_91073_ != null) {
            MekanismClient.launchClient();
            firstTick = false;
        }
        if (ClientTickHandler.minecraft.f_91073_ != null) {
            this.shouldReset = true;
        } else if (this.shouldReset) {
            MekanismClient.reset();
            this.shouldReset = false;
        }
        if (ClientTickHandler.minecraft.f_91073_ != null && ClientTickHandler.minecraft.f_91074_ != null && !minecraft.m_91104_()) {
            RadiationManager.RadiationScale scale;
            Item i3;
            Object mode;
            if (!this.initHoliday || MekanismClient.ticksPassed % 1200L == 0L) {
                HolidayManager.notify((Player)Minecraft.m_91087_().f_91074_);
                this.initHoliday = true;
            }
            SoundHandler.restartSounds();
            if (ClientTickHandler.minecraft.f_91073_.m_46467_() - lastScrollTime > 20L) {
                scrollDelta = 0.0;
            }
            RadiationManager.INSTANCE.tickClient((Player)ClientTickHandler.minecraft.f_91074_);
            UUID playerUUID = ClientTickHandler.minecraft.f_91074_.m_142081_();
            Mekanism.playerState.setJetpackState(playerUUID, ClientTickHandler.isJetpackActive((Player)ClientTickHandler.minecraft.f_91074_), true);
            Mekanism.playerState.setScubaMaskState(playerUUID, ClientTickHandler.isScubaMaskOn((Player)ClientTickHandler.minecraft.f_91074_), true);
            Mekanism.playerState.setGravitationalModulationState(playerUUID, ClientTickHandler.isGravitationalModulationOn((Player)ClientTickHandler.minecraft.f_91074_), true);
            Mekanism.playerState.setFlamethrowerState(playerUUID, ClientTickHandler.hasFlamethrower((Player)ClientTickHandler.minecraft.f_91074_), ClientTickHandler.isFlamethrowerOn((Player)ClientTickHandler.minecraft.f_91074_), true);
            Iterator<Map.Entry<Player, TeleportData>> iter = portableTeleports.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<Player, TeleportData> entry = iter.next();
                Player player = entry.getKey();
                for (int i2 = 0; i2 < 100; ++i2) {
                    double x = player.m_20185_() + rand.nextDouble() - 0.5;
                    double y = player.m_20186_() + rand.nextDouble() * 2.0 - 2.0;
                    double z = player.m_20189_() + rand.nextDouble() - 0.5;
                    ClientTickHandler.minecraft.f_91073_.m_7106_((ParticleOptions)ParticleTypes.f_123760_, x, y, z, 0.0, 1.0, 0.0);
                }
                TeleportData data = entry.getValue();
                if (ClientTickHandler.minecraft.f_91073_.m_46467_() != data.teleportTime) continue;
                Mekanism.packetHandler().sendToServer(new PacketPortableTeleporterTeleport(data.hand, data.identity));
                iter.remove();
            }
            ItemStack chestStack = ClientTickHandler.minecraft.f_91074_.m_6844_(EquipmentSlot.CHEST);
            IModule<ModuleJetpackUnit> jetpackModule = MekanismAPI.getModuleHelper().load(chestStack, MekanismModules.JETPACK_UNIT);
            ItemStack jetpack = ItemJetpack.getJetpack((LivingEntity)ClientTickHandler.minecraft.f_91074_, chestStack);
            if (!jetpack.m_41619_() || jetpackModule != null) {
                MekanismClient.updateKey(ClientTickHandler.minecraft.f_91074_.f_108618_.f_108572_, 0);
            }
            if (ClientTickHandler.isJetpackActive((Player)ClientTickHandler.minecraft.f_91074_) && CommonPlayerTickHandler.handleJetpackMotion((Player)ClientTickHandler.minecraft.f_91074_, (ItemJetpack.JetpackMode)(mode = CommonPlayerTickHandler.getJetpackMode(jetpack)), () -> ClientTickHandler.minecraft.f_91074_.f_108618_.f_108572_)) {
                ClientTickHandler.minecraft.f_91074_.f_19789_ = 0.0f;
            }
            if (ClientTickHandler.isScubaMaskOn((Player)ClientTickHandler.minecraft.f_91074_) && ClientTickHandler.minecraft.f_91074_.m_20146_() == ClientTickHandler.minecraft.f_91074_.m_6062_()) {
                for (MobEffectInstance effect : ClientTickHandler.minecraft.f_91074_.m_21220_()) {
                    for (int i3 = 0; i3 < 9; ++i3) {
                        MekanismUtils.speedUpEffectSafely((LivingEntity)ClientTickHandler.minecraft.f_91074_, effect);
                    }
                }
            }
            if (ClientTickHandler.isVisionEnhancementOn((Player)ClientTickHandler.minecraft.f_91074_)) {
                visionEnhancement = true;
                ClientTickHandler.minecraft.f_91074_.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 220, 0, false, false, false));
            } else if (visionEnhancement) {
                visionEnhancement = false;
                MobEffectInstance effect = ClientTickHandler.minecraft.f_91074_.m_21124_(MobEffects.f_19611_);
                if (effect != null && effect.m_19557_() <= 220) {
                    ClientTickHandler.minecraft.f_91074_.m_21195_(MobEffects.f_19611_);
                }
            }
            ItemStack stack = ClientTickHandler.minecraft.f_91074_.m_6844_(EquipmentSlot.MAINHAND);
            if (MekKeyHandler.isRadialPressed() && (i3 = stack.m_41720_()) instanceof IRadialModeItem) {
                IRadialModeItem item = (IRadialModeItem)i3;
                if (ClientTickHandler.minecraft.f_91080_ == null || ClientTickHandler.minecraft.f_91080_ instanceof GuiRadialSelector) {
                    this.updateSelectorRenderer(item);
                }
            } else if (ClientTickHandler.minecraft.f_91080_ instanceof GuiRadialSelector) {
                minecraft.m_91152_(null);
            }
            if (MekanismConfig.client.enablePlayerSounds.get() && (scale = RadiationManager.INSTANCE.getClientScale()) != RadiationManager.RadiationScale.NONE && !SoundHandler.radiationSoundMap.containsKey((Object)scale)) {
                GeigerSound sound = GeigerSound.create((Player)ClientTickHandler.minecraft.f_91074_, scale);
                SoundHandler.radiationSoundMap.put(scale, sound);
                SoundHandler.playSound((SoundInstance)sound);
            }
        }
    }

    private <TYPE extends Enum<TYPE>> void updateSelectorRenderer(IRadialModeItem<TYPE> modeItem) {
        GuiRadialSelector screen;
        Class<TYPE> modeClass = modeItem.getModeClass();
        Screen screen2 = ClientTickHandler.minecraft.f_91080_;
        if (!(screen2 instanceof GuiRadialSelector) || (screen = (GuiRadialSelector)screen2).getEnumClass() != modeClass) {
            minecraft.m_91152_(new GuiRadialSelector<Enum>(modeClass, () -> {
                ItemStack s;
                if (ClientTickHandler.minecraft.f_91074_ != null && (s = ClientTickHandler.minecraft.f_91074_.m_6844_(EquipmentSlot.MAINHAND)).m_41720_() instanceof IRadialModeItem) {
                    return ((IRadialModeItem)s.m_41720_()).getMode(s);
                }
                return modeItem.getDefaultMode();
            }, type -> {
                if (ClientTickHandler.minecraft.f_91074_ != null) {
                    Mekanism.packetHandler().sendToServer(new PacketRadialModeChange(EquipmentSlot.MAINHAND, type.ordinal()));
                }
            }));
        }
    }

    @SubscribeEvent
    public void onMouseEvent(InputEvent.MouseScrollEvent event) {
        if (MekanismConfig.client.allowModeScroll.get() && ClientTickHandler.minecraft.f_91074_ != null && ClientTickHandler.minecraft.f_91074_.m_6144_()) {
            this.handleModeScroll((Event)event, event.getScrollDelta());
        }
    }

    @SubscribeEvent
    public void onGuiMouseEvent(ScreenEvent.MouseScrollEvent.Pre event) {
        if (event.getScreen() instanceof GuiRadialSelector) {
            this.handleModeScroll((Event)event, event.getScrollDelta());
        }
    }

    private void handleModeScroll(Event event, double delta) {
        if (delta != 0.0 && IModeItem.isModeItem((Player)ClientTickHandler.minecraft.f_91074_, EquipmentSlot.MAINHAND)) {
            lastScrollTime = ClientTickHandler.minecraft.f_91073_.m_46467_();
            int shift = (int)(scrollDelta += delta);
            scrollDelta %= 1.0;
            if (shift != 0) {
                RenderTickHandler.modeSwitchTimer = 100;
                Mekanism.packetHandler().sendToServer(new PacketModeChange(EquipmentSlot.MAINHAND, shift));
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onFogLighting(EntityViewRenderEvent.FogColors event) {
        if (visionEnhancement) {
            event.setBlue(0.4f);
            event.setRed(0.4f);
            event.setGreen(0.8f);
        }
    }

    @SubscribeEvent
    public void onFog(EntityViewRenderEvent.RenderFogEvent event) {
        if (visionEnhancement) {
            float fog = 384.0f;
            IModule<ModuleVisionEnhancementUnit> module = MekanismAPI.getModuleHelper().load(ClientTickHandler.minecraft.f_91074_.m_6844_(EquipmentSlot.HEAD), MekanismModules.VISION_ENHANCEMENT_UNIT);
            if (module != null) {
                fog = (float)((double)fog * (Math.pow(module.getInstalledCount(), 1.25) / (double)MekanismModules.VISION_ENHANCEMENT_UNIT.getModuleData().getMaxStackSize()));
            }
            RenderSystem.m_157445_((float)-8.0f);
            RenderSystem.m_157443_((float)(fog * 0.5f));
        }
    }

    @SubscribeEvent
    public void recipesUpdated(RecipesUpdatedEvent event) {
        MekanismRecipeType.clearCache();
    }

    @SubscribeEvent
    public void renderEntityPre(RenderLivingEvent.Pre<?, ?> evt) {
        EntityModel model = evt.getRenderer().m_7200_();
        if (model instanceof HumanoidModel) {
            HumanoidModel humanoidModel = (HumanoidModel)model;
            ClientTickHandler.setModelVisibility(evt.getEntity(), humanoidModel, false);
        }
    }

    @SubscribeEvent
    public void renderEntityPost(RenderLivingEvent.Post<?, ?> evt) {
        EntityModel model = evt.getRenderer().m_7200_();
        if (model instanceof HumanoidModel) {
            HumanoidModel humanoidModel = (HumanoidModel)model;
            ClientTickHandler.setModelVisibility(evt.getEntity(), humanoidModel, true);
        }
    }

    private static void setModelVisibility(LivingEntity entity, HumanoidModel<?> entityModel, boolean showModel) {
        PlayerModel playerModel;
        ItemStack chest;
        if (entity.m_6844_(EquipmentSlot.HEAD).m_41720_() instanceof ItemMekaSuitArmor) {
            entityModel.f_102808_.f_104207_ = showModel;
            entityModel.f_102809_.f_104207_ = showModel;
            if (entityModel instanceof PlayerModel) {
                PlayerModel playerModel2 = (PlayerModel)entityModel;
                playerModel2.f_103379_.f_104207_ = showModel;
            }
        }
        if ((chest = entity.m_6844_(EquipmentSlot.CHEST)).m_41720_() instanceof ItemMekaSuitArmor) {
            entityModel.f_102810_.f_104207_ = showModel;
            if (!(entity instanceof ArmorStand)) {
                entityModel.f_102812_.f_104207_ = showModel;
                entityModel.f_102811_.f_104207_ = showModel;
            }
            if (entityModel instanceof PlayerModel) {
                PlayerModel playerModel3 = (PlayerModel)entityModel;
                playerModel3.f_103373_.f_104207_ = showModel;
                playerModel3.f_103378_.f_104207_ = showModel;
                playerModel3.f_103374_.f_104207_ = showModel;
                playerModel3.f_103375_.f_104207_ = showModel;
            } else if (entityModel instanceof ArmorStandModel) {
                ArmorStandModel armorStandModel = (ArmorStandModel)entityModel;
                armorStandModel.f_170353_.f_104207_ = showModel;
                armorStandModel.f_170354_.f_104207_ = showModel;
                armorStandModel.f_102139_.f_104207_ = showModel;
            }
        } else if (chest.m_41720_() instanceof ItemHDPEElytra && entityModel instanceof PlayerModel) {
            playerModel = (PlayerModel)entityModel;
            playerModel.f_103373_.f_104207_ = showModel;
        }
        if (entity.m_6844_(EquipmentSlot.LEGS).m_41720_() instanceof ItemMekaSuitArmor) {
            entityModel.f_102814_.f_104207_ = showModel;
            entityModel.f_102813_.f_104207_ = showModel;
            if (entityModel instanceof PlayerModel) {
                playerModel = (PlayerModel)entityModel;
                playerModel.f_103376_.f_104207_ = showModel;
                playerModel.f_103377_.f_104207_ = showModel;
            }
        }
    }

    private record TeleportData(InteractionHand hand, Frequency.FrequencyIdentity identity, long teleportTime) {
    }
}

