/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.chemical;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Contract;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class ChemicalToChemicalRecipe<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, INGREDIENT extends ChemicalStackIngredient<CHEMICAL, STACK>>
extends MekanismRecipe
implements Predicate<STACK> {
    private final INGREDIENT input;
    protected final STACK output;

    public ChemicalToChemicalRecipe(ResourceLocation id, INGREDIENT input, STACK output) {
        super(id);
        this.input = (ChemicalStackIngredient)Objects.requireNonNull(input, "Input cannot be null.");
        Objects.requireNonNull(output, "Output cannot be null.");
        if (((ChemicalStack)output).isEmpty()) {
            throw new IllegalArgumentException("Output cannot be empty.");
        }
        this.output = ((ChemicalStack)output).copy();
    }

    @Override
    public boolean test(STACK chemicalStack) {
        return this.input.test(chemicalStack);
    }

    public INGREDIENT getInput() {
        return this.input;
    }

    public List<STACK> getOutputDefinition() {
        return Collections.singletonList(this.output);
    }

    @Contract(value="_ -> new", pure=true)
    public STACK getOutput(STACK input) {
        return (STACK)((ChemicalStack)this.output).copy();
    }

    @Override
    public boolean m_142505_() {
        return this.input.hasNoMatchingInstances();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        this.input.write(buffer);
        ((ChemicalStack)this.output).writeToPacket(buffer);
    }
}

