/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.gear;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.gear.ICustomModule;
import mekanism.api.providers.IItemProvider;
import mekanism.api.providers.IModuleDataProvider;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Rarity;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.registries.ForgeRegistryEntry;

@FieldsAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ModuleData<MODULE extends ICustomModule<MODULE>>
extends ForgeRegistryEntry<ModuleData<?>>
implements IModuleDataProvider<MODULE> {
    private final NonNullSupplier<MODULE> supplier;
    private final IItemProvider itemProvider;
    private final int maxStackSize;
    private final Rarity rarity;
    private final boolean exclusive;
    private final boolean handlesModeChange;
    private final boolean rendersHUD;
    private final boolean noDisable;
    private final boolean disabledByDefault;
    @Nullable
    private String translationKey;
    @Nullable
    private String descriptionTranslationKey;

    public ModuleData(ModuleDataBuilder<MODULE> builder) {
        this.supplier = builder.supplier;
        this.itemProvider = builder.itemProvider;
        this.rarity = builder.rarity;
        this.maxStackSize = builder.maxStackSize;
        this.exclusive = builder.exclusive;
        this.handlesModeChange = builder.handlesModeChange;
        this.rendersHUD = builder.rendersHUD;
        this.noDisable = builder.noDisable;
        this.disabledByDefault = builder.disabledByDefault;
    }

    @Override
    @Nonnull
    public final ModuleData<MODULE> getModuleData() {
        return this;
    }

    @Nonnull
    public final IItemProvider getItemProvider() {
        return this.itemProvider;
    }

    @Nonnull
    public final MODULE get() {
        return (MODULE)((ICustomModule)this.supplier.get());
    }

    public final Rarity getRarity() {
        return this.rarity;
    }

    public final int getMaxStackSize() {
        return this.maxStackSize;
    }

    public final boolean isExclusive() {
        return this.exclusive;
    }

    public final boolean handlesModeChange() {
        return this.handlesModeChange;
    }

    public final boolean rendersHUD() {
        return this.rendersHUD;
    }

    public final boolean isNoDisable() {
        return this.noDisable;
    }

    public final boolean isDisabledByDefault() {
        return this.disabledByDefault;
    }

    @Override
    public String getTranslationKey() {
        if (this.translationKey == null) {
            this.translationKey = Util.m_137492_((String)"module", (ResourceLocation)this.getRegistryName());
        }
        return this.translationKey;
    }

    public String getDescriptionTranslationKey() {
        if (this.descriptionTranslationKey == null) {
            this.descriptionTranslationKey = Util.m_137492_((String)"description", (ResourceLocation)this.getRegistryName());
        }
        return this.descriptionTranslationKey;
    }

    public static class ModuleDataBuilder<MODULE extends ICustomModule<MODULE>> {
        private static final ICustomModule<?> MARKER_MODULE = new ICustomModule(){};
        private static final NonNullSupplier<ICustomModule<?>> MARKER_MODULE_SUPPLIER = () -> MARKER_MODULE;
        private final NonNullSupplier<MODULE> supplier;
        private final IItemProvider itemProvider;
        private Rarity rarity = Rarity.COMMON;
        private int maxStackSize = 1;
        private boolean exclusive;
        private boolean handlesModeChange;
        private boolean rendersHUD;
        private boolean noDisable;
        private boolean disabledByDefault;

        public static ModuleDataBuilder<?> marker(@Nonnull IItemProvider itemProvider) {
            return new ModuleDataBuilder(MARKER_MODULE_SUPPLIER, itemProvider);
        }

        public static <MODULE extends ICustomModule<MODULE>> ModuleDataBuilder<MODULE> custom(@Nonnull NonNullSupplier<MODULE> customModule, @Nonnull IItemProvider itemProvider) {
            return new ModuleDataBuilder<MODULE>(customModule, itemProvider);
        }

        private ModuleDataBuilder(@Nonnull NonNullSupplier<MODULE> supplier, @Nonnull IItemProvider itemProvider) {
            this.supplier = Objects.requireNonNull(supplier, "Supplier cannot be null.");
            this.itemProvider = Objects.requireNonNull(itemProvider, "Item provider cannot be null.");
        }

        public ModuleDataBuilder<MODULE> rarity(@Nonnull Rarity rarity) {
            this.rarity = Objects.requireNonNull(rarity, "Rarity cannot be null.");
            return this;
        }

        public ModuleDataBuilder<MODULE> maxStackSize(int maxStackSize) {
            if (maxStackSize <= 0) {
                throw new IllegalArgumentException("Max stack size must be at least one.");
            }
            this.maxStackSize = maxStackSize;
            return this;
        }

        public ModuleDataBuilder<MODULE> exclusive() {
            this.exclusive = true;
            return this;
        }

        public ModuleDataBuilder<MODULE> handlesModeChange() {
            this.handlesModeChange = true;
            return this;
        }

        public ModuleDataBuilder<MODULE> rendersHUD() {
            this.rendersHUD = true;
            return this;
        }

        public ModuleDataBuilder<MODULE> noDisable() {
            if (this.disabledByDefault) {
                throw new IllegalStateException("Cannot have a module type that is unable to be disabled and also disabled by default.");
            }
            this.noDisable = true;
            return this;
        }

        public ModuleDataBuilder<MODULE> disabledByDefault() {
            if (this.noDisable) {
                throw new IllegalStateException("Cannot have a module type that is unable to be disabled and also disabled by default.");
            }
            this.disabledByDefault = true;
            return this;
        }
    }
}

