/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.customization.items.v2.audio.editor;

import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.auudio.audio.AudioClip;
import de.keksuccino.auudio.util.UrlUtils;
import de.keksuccino.drippyloadingscreen.customization.helper.ui.UIBase;
import de.keksuccino.drippyloadingscreen.customization.helper.ui.popup.ChooseFilePopup;
import de.keksuccino.drippyloadingscreen.customization.helper.ui.popup.FHNotificationPopup;
import de.keksuccino.drippyloadingscreen.customization.helper.ui.popup.FHTextInputPopup;
import de.keksuccino.drippyloadingscreen.customization.helper.ui.screens.ScrollableScreen;
import de.keksuccino.drippyloadingscreen.customization.items.v2.audio.AudioCustomizationItem;
import de.keksuccino.drippyloadingscreen.customization.items.v2.audio.editor.AudioLayoutEditorElement;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.content.AdvancedTextField;
import de.keksuccino.konkrete.gui.content.scrollarea.ScrollAreaEntry;
import de.keksuccino.konkrete.gui.screens.popup.Popup;
import de.keksuccino.konkrete.gui.screens.popup.PopupHandler;
import de.keksuccino.konkrete.input.CharacterFilter;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import de.keksuccino.konkrete.math.MathUtils;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;

public class EditAudioScreen
extends ScrollableScreen {
    protected AudioCustomizationItem.MenuAudio audio;
    protected AudioLayoutEditorElement parentElement;
    protected Consumer<AudioCustomizationItem.MenuAudio> callback;
    protected boolean isNewAudio = false;
    protected AdvancedButton doneButton;
    protected AdvancedButton cancelButton;

    public EditAudioScreen(Screen parent, AudioLayoutEditorElement parentElement, @Nullable AudioCustomizationItem.MenuAudio audioToEdit, Consumer<AudioCustomizationItem.MenuAudio> callback) {
        super(parent, Locals.localize((String)"drippyloadingscreen.audio.add_or_edit", (String[])new String[0]));
        this.parentElement = parentElement;
        this.audio = audioToEdit;
        if (this.audio == null) {
            this.isNewAudio = true;
            this.audio = new AudioCustomizationItem.MenuAudio(null, AudioClip.SoundType.EXTERNAL_LOCAL, (AudioCustomizationItem)this.parentElement.object);
        }
        this.callback = callback;
    }

    @Override
    public boolean isOverlayButtonHovered() {
        if (this.doneButton != null && this.doneButton.m_198029_()) {
            return true;
        }
        return this.cancelButton != null && this.cancelButton.m_198029_();
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        ArrayList oldEntries = new ArrayList();
        oldEntries.addAll(this.scrollArea.getEntries());
        for (ScrollAreaEntry e : oldEntries) {
            this.scrollArea.removeEntry(e);
        }
        this.scrollArea.addEntry((ScrollAreaEntry)new ScrollableScreen.EmptySpaceEntry(this.scrollArea, 10));
        AdvancedButton chooseSourceButton = new AdvancedButton(0, 0, 200, 20, Locals.localize((String)"drippyloadingscreen.audio.choosesource", (String[])new String[0]), true, press -> {
            if (this.audio.soundType == AudioClip.SoundType.EXTERNAL_LOCAL) {
                ChooseFilePopup p = new ChooseFilePopup(call -> {
                    if (call != null) {
                        File f = new File((String)call);
                        if (f.isFile() && f.getPath().toLowerCase().endsWith(".ogg")) {
                            this.audio.path = call;
                        } else {
                            FHNotificationPopup p2 = new FHNotificationPopup(300, new Color(0, 0, 0, 0), 240, null, StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.audio.choosesource.file.invalid", (String[])new String[0]), (String)"%n%"));
                            PopupHandler.displayPopup((Popup)p2);
                        }
                    }
                }, "ogg");
                if (this.audio.path != null) {
                    p.setText(this.audio.path);
                }
                PopupHandler.displayPopup((Popup)p);
            } else if (this.audio.soundType == AudioClip.SoundType.EXTERNAL_WEB) {
                FHTextInputPopup p = new FHTextInputPopup(new Color(0, 0, 0, 0), Locals.localize((String)"drippyloadingscreen.audio.choosesource.url", (String[])new String[0]), null, 240, call -> {
                    if (call != null) {
                        if (UrlUtils.isValidUrl((String)call)) {
                            this.audio.path = call;
                        } else {
                            FHNotificationPopup p2 = new FHNotificationPopup(300, new Color(0, 0, 0, 0), 240, null, StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.audio.choosesource.url.invalid", (String[])new String[0]), (String)"%n%"));
                            PopupHandler.displayPopup((Popup)p2);
                        }
                    }
                });
                if (this.audio.path != null) {
                    p.setText(this.audio.path);
                }
                PopupHandler.displayPopup((Popup)p);
            }
        });
        this.scrollArea.addEntry((ScrollAreaEntry)new ScrollableScreen.ButtonEntry(this.scrollArea, chooseSourceButton));
        ScrollableScreen.TextEntry indexLabelEntry = new ScrollableScreen.TextEntry(this.scrollArea, Locals.localize((String)"drippyloadingscreen.audio.index", (String[])new String[0]), true);
        indexLabelEntry.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.audio.index.desc", (String[])new String[0]), (String)"%n%"));
        this.scrollArea.addEntry((ScrollAreaEntry)indexLabelEntry);
        AdvancedTextField indexTextField = new AdvancedTextField(Minecraft.m_91087_().f_91062_, 0, 0, 200, 20, true, CharacterFilter.getIntegerCharacterFiler()){

            public void m_6305_(PoseStack p_93657_, int p_93658_, int p_93659_, float p_93660_) {
                super.m_6305_(p_93657_, p_93658_, p_93659_, p_93660_);
                if (MathUtils.isInteger((String)this.m_94155_().replace(" ", ""))) {
                    EditAudioScreen.this.audio.index = Integer.parseInt(this.m_94155_().replace(" ", ""));
                }
            }
        };
        indexTextField.m_94199_(10000);
        indexTextField.m_94144_("" + this.audio.index);
        ScrollableScreen.TextFieldEntry indexFieldEntry = new ScrollableScreen.TextFieldEntry(this.scrollArea, indexTextField);
        indexFieldEntry.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.audio.index.desc", (String[])new String[0]), (String)"%n%"));
        this.scrollArea.addEntry((ScrollAreaEntry)indexFieldEntry);
        ScrollableScreen.TextEntry volumeLabelEntry = new ScrollableScreen.TextEntry(this.scrollArea, Locals.localize((String)"drippyloadingscreen.audio.volume", (String[])new String[0]), true);
        volumeLabelEntry.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.audio.volume.desc", (String[])new String[0]), (String)"%n%"));
        this.scrollArea.addEntry((ScrollAreaEntry)volumeLabelEntry);
        AdvancedTextField volumeTextField = new AdvancedTextField(Minecraft.m_91087_().f_91062_, 0, 0, 200, 20, true, CharacterFilter.getIntegerCharacterFiler()){

            public void m_6305_(PoseStack p_93657_, int p_93658_, int p_93659_, float p_93660_) {
                super.m_6305_(p_93657_, p_93658_, p_93659_, p_93660_);
                if (MathUtils.isInteger((String)this.m_94155_().replace(" ", ""))) {
                    EditAudioScreen.this.audio.volume = Integer.parseInt(this.m_94155_().replace(" ", ""));
                }
            }
        };
        volumeTextField.m_94199_(10000);
        volumeTextField.m_94144_("" + this.audio.volume);
        ScrollableScreen.TextFieldEntry volumeFieldEntry = new ScrollableScreen.TextFieldEntry(this.scrollArea, volumeTextField);
        volumeFieldEntry.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.audio.volume.desc", (String[])new String[0]), (String)"%n%"));
        this.scrollArea.addEntry((ScrollAreaEntry)volumeFieldEntry);
        this.doneButton = new AdvancedButton(0, 0, 95, 20, Locals.localize((String)"drippyloadingscreen.done", (String[])new String[0]), true, press -> {
            this.onDone();
            Minecraft.m_91087_().m_91152_(this.parent);
        });
        UIBase.colorizeButton(this.doneButton);
        this.cancelButton = new AdvancedButton(0, 0, 95, 20, Locals.localize((String)"drippyloadingscreen.cancel", (String[])new String[0]), true, press -> {
            this.onCancel();
            Minecraft.m_91087_().m_91152_(this.parent);
        });
        UIBase.colorizeButton(this.cancelButton);
    }

    protected AudioCustomizationItem getItem() {
        return (AudioCustomizationItem)this.parentElement.object;
    }

    @Override
    public void m_6305_(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        int xCenter = this.f_96543_ / 2;
        super.m_6305_(matrix, mouseX, mouseY, partialTicks);
        if (!this.isNewAudio) {
            this.doneButton.setX(xCenter - this.doneButton.m_5711_() / 2);
        } else {
            this.doneButton.setX(xCenter + 5);
        }
        this.doneButton.setY(this.f_96544_ - 35);
        this.doneButton.m_6305_(matrix, mouseX, mouseY, partialTicks);
        if (this.isNewAudio) {
            this.cancelButton.setX(xCenter - this.cancelButton.m_5711_() - 5);
            this.cancelButton.setY(this.f_96544_ - 35);
            this.cancelButton.m_6305_(matrix, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public void m_7379_() {
        if (!PopupHandler.isPopupActive()) {
            if (this.isNewAudio) {
                this.onCancel();
            } else {
                this.onDone();
            }
            super.m_7379_();
        }
    }

    protected void onDone() {
        if (this.callback != null) {
            this.callback.accept(this.audio);
        }
    }

    protected void onCancel() {
        if (this.callback != null) {
            this.callback.accept(null);
        }
    }

    public AudioCustomizationItem.MenuAudio getAudio() {
        return this.audio;
    }
}

