/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.customization.items;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.drippyloadingscreen.customization.items.CustomizationItemBase;
import de.keksuccino.drippyloadingscreen.customization.placeholdervalues.PlaceholderTextValueHelper;
import de.keksuccino.drippyloadingscreen.customization.rendering.SimpleTextRenderer;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.awt.Color;

public class StringCustomizationItem
extends CustomizationItemBase {
    public float scale = 1.0f;
    public boolean shadow = false;
    public CustomizationItemBase.Alignment alignment = CustomizationItemBase.Alignment.LEFT;
    public Color textColor = Color.WHITE;
    public String textColorHex = "#ffffff";
    public String valueRaw;

    public StringCustomizationItem(PropertiesSection item) {
        super(item);
        if (this.action != null && this.action.equalsIgnoreCase("addtext")) {
            String sc;
            String sh;
            this.valueRaw = item.getEntryValue("value");
            this.updateValue();
            String tc = item.getEntryValue("textcolor");
            if (tc != null) {
                this.textColorHex = tc;
                this.textColor = RenderUtils.getColorFromHexString((String)tc);
            }
            if ((sh = item.getEntryValue("shadow")) != null && sh.equalsIgnoreCase("true")) {
                this.shadow = true;
            }
            if ((sc = item.getEntryValue("scale")) != null && MathUtils.isFloat((String)sc)) {
                this.scale = Float.parseFloat(sc);
            }
        }
    }

    protected void updateValue() {
        if (this.valueRaw != null) {
            this.value = !StringCustomizationItem.isEditorActive() ? PlaceholderTextValueHelper.convertFromRaw(this.valueRaw) : StringUtils.convertFormatCodes((String)this.valueRaw, (String)"&", (String)"\u00a7");
        }
        this.width = (int)((float)SimpleTextRenderer.getStringWidth(this.value) * this.scale);
        this.height = (int)(10.0f * this.scale);
    }

    @Override
    public void render(PoseStack matrix) {
        if (!this.shouldRender()) {
            return;
        }
        this.updateValue();
        int x = this.getPosX();
        int y = this.getPosY();
        RenderSystem.m_69478_();
        if (this.shadow) {
            SimpleTextRenderer.drawStringWithShadow(matrix, this.value, x, y, this.textColor.getRGB(), this.opacity, this.scale);
        } else {
            SimpleTextRenderer.drawString(matrix, this.value, x, y, this.textColor.getRGB(), this.opacity, this.scale);
        }
        RenderSystem.m_69461_();
    }
}

