/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.customization.helper.editor.elements.custombars;

import de.keksuccino.drippyloadingscreen.customization.helper.editor.LayoutEditorScreen;
import de.keksuccino.drippyloadingscreen.customization.helper.editor.elements.LayoutElement;
import de.keksuccino.drippyloadingscreen.customization.helper.ui.popup.ChooseFilePopup;
import de.keksuccino.drippyloadingscreen.customization.helper.ui.popup.FHTextInputPopup;
import de.keksuccino.drippyloadingscreen.customization.items.CustomizationItemBase;
import de.keksuccino.drippyloadingscreen.customization.items.custombars.CustomBarCustomizationItemBase;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.screens.popup.Popup;
import de.keksuccino.konkrete.gui.screens.popup.PopupHandler;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class LayoutCustomBarBase
extends LayoutElement {
    public LayoutCustomBarBase(CustomBarCustomizationItemBase object, LayoutEditorScreen handler) {
        super(object, true, handler);
    }

    @Override
    public void init() {
        this.stretchable = true;
        super.init();
        this.rightclickMenu.setAutoclose(true);
        AdvancedButton barColorButton = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"drippyloadingscreen.helper.creator.add.custombars.barcolor", (String[])new String[0]), true, press -> {
            FHTextInputPopup pop = new FHTextInputPopup(new Color(0, 0, 0, 0), Locals.localize((String)"drippyloadingscreen.helper.creator.add.custombars.barcolor", (String[])new String[0]), null, 240, call -> {
                if (call != null) {
                    Color c;
                    if (!call.equals(this.getObject().barColorHex)) {
                        this.handler.history.saveSnapshot(this.handler.history.createSnapshot());
                    }
                    if ((c = RenderUtils.getColorFromHexString((String)this.getObject().barColorHex)) != null) {
                        this.getObject().barColorHex = call;
                        this.getObject().updateItem();
                    }
                }
            });
            if (this.getObject().barColorHex != null) {
                pop.setText(this.getObject().barColorHex);
            }
            PopupHandler.displayPopup((Popup)pop);
        });
        this.rightclickMenu.addContent(barColorButton);
        AdvancedButton backgroundColorButton = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"drippyloadingscreen.helper.creator.add.custombars.backgroundcolor", (String[])new String[0]), true, press -> {
            FHTextInputPopup pop = new FHTextInputPopup(new Color(0, 0, 0, 0), Locals.localize((String)"drippyloadingscreen.helper.creator.add.custombars.backgroundcolor", (String[])new String[0]), null, 240, call -> {
                if (call != null) {
                    Color c;
                    if (!call.equals(this.getObject().backgroundColorHex)) {
                        this.handler.history.saveSnapshot(this.handler.history.createSnapshot());
                    }
                    if ((c = RenderUtils.getColorFromHexString((String)this.getObject().backgroundColorHex)) != null) {
                        this.getObject().backgroundColorHex = call;
                        this.getObject().updateItem();
                    }
                }
            });
            if (this.getObject().backgroundColorHex != null) {
                pop.setText(this.getObject().backgroundColorHex);
            }
            PopupHandler.displayPopup((Popup)pop);
        });
        this.rightclickMenu.addContent(backgroundColorButton);
        this.rightclickMenu.addSeparator();
        AdvancedButton barTextureButton = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"drippyloadingscreen.helper.creator.add.custombars.bartexture", (String[])new String[0]), true, press -> {
            ChooseFilePopup pop = new ChooseFilePopup(call -> {
                if (call != null) {
                    if (!call.equals(this.getObject().barTexturePath)) {
                        this.handler.history.saveSnapshot(this.handler.history.createSnapshot());
                    }
                    if (call.replace(" ", "").equals("")) {
                        this.getObject().barTexturePath = null;
                        this.getObject().updateItem();
                    } else {
                        File f = new File((String)call);
                        if (f.exists() && f.isFile() && (f.getPath().toLowerCase().endsWith(".jpg") || f.getPath().toLowerCase().endsWith(".jpeg") || f.getPath().toLowerCase().endsWith(".png"))) {
                            this.getObject().barTexturePath = call;
                            this.getObject().updateItem();
                        }
                    }
                }
            }, "jpg", "jpeg", "png");
            if (this.getObject().barTexturePath != null) {
                pop.setText(this.getObject().barTexturePath);
            }
            PopupHandler.displayPopup((Popup)pop);
        });
        barTextureButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.helper.creator.add.custombars.bartexture.btn.desc", (String[])new String[0]), (String)"%n%"));
        this.rightclickMenu.addContent(barTextureButton);
        AdvancedButton backgroundTextureButton = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"drippyloadingscreen.helper.creator.add.custombars.backgroundtexture", (String[])new String[0]), true, press -> {
            ChooseFilePopup pop = new ChooseFilePopup(call -> {
                if (call != null) {
                    if (!call.equals(this.getObject().backgroundTexturePath)) {
                        this.handler.history.saveSnapshot(this.handler.history.createSnapshot());
                    }
                    if (call.replace(" ", "").equals("")) {
                        this.getObject().backgroundTexturePath = null;
                        this.getObject().updateItem();
                    } else {
                        File f = new File((String)call);
                        if (f.exists() && f.isFile() && (f.getPath().toLowerCase().endsWith(".jpg") || f.getPath().toLowerCase().endsWith(".jpeg") || f.getPath().toLowerCase().endsWith(".png"))) {
                            this.getObject().backgroundTexturePath = call;
                            this.getObject().updateItem();
                        }
                    }
                }
            }, "jpg", "jpeg", "png");
            if (this.getObject().backgroundTexturePath != null) {
                pop.setText(this.getObject().backgroundTexturePath);
            }
            PopupHandler.displayPopup((Popup)pop);
        });
        backgroundTextureButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.helper.creator.add.custombars.backgroundtexture.btn.desc", (String[])new String[0]), (String)"%n%"));
        this.rightclickMenu.addContent(backgroundTextureButton);
        this.rightclickMenu.addSeparator();
        String barDirString = Locals.localize((String)"drippyloadingscreen.helper.creator.add.custombars.direction.left", (String[])new String[0]);
        CustomBarCustomizationItemBase.BarDirection d = this.getObject().direction;
        if (d == CustomBarCustomizationItemBase.BarDirection.RIGHT) {
            barDirString = Locals.localize((String)"drippyloadingscreen.helper.creator.add.custombars.direction.right", (String[])new String[0]);
        }
        if (d == CustomBarCustomizationItemBase.BarDirection.UP) {
            barDirString = Locals.localize((String)"drippyloadingscreen.helper.creator.add.custombars.direction.up", (String[])new String[0]);
        }
        if (d == CustomBarCustomizationItemBase.BarDirection.DOWN) {
            barDirString = Locals.localize((String)"drippyloadingscreen.helper.creator.add.custombars.direction.down", (String[])new String[0]);
        }
        AdvancedButton barDirectionButton = new AdvancedButton(0, 0, 0, 16, barDirString, true, press -> {
            CustomBarCustomizationItemBase.BarDirection bd = this.getObject().direction;
            AdvancedButton b = (AdvancedButton)press;
            if (bd == CustomBarCustomizationItemBase.BarDirection.LEFT) {
                this.getObject().direction = CustomBarCustomizationItemBase.BarDirection.RIGHT;
                b.setMessage(Locals.localize((String)"drippyloadingscreen.helper.creator.add.custombars.direction.right", (String[])new String[0]));
            } else if (bd == CustomBarCustomizationItemBase.BarDirection.RIGHT) {
                this.getObject().direction = CustomBarCustomizationItemBase.BarDirection.UP;
                b.setMessage(Locals.localize((String)"drippyloadingscreen.helper.creator.add.custombars.direction.up", (String[])new String[0]));
            } else if (bd == CustomBarCustomizationItemBase.BarDirection.UP) {
                this.getObject().direction = CustomBarCustomizationItemBase.BarDirection.DOWN;
                b.setMessage(Locals.localize((String)"drippyloadingscreen.helper.creator.add.custombars.direction.down", (String[])new String[0]));
            } else if (bd == CustomBarCustomizationItemBase.BarDirection.DOWN) {
                this.getObject().direction = CustomBarCustomizationItemBase.BarDirection.LEFT;
                b.setMessage(Locals.localize((String)"drippyloadingscreen.helper.creator.add.custombars.direction.left", (String[])new String[0]));
            }
        });
        this.rightclickMenu.addContent(barDirectionButton);
    }

    @Override
    public List<PropertiesSection> getProperties() {
        ArrayList<PropertiesSection> l = new ArrayList<PropertiesSection>();
        l.add(this.getPropertiesRaw());
        return l;
    }

    protected PropertiesSection getPropertiesRaw() {
        PropertiesSection s = new PropertiesSection("customization");
        s.addEntry("actionid", this.object.getActionId());
        if (this.stretchX) {
            s.addEntry("x", "0");
            s.addEntry("width", "%guiwidth%");
        } else {
            s.addEntry("x", "" + this.object.posX);
            s.addEntry("width", "" + this.object.width);
        }
        if (this.stretchY) {
            s.addEntry("y", "0");
            s.addEntry("height", "%guiheight%");
        } else {
            s.addEntry("y", "" + this.object.posY);
            s.addEntry("height", "" + this.object.height);
        }
        s.addEntry("orientation", this.getObject().orientation);
        if (this.object.orientation.equals("loading-progress") && this.object.orientationElementIdentifier != null) {
            s.addEntry("orientation_element", this.object.orientationElementIdentifier);
        }
        s.addEntry("direction", this.getObject().direction.getName());
        if (this.getObject().barColorHex != null) {
            s.addEntry("barcolor", this.getObject().barColorHex);
        }
        if (this.getObject().backgroundColorHex != null) {
            s.addEntry("backgroundcolor", this.getObject().backgroundColorHex);
        }
        if (this.getObject().barTexturePath != null) {
            s.addEntry("bartexture", CustomizationItemBase.fixBackslashPath(this.getObject().barTexturePath));
        }
        if (this.getObject().backgroundTexturePath != null) {
            s.addEntry("backgroundtexture", CustomizationItemBase.fixBackslashPath(this.getObject().backgroundTexturePath));
        }
        if (this.getObject().barEndTexturePath != null) {
            s.addEntry("barendtexture", CustomizationItemBase.fixBackslashPath(this.getObject().barEndTexturePath));
            s.addEntry("barendtexturewidth", "" + this.getObject().barEndTextureWidth);
            s.addEntry("barendtextureheight", "" + this.getObject().barEndTextureHeight);
        }
        this.addVisibilityPropertiesTo(s);
        return s;
    }

    public CustomBarCustomizationItemBase getObject() {
        return (CustomBarCustomizationItemBase)this.object;
    }
}

