/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.api.item.v2;

import de.keksuccino.drippyloadingscreen.api.item.v2.CustomizationItemContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomizationItemRegistry {
    private static final Logger LOGGER = LogManager.getLogger((String)"drippyloadingscreen/CustomizationItemRegistry");
    protected static Map<String, CustomizationItemContainer> customizationItems = new HashMap<String, CustomizationItemContainer>();

    public static void registerItem(CustomizationItemContainer item) {
        if (item != null) {
            if (item.getIdentifier() != null) {
                if (customizationItems.containsKey(item.getIdentifier())) {
                    LOGGER.warn("WARNING: A customization item with the identifier '" + item.getIdentifier() + "' is already registered! Overriding item!");
                }
                customizationItems.put(item.getIdentifier(), item);
            } else {
                LOGGER.error("ERROR: Item identifier cannot be null for CustomizationItemContainers!");
            }
        }
    }

    public static void unregisterItem(String itemIdentifier) {
        customizationItems.remove(itemIdentifier);
    }

    public static List<CustomizationItemContainer> getItems() {
        ArrayList<CustomizationItemContainer> l = new ArrayList<CustomizationItemContainer>();
        l.addAll(customizationItems.values());
        return l;
    }

    public static CustomizationItemContainer getItem(String itemIdentifier) {
        return customizationItems.get(itemIdentifier);
    }
}

