/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.auudio.audio;

import com.mojang.blaze3d.audio.Channel;
import de.keksuccino.auudio.audio.AudioClipSound;
import de.keksuccino.auudio.audio.AudioClipSoundInstance;
import de.keksuccino.auudio.audio.AudioHandler;
import de.keksuccino.auudio.audio.VanillaSoundUtils;
import de.keksuccino.auudio.audio.exceptions.InvalidAudioException;
import de.keksuccino.auudio.audio.external.ExternalSound;
import de.keksuccino.auudio.audio.external.ExternalSoundResourceLocation;
import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.client.sounds.Weighted;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.lwjgl.openal.AL10;

public class AudioClip {
    protected final SoundType soundType;
    protected ResourceLocation soundLocation;
    protected WeighedSoundEvents soundEvents;
    protected AudioClipSound sound;
    protected AudioClipSoundInstance soundInstance;
    protected Channel channel = null;
    protected boolean looping = false;
    protected int volume = 100;
    protected SoundSource soundSource;

    public AudioClip(@Nonnull ResourceLocation soundLocation, @Nonnull SoundType soundType) throws NullPointerException, InvalidAudioException {
        this(soundLocation, soundType, null);
    }

    public AudioClip(@Nonnull ResourceLocation soundLocation, @Nonnull SoundType soundType, @Nullable SoundSource soundSource) throws NullPointerException, InvalidAudioException {
        if (soundLocation == null) {
            throw new NullPointerException("Sound location is NULL!");
        }
        if (soundType == null) {
            throw new NullPointerException("Sound type is NULL!");
        }
        if (soundLocation instanceof ExternalSoundResourceLocation && soundType == SoundType.INTERNAL_ASSET) {
            throw new InvalidAudioException("Trying to load an ExternalSoundResourceLocation as internal asset!");
        }
        if (!(soundLocation instanceof ExternalSoundResourceLocation) && soundType != SoundType.INTERNAL_ASSET) {
            throw new InvalidAudioException("Trying to load an internal asset ResourceLocation as external sound!");
        }
        if (soundLocation instanceof ExternalSoundResourceLocation && ((ExternalSoundResourceLocation)soundLocation).getSoundType() != soundType) {
            throw new InvalidAudioException("Sound type of external sound doesn't match clip sound type!");
        }
        this.soundLocation = soundLocation;
        this.soundType = soundType;
        this.soundSource = soundSource;
        if (this.soundSource == null) {
            this.soundSource = SoundSource.MASTER;
        }
        this.prepare();
        AudioHandler.registerAudioClip(this);
    }

    public static AudioClip buildExternalClip(String soundPath, SoundType soundType, @Nullable SoundSource soundSource) throws InvalidAudioException, NullPointerException {
        return new AudioClip(new ExternalSoundResourceLocation(soundPath, soundType), soundType, soundSource);
    }

    public static AudioClip buildExternalClip(String soundPath, SoundType soundType) throws InvalidAudioException, NullPointerException {
        return AudioClip.buildExternalClip(soundPath, soundType, null);
    }

    public static AudioClip buildInternalClip(ResourceLocation soundLocation, @Nullable SoundSource soundSource) throws InvalidAudioException, NullPointerException {
        return new AudioClip(soundLocation, SoundType.INTERNAL_ASSET, soundSource);
    }

    public static AudioClip buildInternalClip(ResourceLocation soundLocation) throws InvalidAudioException, NullPointerException {
        return AudioClip.buildInternalClip(soundLocation, SoundSource.MASTER);
    }

    public boolean prepare() {
        try {
            this.stop();
            this.channel = null;
            if (this.soundType == SoundType.EXTERNAL_LOCAL || this.soundType == SoundType.EXTERNAL_WEB) {
                this.soundInstance = new AudioClipSoundInstance(this, this.soundLocation, this.soundSource, 1.0f, 1.0f);
                this.soundEvents = new WeighedSoundEvents(this.soundLocation, null);
                this.sound = new ExternalSound((ExternalSoundResourceLocation)this.soundLocation, 1.0f, 1.0f, 1, Sound.Type.FILE, false, 0);
                this.soundEvents.m_120451_((Weighted)this.sound);
                VanillaSoundUtils.getSoundManagerRegistry().put(this.soundLocation, this.soundEvents);
                this.soundEvents.m_8054_(VanillaSoundUtils.getSoundEngine());
                return true;
            }
            if (this.soundType == SoundType.INTERNAL_ASSET) {
                this.soundInstance = new AudioClipSoundInstance(this, this.soundLocation, this.soundSource, 1.0f, 1.0f);
                this.soundEvents = new WeighedSoundEvents(this.soundLocation, null);
                this.sound = new AudioClipSound(this.soundLocation, 1.0f, 1.0f, 1, Sound.Type.FILE, false, false, 0);
                this.soundEvents.m_120451_((Weighted)this.sound);
                VanillaSoundUtils.getSoundManagerRegistry().put(this.soundLocation, this.soundEvents);
                this.soundEvents.m_8054_(VanillaSoundUtils.getSoundEngine());
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public void play() {
        if (!this.playing()) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)this.soundInstance);
            this.channel = VanillaSoundUtils.getChannelOfInstance((SoundInstance)this.soundInstance);
            AudioHandler.updateVolumes();
        }
    }

    public boolean stopped() {
        if (this.channel != null) {
            return this.channel.m_83680_();
        }
        return true;
    }

    public void pause() {
        if (this.playing() && this.channel != null) {
            this.channel.m_83677_();
        }
    }

    public boolean paused() {
        try {
            if (this.channel != null) {
                return AL10.alGetSourcei((int)this.getChannelSource(), (int)4112) == 4115;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public void unpause() {
        if (this.channel != null) {
            this.channel.m_83678_();
        }
    }

    public void stop() {
        if (this.soundInstance != null) {
            Minecraft.m_91087_().m_91106_().m_120399_((SoundInstance)this.soundInstance);
        }
        this.channel = null;
    }

    public boolean playing() {
        if (this.channel != null) {
            return this.channel.m_166126_();
        }
        return false;
    }

    public void setLooping(boolean b) {
        this.looping = b;
    }

    public boolean isLooping() {
        return this.looping;
    }

    public void setVolume(int percentage) {
        if (percentage < 0) {
            percentage = 0;
        }
        if (percentage > 100) {
            percentage = 100;
        }
        this.volume = percentage;
        AudioHandler.updateVolumes();
    }

    public int getVolume() {
        return this.volume;
    }

    public void destroy() {
        this.stop();
        this.sound = null;
        this.soundInstance = null;
        this.soundEvents = null;
        this.soundLocation = null;
        AudioHandler.unregisterAudioClip(this);
    }

    public SoundSource getSoundSource() {
        return this.soundSource;
    }

    public String getSoundPath() {
        return this.soundLocation.m_135815_();
    }

    public SoundType getSoundType() {
        return this.soundType;
    }

    public ResourceLocation getSoundLocation() {
        return this.soundLocation;
    }

    public AudioClipSoundInstance getSoundInstance() {
        return this.soundInstance;
    }

    public AudioClipSound getSound() {
        return this.sound;
    }

    public WeighedSoundEvents getSoundEvents() {
        return this.soundEvents;
    }

    public int getChannelSource() {
        try {
            Field f = ObfuscationReflectionHelper.findField(Channel.class, (String)"f_83642_");
            return (Integer)f.get(this.channel);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static enum SoundType {
        EXTERNAL_WEB,
        EXTERNAL_LOCAL,
        INTERNAL_ASSET;

    }
}

