/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.accessory;

import doggytalents.DoggyAccessories;
import doggytalents.api.inferface.IColoredObject;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.api.registry.AccessoryType;
import doggytalents.common.entity.accessory.ArmourAccessory;
import doggytalents.common.util.ColourCache;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class LeatherArmourAccessory
extends ArmourAccessory {
    public LeatherArmourAccessory(Supplier<? extends AccessoryType> typeIn, Supplier<? extends ItemLike> itemIn) {
        super(typeIn, itemIn);
    }

    @Override
    public AccessoryInstance create(ItemStack armourStack) {
        if (armourStack.m_41619_()) {
            if (this.of(DoggyAccessories.LEATHER_HELMET)) {
                armourStack = new ItemStack((ItemLike)Items.f_42407_);
            } else {
                throw new IllegalArgumentException();
            }
        }
        return new Instance(armourStack.m_41777_());
    }

    @Override
    public AccessoryInstance read(CompoundTag compound) {
        AccessoryInstance inst = super.read(compound);
        if (this.of(DoggyAccessories.LEATHER_HELMET) && compound.m_128425_("color", 99)) {
            int color = compound.m_128451_("color");
            Instance def = inst.cast(Instance.class);
            if (def.armourStack.m_41720_() instanceof DyeableLeatherItem) {
                ((DyeableLeatherItem)def.armourStack.m_41720_()).m_41115_(def.armourStack, color);
            }
            def.color = ColourCache.make(color);
        }
        return inst;
    }

    public class Instance
    extends ArmourAccessory.Instance
    implements IColoredObject {
        private ColourCache color;

        public Instance(ItemStack armourStack) {
            super(armourStack);
            this.color = ColourCache.WHITE;
            if (armourStack.m_41720_() instanceof DyeableLeatherItem) {
                this.color = ColourCache.make(((DyeableLeatherItem)armourStack.m_41720_()).m_41121_(armourStack));
            }
        }

        @Override
        public AccessoryInstance copy() {
            return new Instance(this.armourStack.m_41777_());
        }

        @Override
        public float[] getColor() {
            return this.color.getFloatArray();
        }
    }
}

