/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.model;

import com.google.common.collect.ImmutableList;
import doggytalents.api.inferface.AbstractDogEntity;
import net.minecraft.client.model.ColorableAgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class DogModel<T extends AbstractDogEntity>
extends ColorableAgeableListModel<T> {
    public ModelPart head;
    public ModelPart realHead;
    public ModelPart body;
    public ModelPart mane;
    public ModelPart legBackRight;
    public ModelPart legBackLeft;
    public ModelPart legFrontRight;
    public ModelPart legFrontLeft;
    public ModelPart tail;
    public ModelPart realTail;
    public ModelPart realTail2;
    public ModelPart realTail3;

    public DogModel(ModelPart box) {
        this.head = box.m_171324_("head");
        this.realHead = this.head.m_171324_("real_head");
        this.body = box.m_171324_("body");
        this.mane = box.m_171324_("upper_body");
        this.legBackRight = box.m_171324_("right_hind_leg");
        this.legBackLeft = box.m_171324_("left_hind_leg");
        this.legFrontRight = box.m_171324_("right_front_leg");
        this.legFrontLeft = box.m_171324_("left_front_leg");
        this.tail = box.m_171324_("tail");
        this.realTail = this.tail.m_171324_("real_tail");
        this.realTail2 = this.tail.m_171324_("real_tail_2");
        this.realTail3 = this.tail.m_171324_("real_tail_bushy");
    }

    public static LayerDefinition createBodyLayer() {
        return DogModel.createBodyLayerInternal(CubeDeformation.f_171458_);
    }

    public static LayerDefinition createArmorLayer() {
        return DogModel.createBodyLayerInternal(new CubeDeformation(0.4f, 0.4f, 0.4f));
    }

    private static LayerDefinition createBodyLayerInternal(CubeDeformation scale) {
        MeshDefinition var0 = new MeshDefinition();
        PartDefinition var1 = var0.m_171576_();
        float var2 = 13.5f;
        PartDefinition var3 = var1.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.0f, (float)13.5f, (float)-7.0f));
        var3.m_171599_("real_head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, -3.0f, -2.0f, 6.0f, 6.0f, 4.0f, scale).m_171514_(16, 14).m_171488_(-2.0f, -5.0f, 0.0f, 2.0f, 2.0f, 1.0f, scale).m_171514_(16, 14).m_171488_(2.0f, -5.0f, 0.0f, 2.0f, 2.0f, 1.0f, scale).m_171514_(0, 10).m_171488_(-0.5f, 0.0f, -5.0f, 3.0f, 3.0f, 4.0f, scale).m_171514_(52, 0).m_171488_(-3.0f, -3.0f, -1.5f, 1.0f, 5.0f, 3.0f, scale).m_171514_(52, 0).m_171488_(4.0f, -3.0f, -1.5f, 1.0f, 5.0f, 3.0f, scale).m_171514_(18, 0).m_171488_(-2.8f, -3.5f, -1.0f, 2.0f, 1.0f, 2.0f, scale).m_171514_(18, 0).m_171488_(2.8f, -3.5f, -1.0f, 2.0f, 1.0f, 2.0f, scale), PartPose.f_171404_);
        var1.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(18, 14).m_171488_(-3.0f, -2.0f, -3.0f, 6.0f, 9.0f, 6.0f, scale), PartPose.m_171423_((float)0.0f, (float)14.0f, (float)2.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        var1.m_171599_("upper_body", CubeListBuilder.m_171558_().m_171514_(21, 0).m_171488_(-3.0f, -3.0f, -3.0f, 8.0f, 6.0f, 7.0f, scale), PartPose.m_171423_((float)-1.0f, (float)14.0f, (float)-3.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        CubeListBuilder var4 = CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, scale);
        var1.m_171599_("right_hind_leg", var4, PartPose.m_171419_((float)-2.5f, (float)16.0f, (float)7.0f));
        var1.m_171599_("left_hind_leg", var4, PartPose.m_171419_((float)0.5f, (float)16.0f, (float)7.0f));
        var1.m_171599_("right_front_leg", var4, PartPose.m_171419_((float)-2.5f, (float)16.0f, (float)-4.0f));
        var1.m_171599_("left_front_leg", var4, PartPose.m_171419_((float)0.5f, (float)16.0f, (float)-4.0f));
        PartDefinition var5 = var1.m_171599_("tail", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-1.0f, (float)12.0f, (float)8.0f, (float)0.62831855f, (float)0.0f, (float)0.0f));
        var5.m_171599_("real_tail", CubeListBuilder.m_171558_().m_171514_(9, 18).m_171488_(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, scale), PartPose.f_171404_);
        var5.m_171599_("real_tail_2", CubeListBuilder.m_171558_().m_171514_(45, 0).m_171488_(0.0f, 0.0f, 0.0f, 2.0f, 3.0f, 1.0f, scale), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)0.0f));
        var5.m_171599_("real_tail_bushy", CubeListBuilder.m_171558_().m_171514_(43, 19).m_171488_(-1.0f, 0.0f, -2.0f, 3.0f, 10.0f, 3.0f, scale), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)var0, (int)64, (int)32);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body, (Object)this.legBackRight, (Object)this.legBackLeft, (Object)this.legFrontRight, (Object)this.legFrontLeft, (Object)this.tail, (Object)this.mane);
    }

    public void prepareMobModel(T dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.tail.f_104204_ = dog.getWagAngle(limbSwing, limbSwingAmount, partialTickTime);
        if (dog.m_21825_()) {
            if (dog.isLying()) {
                this.head.m_104227_(-1.0f, 19.5f, -7.0f);
                this.body.m_104227_(0.0f, 20.0f, 2.0f);
                this.body.f_104203_ = 1.5707964f;
                this.mane.m_104227_(-1.0f, 20.0f, -2.0f);
                this.mane.f_104203_ = this.body.f_104203_;
                this.tail.m_104227_(-1.0f, 18.0f, 8.0f);
                this.legBackRight.m_104227_(-4.5f, 23.0f, 7.0f);
                this.legBackRight.f_104203_ = -1.5707964f;
                this.legBackLeft.m_104227_(2.5f, 23.0f, 7.0f);
                this.legBackLeft.f_104203_ = -1.5707964f;
                this.legFrontRight.m_104227_(-4.5f, 23.0f, -4.0f);
                this.legFrontRight.f_104203_ = -1.5707964f;
                this.legFrontLeft.m_104227_(2.5f, 23.0f, -4.0f);
                this.legFrontLeft.f_104203_ = -1.5707964f;
            } else {
                if (dog.isLying()) {
                    // empty if block
                }
                this.head.m_104227_(-1.0f, 13.5f, -7.0f);
                this.mane.m_104227_(-1.0f, 16.0f, -3.0f);
                this.mane.f_104203_ = 1.2566371f;
                this.mane.f_104204_ = 0.0f;
                this.body.m_104227_(0.0f, 18.0f, 0.0f);
                this.body.f_104203_ = 0.7853982f;
                this.tail.m_104227_(-0.5f, 21.0f, 6.0f);
                this.legBackRight.m_104227_(-2.5f, 22.0f, 2.0f);
                this.legBackRight.f_104203_ = 4.712389f;
                this.legBackLeft.m_104227_(0.5f, 22.0f, 2.0f);
                this.legBackLeft.f_104203_ = 4.712389f;
                this.legFrontRight.f_104203_ = 5.811947f;
                this.legFrontRight.m_104227_(-2.49f, 17.0f, -4.0f);
                this.legFrontLeft.f_104203_ = 5.811947f;
                this.legFrontLeft.m_104227_(0.51f, 17.0f, -4.0f);
                this.head.m_104227_(-1.0f, 13.5f, -7.0f);
                this.legFrontRight.f_104204_ = 0.0f;
                this.legFrontLeft.f_104204_ = 0.0f;
            }
        } else {
            this.body.m_104227_(0.0f, 14.0f, 2.0f);
            this.body.f_104203_ = 1.5707964f;
            this.mane.m_104227_(-1.0f, 14.0f, -3.0f);
            this.mane.f_104203_ = this.body.f_104203_;
            this.tail.m_104227_(-0.5f, 12.0f, 8.0f);
            this.legBackRight.m_104227_(-2.5f, 16.0f, 7.0f);
            this.legBackLeft.m_104227_(0.5f, 16.0f, 7.0f);
            this.legFrontRight.m_104227_(-2.5f, 16.0f, -4.0f);
            this.legFrontLeft.m_104227_(0.5f, 16.0f, -4.0f);
            this.legBackRight.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.legBackLeft.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.legFrontRight.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.legFrontLeft.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.head.m_104227_(-1.0f, 13.5f, -7.0f);
            this.legFrontRight.f_104204_ = 0.0f;
            this.legFrontLeft.f_104204_ = 0.0f;
        }
        this.realHead.f_104205_ = dog.getInterestedAngle(partialTickTime) + dog.getShakeAngle(partialTickTime, 0.0f);
        this.mane.f_104205_ = dog.getShakeAngle(partialTickTime, -0.08f);
        this.body.f_104205_ = dog.getShakeAngle(partialTickTime, -0.16f);
        this.realTail.f_104205_ = dog.getShakeAngle(partialTickTime, -0.2f);
        this.realTail2.f_104205_ = dog.getShakeAngle(partialTickTime, -0.2f);
        this.realTail3.f_104205_ = dog.getShakeAngle(partialTickTime, -0.2f);
    }

    public void setupAnim(T dogIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.head.f_104204_ = netHeadYaw * (dogIn.m_21825_() && dogIn.isLying() ? 0.005f : (float)Math.PI / 180);
        this.tail.f_104203_ = ageInTicks;
    }

    public void setVisible(boolean visible) {
        this.head.f_104207_ = visible;
        this.body.f_104207_ = visible;
        this.legBackRight.f_104207_ = visible;
        this.legBackLeft.f_104207_ = visible;
        this.legFrontRight.f_104207_ = visible;
        this.legFrontLeft.f_104207_ = visible;
        this.tail.f_104207_ = visible;
        this.mane.f_104207_ = visible;
    }
}

