/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.item;

import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.Stream;
import mod.chiselsandbits.api.blockinformation.BlockInformation;
import mod.chiselsandbits.api.change.IChangeTrackerManager;
import mod.chiselsandbits.api.exceptions.SpaceOccupiedException;
import mod.chiselsandbits.api.item.chiseled.IChiseledBlockItem;
import mod.chiselsandbits.api.item.multistate.IMultiStateItemStack;
import mod.chiselsandbits.api.modification.operation.IModificationOperation;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.mutator.IMutatorFactory;
import mod.chiselsandbits.api.multistate.mutator.batched.IBatchMutation;
import mod.chiselsandbits.api.multistate.mutator.world.IWorldAreaMutator;
import mod.chiselsandbits.api.multistate.snapshot.IMultiStateSnapshot;
import mod.chiselsandbits.api.util.BlockStateUtils;
import mod.chiselsandbits.api.util.HelpTextUtils;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.item.multistate.SingleBlockMultiStateItemStack;
import mod.chiselsandbits.multistate.snapshot.SimpleSnapshot;
import mod.chiselsandbits.registrars.ModModificationOperation;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChiseledBlockItem
extends BlockItem
implements IChiseledBlockItem {
    private static final Supplier<ItemStack> DEFAULT_INSTANCE = Suppliers.memoize(() -> {
        Random random = new Random();
        int blockStateCount = StateEntrySize.current().getBitsPerBlockSide() / 4 * (StateEntrySize.current().getBitsPerBlockSide() / 4) * (StateEntrySize.current().getBitsPerBlockSide() / 4);
        ArrayList<BlockInformation> blockInformation = new ArrayList<BlockInformation>(blockStateCount);
        for (int i = 0; i < blockStateCount; ++i) {
            blockInformation.add(BlockStateUtils.getRandomSupportedInformation(random));
        }
        SimpleSnapshot results = new SimpleSnapshot(BlockInformation.AIR);
        results.mutableStream().forEach(stateEntryInfo -> {
            Vec3 pos = stateEntryInfo.getStartPoint().m_82559_(StateEntrySize.current().getBitsPerBlockSideScalingVector());
            Vec3 indexPos = pos.m_82542_(0.25, 0.25, 0.25);
            Vec3i index = new Vec3i(indexPos.m_7096_(), indexPos.m_7098_(), indexPos.m_7094_());
            int size = StateEntrySize.current().getBitsPerBlockSide() / 4;
            int blockInformationIndex = index.m_123341_() + index.m_123342_() * size + index.m_123343_() * size * size;
            BlockInformation info = (BlockInformation)blockInformation.get(blockInformationIndex);
            stateEntryInfo.overrideState(info);
        });
        ItemStack stack = results.toItemStack().toBlockStack();
        stack.m_41784_().m_128379_("default_instance_indicator", true);
        return stack;
    });

    public ChiseledBlockItem(Block blockIn, Item.Properties builder) {
        super(blockIn, builder);
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack stack) {
        if (stack.m_41784_().m_128441_("default_instance_indicator") && stack.m_41784_().m_128471_("default_instance_indicator")) {
            return LocalStrings.DefaultChiseledBlockItemName.getText();
        }
        return super.m_7626_(stack);
    }

    @Override
    @NotNull
    public IMultiStateItemStack createItemStack(ItemStack stack) {
        return new SingleBlockMultiStateItemStack(stack);
    }

    @NotNull
    public InteractionResult m_40576_(@NotNull BlockPlaceContext context) {
        IMultiStateItemStack source = this.createItemStack(context.m_43722_());
        IWorldAreaMutator areaMutator = context.m_43723_().m_6047_() ? IMutatorFactory.getInstance().covering((LevelAccessor)context.m_43725_(), context.m_43720_(), context.m_43720_().m_82520_(1.0, 1.0, 1.0)) : IMutatorFactory.getInstance().in((LevelAccessor)context.m_43725_(), context.m_8083_());
        IMultiStateSnapshot attemptTarget = areaMutator.createSnapshot();
        boolean noCollisions = ((Stream)source.stream().sequential()).allMatch(stateEntryInfo -> {
            try {
                attemptTarget.setInAreaTarget(stateEntryInfo.getBlockInformation(), stateEntryInfo.getStartPoint());
                return true;
            }
            catch (SpaceOccupiedException exception) {
                return false;
            }
        });
        if (noCollisions) {
            try (IBatchMutation ignored = areaMutator.batch(IChangeTrackerManager.getInstance().getChangeTracker(context.m_43723_()));){
                ((Stream)source.stream().sequential()).forEach(stateEntryInfo -> {
                    try {
                        areaMutator.setInAreaTarget(stateEntryInfo.getBlockInformation(), stateEntryInfo.getStartPoint());
                    }
                    catch (SpaceOccupiedException spaceOccupiedException) {
                        // empty catch block
                    }
                });
            }
            if (context.m_43723_() == null || !context.m_43723_().m_7500_()) {
                context.m_43722_().m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        HelpTextUtils.build(LocalStrings.HelpBitBag, tooltip, new Object[0]);
    }

    @Override
    public boolean canPlace(ItemStack heldStack, Player playerEntity, BlockHitResult blockRayTraceResult) {
        IMultiStateItemStack source = this.createItemStack(heldStack);
        Vec3 target = this.getTargetedBlockPos(heldStack, playerEntity, blockRayTraceResult);
        IWorldAreaMutator areaMutator = IMutatorFactory.getInstance().covering((LevelAccessor)playerEntity.f_19853_, target, target.m_82520_(1.0, 1.0, 1.0));
        IMultiStateSnapshot attemptTarget = areaMutator.createSnapshot();
        return source.stream().allMatch(stateEntryInfo -> {
            try {
                attemptTarget.setInAreaTarget(stateEntryInfo.getBlockInformation(), stateEntryInfo.getStartPoint());
                return true;
            }
            catch (SpaceOccupiedException exception) {
                return false;
            }
        });
    }

    @NotNull
    public ItemStack m_7968_() {
        return DEFAULT_INSTANCE.get();
    }

    @Override
    @NotNull
    public IModificationOperation getMode(ItemStack stack) {
        return ModModificationOperation.ROTATE_AROUND_X.get();
    }

    @Override
    public void setMode(ItemStack stack, IModificationOperation mode) {
        IMultiStateItemStack multiStateItemStack = this.createItemStack(stack);
        mode.apply(multiStateItemStack);
    }

    @Override
    @NotNull
    public Collection<IModificationOperation> getPossibleModes() {
        return ModModificationOperation.REGISTRY_SUPPLIER.get().getValues();
    }

    @Override
    public boolean requiresUpdateOnClosure() {
        return false;
    }
}

