/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.forge.platform.plugin;

import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Collectors;
import mod.chiselsandbits.api.util.ClassUtils;
import mod.chiselsandbits.api.util.GroupingUtils;
import mod.chiselsandbits.platforms.core.plugin.IPlatformPluginManager;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

public class ForgePluginManager
implements IPlatformPluginManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ForgePluginManager INSTANCE = new ForgePluginManager();

    public static ForgePluginManager getInstance() {
        return INSTANCE;
    }

    private ForgePluginManager() {
    }

    @Override
    public <A, I extends Annotation, T> Collection<T> loadPlugins(Class<A> annotationType, Class<I> instanceAnnotationType, Class<T> pluginSpecificationType, Function<T, String> idExtractor) {
        Type pluginType = Type.getType(annotationType);
        ModList modList = ModList.get();
        ArrayList<T> plugins = new ArrayList<T>();
        for (ModFileScanData scanData : modList.getAllScanData()) {
            for (ModFileScanData.AnnotationData data : scanData.getAnnotations()) {
                T plugin;
                ArrayList requiredMods;
                if (!pluginType.equals((Object)data.annotationType()) || (requiredMods = (ArrayList)data.annotationData().get("requiredMods")) != null && requiredMods.size() > 0 && requiredMods.stream().anyMatch(modId -> !ModList.get().isLoaded(modId)) || (plugin = ForgePluginManager.createPluginFrom(data.memberName(), pluginSpecificationType, instanceAnnotationType, idExtractor)) == null) continue;
                plugins.add(plugin);
                LOGGER.info("Found and loaded ChiselsAndBits plugin: {}", (Object)idExtractor.apply(plugin));
            }
        }
        Collection groupedByIds = GroupingUtils.groupByUsingSet(plugins, idExtractor);
        Collection idsWithDuplicates = groupedByIds.stream().filter(p -> p.size() > 1).map(p -> p.iterator().next()).map(idExtractor).collect(Collectors.toSet());
        if (idsWithDuplicates.size() > 0) {
            throw new RuntimeException(String.format("Can not load C&B there are multiple instances of the plugins: [%s]", String.join((CharSequence)", ", idsWithDuplicates)));
        }
        return ImmutableSet.copyOf(plugins);
    }

    @Nullable
    private static <T, I extends Annotation> T createPluginFrom(String className, Class<T> pluginSpecificationType, Class<I> instanceAnnotationType, Function<T, String> idExtractor) {
        return ClassUtils.createOrGetInstance(className, pluginSpecificationType, instanceAnnotationType, idExtractor);
    }
}

