/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.model.baked.face;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import mod.chiselsandbits.api.blockinformation.BlockInformation;
import mod.chiselsandbits.api.client.color.IBlockInformationColorManager;
import mod.chiselsandbits.api.config.IClientConfiguration;
import mod.chiselsandbits.client.model.baked.face.model.ModelQuadLayer;
import mod.chiselsandbits.client.model.baked.face.model.ModelVertexRange;
import mod.chiselsandbits.client.model.baked.simple.SimpleGeneratedModel;
import mod.chiselsandbits.platforms.core.client.rendering.IRenderingManager;
import mod.chiselsandbits.platforms.core.client.rendering.type.IRenderTypeManager;
import mod.chiselsandbits.platforms.core.fluid.FluidInformation;
import mod.chiselsandbits.platforms.core.fluid.IFluidManager;
import mod.chiselsandbits.platforms.core.registries.IPlatformRegistryManager;
import mod.chiselsandbits.utils.ItemStackUtils;
import mod.chiselsandbits.utils.LightUtil;
import mod.chiselsandbits.utils.SimpleMaxSizedCache;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public final class FaceManager {
    private static final Random RANDOM = new Random();
    private static final FaceManager INSTANCE = new FaceManager();
    private final SimpleMaxSizedCache<Key, ModelQuadLayer[]> cache = new SimpleMaxSizedCache(((Supplier<Long>)IClientConfiguration.getInstance().getFaceLayerCacheSize())::get);
    private final SimpleMaxSizedCache<BlockInformation, Integer> colorCache = new SimpleMaxSizedCache(() -> IPlatformRegistryManager.getInstance().getBlockStateIdMap().m_183450_() == 0 ? 1000 : IPlatformRegistryManager.getInstance().getBlockStateIdMap().m_183450_());

    private FaceManager() {
    }

    public static FaceManager getInstance() {
        return INSTANCE;
    }

    public void clearCache() {
        this.cache.clear();
        this.colorCache.clear();
    }

    public ModelQuadLayer[] getCachedFace(BlockInformation state, Direction face, RenderType layer, long primaryStateRenderSeed) {
        if (layer == null) {
            return null;
        }
        Key key = new Key(state, layer, face, primaryStateRenderSeed);
        return this.cache.get(key, () -> {
            Optional<RenderType> original = IRenderTypeManager.getInstance().getCurrentRenderType();
            try {
                IRenderTypeManager.getInstance().setCurrentRenderType(layer);
                ModelQuadLayer[] modelQuadLayerArray = this.buildFaceQuadLayers(state, face, primaryStateRenderSeed);
                return modelQuadLayerArray;
            }
            finally {
                IRenderTypeManager.getInstance().setCurrentRenderType(original.orElse(null));
            }
        });
    }

    private ModelQuadLayer[] buildFaceQuadLayers(BlockInformation state, Direction face, long primaryStateRenderSeed) {
        BakedModel model = FaceManager.solveModel(state, Minecraft.m_91087_().m_91289_().m_110907_().m_110893_(state.getBlockState()), primaryStateRenderSeed);
        int lv = IClientConfiguration.getInstance().getUseGetLightValue().get() != false ? state.getBlockState().m_60791_() : 0;
        Fluid fluid = state.getBlockState().m_60819_().m_76152_();
        if (fluid != Fluids.f_76191_) {
            ModelQuadLayer[] mp = new ModelQuadLayer[]{new ModelQuadLayer()};
            mp[0].setColor(IFluidManager.getInstance().getFluidColor(new FluidInformation(fluid)));
            mp[0].setLight(lv);
            float V = 0.5f;
            float Uf = 1.0f;
            float U = 0.5f;
            float Vf = 1.0f;
            if (face.m_122434_() == Direction.Axis.Y) {
                mp[0].setSprite((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(IRenderingManager.getInstance().getStillFluidTexture(fluid)));
                mp[0].setUvs(new float[]{1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f});
            } else if (face.m_122434_() == Direction.Axis.X) {
                mp[0].setSprite((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(IRenderingManager.getInstance().getFlowingFluidTexture(fluid)));
                mp[0].setUvs(new float[]{0.5f, 0.0f, 0.5f, 0.5f, 0.0f, 0.0f, 0.0f, 0.5f});
            } else {
                mp[0].setSprite((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(IRenderingManager.getInstance().getFlowingFluidTexture(fluid)));
                mp[0].setUvs(new float[]{0.5f, 0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 0.0f, 0.5f});
            }
            mp[0].setTint(0);
            return mp;
        }
        ArrayList layers = Lists.newArrayList();
        int color = this.getColorFor(state);
        if (model != null) {
            List<BakedQuad> quads = FaceManager.getModelQuads(model, state, face, primaryStateRenderSeed);
            FaceManager.processFaces(layers, face, quads);
        }
        ModelQuadLayer[] quadLayers = new ModelQuadLayer[layers.size()];
        for (int layerIndex = 0; layerIndex < layers.size(); ++layerIndex) {
            quadLayers[layerIndex] = ((ModelQuadLayer.ModelQuadLayerBuilder)layers.get(layerIndex)).build(state, color, lv);
        }
        return quadLayers;
    }

    private static void processFaces(List<ModelQuadLayer.ModelQuadLayerBuilder> layers, Direction face, List<BakedQuad> quads) {
        for (BakedQuad quad : quads) {
            if (quad.m_111306_() != face) {
                return;
            }
            try {
                TextureAtlasSprite sprite = FaceManager.findQuadTexture(quad);
                ModelQuadLayer.ModelQuadLayerBuilder layerBuilder = null;
                for (ModelQuadLayer.ModelQuadLayerBuilder builder : layers) {
                    if (builder.getCache().getSprite() != sprite) continue;
                    layerBuilder = builder;
                    break;
                }
                if (layerBuilder == null) {
                    int uCoord = 0;
                    int vCoord = 2;
                    switch (face) {
                        case NORTH: 
                        case SOUTH: {
                            vCoord = 1;
                            break;
                        }
                        case EAST: 
                        case WEST: {
                            uCoord = 1;
                            break;
                        }
                    }
                    layerBuilder = new ModelQuadLayer.ModelQuadLayerBuilder(sprite, uCoord, vCoord);
                    layerBuilder.getCache().setTint(quad.m_111305_());
                    layers.add(layerBuilder);
                }
                LightUtil.put(layerBuilder.getUvExtractor(), quad);
                if (!IClientConfiguration.getInstance().getEnableFaceLightmapExtraction().get().booleanValue()) continue;
                layerBuilder.getLightValueExtractor().setVertexFormat(DefaultVertexFormat.f_85811_);
                LightUtil.put(layerBuilder.getLightValueExtractor(), quad);
            }
            catch (Exception exception) {}
        }
    }

    private static BakedModel solveModel(BlockInformation state, BakedModel originalModel, long primaryStateRenderSeed) {
        ItemStack is;
        boolean hasFaces;
        try {
            hasFaces = FaceManager.hasFaces(originalModel, state, null, primaryStateRenderSeed);
            for (Direction f : Direction.values()) {
                hasFaces = hasFaces || FaceManager.hasFaces(originalModel, state, f, primaryStateRenderSeed);
            }
        }
        catch (Exception e) {
            hasFaces = false;
        }
        if (!hasFaces && !(is = ItemStackUtils.getItemStackFromBlockState(state)).m_41619_()) {
            BakedModel itemModel = Minecraft.m_91087_().m_91291_().m_174264_(is, (Level)Minecraft.m_91087_().f_91073_, (LivingEntity)Minecraft.m_91087_().f_91074_, 0);
            try {
                hasFaces = FaceManager.hasFaces(originalModel, state, null, primaryStateRenderSeed);
                for (Direction f : Direction.values()) {
                    hasFaces = hasFaces || FaceManager.hasFaces(originalModel, state, f, primaryStateRenderSeed);
                }
            }
            catch (Exception e) {
                hasFaces = false;
            }
            if (hasFaces) {
                return itemModel;
            }
            return new SimpleGeneratedModel(FaceManager.findTexture(state, originalModel, Direction.UP, primaryStateRenderSeed));
        }
        return originalModel;
    }

    private static boolean hasFaces(BakedModel model, BlockInformation state, Direction f, long primaryStateRenderSeed) {
        List<BakedQuad> quads = FaceManager.getModelQuads(model, state, f, primaryStateRenderSeed);
        if (quads == null || quads.isEmpty()) {
            return false;
        }
        TextureAtlasSprite texture = null;
        try {
            texture = FaceManager.findTexture(null, quads, f);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ModelVertexRange vertexRangeExtractor = new ModelVertexRange();
        for (BakedQuad quad : quads) {
            LightUtil.put(vertexRangeExtractor, quad);
        }
        return vertexRangeExtractor.getLargestRange() > 0.0f && !FaceManager.isMissingTexture(texture);
    }

    public static TextureAtlasSprite findTexture(BlockInformation state, BakedModel model, Direction myFace, long primaryStateRenderSeed) {
        TextureAtlasSprite texture = null;
        if (model != null) {
            try {
                texture = FaceManager.findTexture(null, FaceManager.getModelQuads(model, state, myFace, primaryStateRenderSeed), myFace);
                if (texture == null) {
                    for (Direction side : Direction.values()) {
                        texture = FaceManager.findTexture(texture, FaceManager.getModelQuads(model, state, side, primaryStateRenderSeed), side);
                    }
                    texture = FaceManager.findTexture(texture, FaceManager.getModelQuads(model, state, null, primaryStateRenderSeed), null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (FaceManager.isMissingTexture(texture)) {
            try {
                if (model != null) {
                    texture = model.m_6160_();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (FaceManager.isMissingTexture(texture)) {
            try {
                texture = Minecraft.m_91087_().m_91289_().m_110907_().m_110882_(state.getBlockState());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (texture == null) {
            texture = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("missingno"));
        }
        return texture;
    }

    private static TextureAtlasSprite findTexture(TextureAtlasSprite texture, List<BakedQuad> faceQuads, Direction myFace) throws IllegalArgumentException, NullPointerException {
        for (BakedQuad q : faceQuads) {
            if (q.m_111306_() != myFace) continue;
            texture = FaceManager.findQuadTexture(q);
        }
        return texture;
    }

    private static TextureAtlasSprite findQuadTexture(BakedQuad q) throws IllegalArgumentException, NullPointerException {
        if (q.m_173410_() == null) {
            return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(MissingTextureAtlasSprite.m_118071_());
        }
        return q.m_173410_();
    }

    private static boolean isMissingTexture(TextureAtlasSprite sprite) {
        if (sprite == null) {
            return true;
        }
        return sprite.m_118413_().equals((Object)MissingTextureAtlasSprite.m_118071_());
    }

    private static List<BakedQuad> getModelQuads(BakedModel model, BlockInformation state, Direction f, long primaryStateRenderSeed) {
        try {
            RANDOM.setSeed(primaryStateRenderSeed);
            return model.m_6840_(state.getBlockState(), f, RANDOM);
        }
        catch (Throwable throwable) {
            try {
                return model.m_6840_(null, f, RANDOM);
            }
            catch (Throwable throwable2) {
                BakedModel secondModel;
                ItemStack is = ItemStackUtils.getItemStackFromBlockState(state);
                if (!is.m_41619_() && (secondModel = FaceManager.getOverrides(model).m_173464_(model, is, Minecraft.m_91087_().f_91073_, (LivingEntity)Minecraft.m_91087_().f_91074_, 0)) != null) {
                    try {
                        return secondModel.m_6840_(null, f, RANDOM);
                    }
                    catch (Throwable throwable3) {
                        // empty catch block
                    }
                }
                return Collections.emptyList();
            }
        }
    }

    private static ItemOverrides getOverrides(BakedModel model) {
        if (model != null) {
            return model.m_7343_();
        }
        return ItemOverrides.f_111734_;
    }

    private int getColorFor(BlockInformation state) {
        return this.colorCache.get(state, () -> {
            ItemStack target;
            Optional<Integer> dynamicColor = IBlockInformationColorManager.getInstance().getColor(state);
            if (dynamicColor.isPresent()) {
                return dynamicColor.get();
            }
            Fluid fluid = state.getBlockState().m_60819_().m_76152_();
            int out = fluid != Fluids.f_76191_ ? IFluidManager.getInstance().getFluidColor(fluid) : ((target = ItemStackUtils.getItemStackFromBlockState(state)).m_41619_() ? 0xFFFFFF : Minecraft.m_91087_().f_91041_.m_92676_(target, 0));
            return out;
        });
    }

    private record Key(BlockInformation blockState, RenderType renderType, Direction direction, long primaryStateSeed) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key key = (Key)o;
            if (this.primaryStateSeed != key.primaryStateSeed) {
                return false;
            }
            if (!Objects.equals(this.blockState, key.blockState)) {
                return false;
            }
            if (!Objects.equals(this.renderType, key.renderType)) {
                return false;
            }
            return this.direction == key.direction;
        }

        @Override
        public int hashCode() {
            int result = this.blockState != null ? this.blockState.hashCode() : 0;
            result = 31 * result + (this.renderType != null ? this.renderType.hashCode() : 0);
            result = 31 * result + (this.direction != null ? this.direction.hashCode() : 0);
            result = 31 * result + (int)(this.primaryStateSeed ^ this.primaryStateSeed >>> 32);
            return result;
        }
    }
}

